/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.javaviewer;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class JavaLineStyler
implements LineStyleListener {
    JavaScanner scanner = new JavaScanner();
    int[] tokenColors;
    Color[] colors;
    Vector blockComments = new Vector();
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int MAXIMUM_TOKEN = 8;

    public JavaLineStyler() {
        this.initializeColors();
        this.scanner = new JavaScanner();
    }

    Color getColor(int n) {
        if (n < 0 || n >= this.tokenColors.length) {
            return null;
        }
        return this.colors[this.tokenColors[n]];
    }

    boolean inBlockComment(int n, int n2) {
        for (int i = 0; i < this.blockComments.size(); ++i) {
            int[] nArray = (int[])this.blockComments.elementAt(i);
            if (nArray[0] >= n && nArray[0] <= n2) {
                return true;
            }
            if (nArray[1] >= n && nArray[1] <= n2) {
                return true;
            }
            if (nArray[0] > n || nArray[1] < n2) continue;
            return true;
        }
        return false;
    }

    void initializeColors() {
        Display display = Display.getDefault();
        this.colors = new Color[]{new Color((Device)display, new RGB(0, 0, 0)), new Color((Device)display, new RGB(255, 0, 0)), new Color((Device)display, new RGB(0, 255, 0)), new Color((Device)display, new RGB(0, 0, 255))};
        this.tokenColors = new int[8];
        this.tokenColors[0] = 0;
        this.tokenColors[1] = 0;
        this.tokenColors[2] = 3;
        this.tokenColors[3] = 1;
        this.tokenColors[5] = 2;
        this.tokenColors[6] = 0;
        this.tokenColors[7] = 0;
    }

    void disposeColors() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i].dispose();
        }
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        Vector<StyleRange> vector = new Vector<StyleRange>();
        if (this.inBlockComment(lineStyleEvent.lineOffset, lineStyleEvent.lineOffset + lineStyleEvent.lineText.length())) {
            vector.addElement(new StyleRange(lineStyleEvent.lineOffset, lineStyleEvent.lineText.length(), this.getColor(3), null));
            lineStyleEvent.styles = new StyleRange[vector.size()];
            vector.copyInto(lineStyleEvent.styles);
            return;
        }
        Color color = ((Control)lineStyleEvent.widget).getForeground();
        this.scanner.setRange(lineStyleEvent.lineText);
        int n = this.scanner.nextToken();
        while (n != -1) {
            if (n != 6) {
                StyleRange styleRange;
                if (n != 1) {
                    Color color2 = this.getColor(n);
                    if (!color2.equals((Object)color) || n == 2) {
                        StyleRange styleRange2 = new StyleRange(this.scanner.getStartOffset() + lineStyleEvent.lineOffset, this.scanner.getLength(), color2, null);
                        if (n == 2) {
                            styleRange2.fontStyle = 1;
                        }
                        if (vector.isEmpty()) {
                            vector.addElement(styleRange2);
                        } else {
                            styleRange = (StyleRange)vector.lastElement();
                            if (styleRange.similarTo(styleRange2) && styleRange.start + styleRange.length == styleRange2.start) {
                                styleRange.length += styleRange2.length;
                            } else {
                                vector.addElement(styleRange2);
                            }
                        }
                    }
                } else if (!vector.isEmpty()) {
                    styleRange = (StyleRange)vector.lastElement();
                    if (styleRange.fontStyle == 1) {
                        int n2 = this.scanner.getStartOffset() + lineStyleEvent.lineOffset;
                        styleRange = (StyleRange)vector.lastElement();
                        if (styleRange.start + styleRange.length == n2) {
                            styleRange.length += this.scanner.getLength();
                        }
                    }
                }
            }
            n = this.scanner.nextToken();
        }
        lineStyleEvent.styles = new StyleRange[vector.size()];
        vector.copyInto(lineStyleEvent.styles);
    }

    public void parseBlockComments(String string) {
        this.blockComments = new Vector();
        StringReader stringReader = new StringReader(string);
        boolean bl = false;
        int n = 0;
        int[] nArray = new int[2];
        boolean bl2 = false;
        try {
            block7: while (!bl2) {
                int n2 = stringReader.read();
                switch (n2) {
                    case -1: {
                        if (bl) {
                            nArray[1] = n;
                            this.blockComments.addElement(nArray);
                        }
                        bl2 = true;
                        continue block7;
                    }
                    case 47: {
                        n2 = stringReader.read();
                        if (n2 == 42 && !bl) {
                            nArray = new int[2];
                            nArray[0] = n++;
                            bl = true;
                        } else {
                            ++n;
                        }
                        ++n;
                        continue block7;
                    }
                    case 42: {
                        if (bl) {
                            n2 = stringReader.read();
                            ++n;
                            if (n2 == 47) {
                                bl = false;
                                nArray[1] = n;
                                this.blockComments.addElement(nArray);
                            }
                        }
                        ++n;
                        continue block7;
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class JavaScanner {
        protected Hashtable fgKeys = null;
        protected StringBuffer fBuffer = new StringBuffer();
        protected String fDoc;
        protected int fPos;
        protected int fEnd;
        protected int fStartToken;
        protected boolean fEofSeen = false;
        private String[] fgKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

        public JavaScanner() {
            this.initialize();
        }

        public final int getLength() {
            return this.fPos - this.fStartToken;
        }

        void initialize() {
            this.fgKeys = new Hashtable();
            Integer n = 2;
            for (int i = 0; i < this.fgKeywords.length; ++i) {
                this.fgKeys.put(this.fgKeywords[i], n);
            }
        }

        public final int getStartOffset() {
            return this.fStartToken;
        }

        public int nextToken() {
            this.fStartToken = this.fPos;
            int n = this.read();
            switch (n) {
                case -1: {
                    return -1;
                }
                case 47: {
                    n = this.read();
                    if (n == 47) {
                        while ((n = this.read()) != -1 && n != 10) {
                        }
                        this.unread(n);
                        return 3;
                    }
                    this.unread(n);
                    return 6;
                }
                case 39: {
                    while (true) {
                        n = this.read();
                        switch (n) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(n);
                                return 5;
                            }
                            case 92: {
                                n = this.read();
                            }
                        }
                    }
                }
                case 34: {
                    while (true) {
                        n = this.read();
                        switch (n) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(n);
                                return 5;
                            }
                            case 92: {
                                n = this.read();
                            }
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(n = this.read()))) {
                    }
                    this.unread(n);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)n)) {
                while (Character.isWhitespace((char)(n = this.read()))) {
                }
                this.unread(n);
                return 1;
            }
            if (Character.isJavaIdentifierStart((char)n)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)n);
                } while (Character.isJavaIdentifierPart((char)(n = this.read())));
                this.unread(n);
                Integer n2 = (Integer)this.fgKeys.get(this.fBuffer.toString());
                if (n2 != null) {
                    return n2;
                }
                return 0;
            }
            return 6;
        }

        protected int read() {
            if (this.fPos <= this.fEnd) {
                return this.fDoc.charAt(this.fPos++);
            }
            return -1;
        }

        public void setRange(String string) {
            this.fDoc = string;
            this.fPos = 0;
            this.fEnd = this.fDoc.length() - 1;
        }

        protected void unread(int n) {
            if (n != -1) {
                --this.fPos;
            }
        }
    }
}

