/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.javaviewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.javaviewer.JavaLineStyler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class JavaViewer {
    Shell shell;
    StyledText text;
    JavaLineStyler lineStyler = new JavaLineStyler();
    FileDialog fileDialog;
    static ResourceBundle resources = ResourceBundle.getBundle("examples_javaviewer");

    Menu createFileMenu() {
        Menu menu = this.shell.getMenuBar();
        Menu menu2 = new Menu(menu);
        MenuItem menuItem = new MenuItem(menu2, 64);
        menuItem.setText(resources.getString("Open_menuitem"));
        menuItem.setAccelerator(SWT.MOD1 + 79);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaViewer.this.openFile();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resources.getString("Exit_menuitem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaViewer.this.menuFileExit();
            }
        });
        return menu2;
    }

    void createMenuBar() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(resources.getString("File_menuitem"));
        menuItem.setMenu(this.createFileMenu());
    }

    void createShell(Display display) {
        this.shell = new Shell(display);
        this.shell.setText(resources.getString("Window_title"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                JavaViewer.this.lineStyler.disposeColors();
                JavaViewer.this.text.removeLineStyleListener((LineStyleListener)JavaViewer.this.lineStyler);
            }
        });
    }

    void createStyledText() {
        this.text = new StyledText((Composite)this.shell, 2818);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)gridData);
        this.text.addLineStyleListener((LineStyleListener)this.lineStyler);
        this.text.setEditable(false);
        Color color = Display.getDefault().getSystemColor(15);
        this.text.setBackground(color);
    }

    void displayError(String string) {
        MessageBox messageBox = new MessageBox(this.shell, 1);
        messageBox.setMessage(string);
        messageBox.open();
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        JavaViewer javaViewer = new JavaViewer();
        Shell shell = javaViewer.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        this.createShell(display);
        this.createMenuBar();
        this.createStyledText();
        this.shell.setSize(500, 400);
        this.shell.open();
        return this.shell;
    }

    void openFile() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.shell, 4096);
        }
        this.fileDialog.setFilterExtensions(new String[]{"*.java", "*.*"});
        String string = this.fileDialog.open();
        this.open(string);
    }

    void open(String string) {
        String string2;
        FileInputStream fileInputStream;
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = MessageFormat.format(resources.getString("Err_file_no_exist"), file.getName());
            this.displayError(string3);
            return;
        }
        try {
            fileInputStream = new FileInputStream(file.getPath());
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                char[] cArray = new char[2048];
                StringBuffer stringBuffer = new StringBuffer((int)file.length());
                while ((n = bufferedReader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n);
                }
                string2 = stringBuffer.toString();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                String string4 = MessageFormat.format(resources.getString("Err_file_io"), file.getName());
                this.displayError(string4);
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = MessageFormat.format(resources.getString("Err_not_found"), file.getName());
            this.displayError(string5);
            return;
        }
        fileInputStream = this.text.getDisplay();
        fileInputStream.asyncExec(new Runnable(){

            @Override
            public void run() {
                JavaViewer.this.text.setText(string2);
            }
        });
        this.lineStyler.parseBlockComments(string2);
    }

    void menuFileExit() {
        this.shell.close();
    }
}

