/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class GridLayoutTab
extends Tab {
    Text numColumns;
    Button makeColumnsEqualWidth;
    Combo marginHeight;
    Combo marginWidth;
    Combo horizontalSpacing;
    Combo verticalSpacing;
    GridLayout gridLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor vAlignEditor;
    TableEditor hAlignEditor;
    TableEditor hIndentEditor;
    TableEditor hSpanEditor;
    TableEditor vSpanEditor;
    TableEditor hGrabEditor;
    TableEditor vGrabEditor;
    CCombo combo;
    CCombo vAlign;
    CCombo hAlign;
    CCombo hGrab;
    CCombo vGrab;
    Text widthText;
    Text heightText;
    Text hIndent;
    Text hSpan;
    Text vSpan;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int HALIGN_COL = 4;
    final int VALIGN_COL = 5;
    final int HINDENT_COL = 6;
    final int HSPAN_COL = 7;
    final int VSPAN_COL = 8;
    final int HGRAB_COL = 9;
    final int VGRAB_COL = 10;
    final int TOTAL_COLS = 11;

    GridLayoutTab(LayoutExample layoutExample) {
        super(layoutExample);
    }

    @Override
    void createChildWidgets() {
        final TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4 || traverseEvent.detail == 16) {
                    GridLayoutTab.this.resetEditors();
                }
                if (traverseEvent.detail == 2) {
                    GridLayoutTab.this.disposeEditors();
                }
            }
        };
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.vAlignEditor = new TableEditor(this.table);
        this.hAlignEditor = new TableEditor(this.table);
        this.hIndentEditor = new TableEditor(this.table);
        this.hSpanEditor = new TableEditor(this.table);
        this.vSpanEditor = new TableEditor(this.table);
        this.hGrabEditor = new TableEditor(this.table);
        this.vGrabEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                GridLayoutTab.this.resetEditors();
                GridLayoutTab.this.index = GridLayoutTab.this.table.getSelectionIndex();
                Point point = new Point(mouseEvent.x, mouseEvent.y);
                GridLayoutTab.this.newItem = GridLayoutTab.this.table.getItem(point);
                if (GridLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem tableItem = GridLayoutTab.this.comboEditor.getItem();
                if (GridLayoutTab.this.newItem == tableItem || GridLayoutTab.this.newItem != GridLayoutTab.this.lastSelected) {
                    GridLayoutTab.this.lastSelected = GridLayoutTab.this.newItem;
                    return;
                }
                GridLayoutTab.this.table.showSelection();
                GridLayoutTab.this.combo = new CCombo((Composite)GridLayoutTab.this.table, 8);
                GridLayoutTab.this.createComboEditor(GridLayoutTab.this.combo, GridLayoutTab.this.comboEditor);
                GridLayoutTab.this.widthText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.widthText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[2]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.widthText, GridLayoutTab.this.widthEditor, 2);
                GridLayoutTab.this.heightText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.heightText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[3]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.heightText, GridLayoutTab.this.heightEditor, 3);
                String[] stringArray = new String[]{"BEGINNING", "CENTER", "END", "FILL"};
                GridLayoutTab.this.hAlign = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.hAlign.setItems(stringArray);
                GridLayoutTab.this.hAlign.setText(GridLayoutTab.this.newItem.getText(4));
                GridLayoutTab.this.hAlignEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.hAlignEditor.grabHorizontal = true;
                GridLayoutTab.this.hAlignEditor.minimumWidth = 50;
                GridLayoutTab.this.hAlignEditor.setEditor((Control)GridLayoutTab.this.hAlign, GridLayoutTab.this.newItem, 4);
                GridLayoutTab.this.hAlign.addTraverseListener(traverseListener);
                GridLayoutTab.this.vAlign = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.vAlign.setItems(stringArray);
                GridLayoutTab.this.vAlign.setText(GridLayoutTab.this.newItem.getText(5));
                GridLayoutTab.this.vAlignEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.vAlignEditor.grabHorizontal = true;
                GridLayoutTab.this.vAlignEditor.minimumWidth = 50;
                GridLayoutTab.this.vAlignEditor.setEditor((Control)GridLayoutTab.this.vAlign, GridLayoutTab.this.newItem, 5);
                GridLayoutTab.this.vAlign.addTraverseListener(traverseListener);
                GridLayoutTab.this.hIndent = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.hIndent.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[6]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.hIndent, GridLayoutTab.this.hIndentEditor, 6);
                GridLayoutTab.this.hSpan = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.hSpan.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[7]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.hSpan, GridLayoutTab.this.hSpanEditor, 7);
                GridLayoutTab.this.vSpan = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.vSpan.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[8]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.vSpan, GridLayoutTab.this.vSpanEditor, 8);
                String[] stringArray2 = new String[]{"false", "true"};
                GridLayoutTab.this.hGrab = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.hGrab.setItems(stringArray2);
                GridLayoutTab.this.hGrab.setText(GridLayoutTab.this.newItem.getText(9));
                GridLayoutTab.this.hGrabEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.hGrabEditor.grabHorizontal = true;
                GridLayoutTab.this.hGrabEditor.minimumWidth = 50;
                GridLayoutTab.this.hGrabEditor.setEditor((Control)GridLayoutTab.this.hGrab, GridLayoutTab.this.newItem, 9);
                GridLayoutTab.this.hGrab.addTraverseListener(traverseListener);
                GridLayoutTab.this.vGrab = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.vGrab.setItems(stringArray2);
                GridLayoutTab.this.vGrab.setText(GridLayoutTab.this.newItem.getText(10));
                GridLayoutTab.this.vGrabEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.vGrabEditor.grabHorizontal = true;
                GridLayoutTab.this.vGrabEditor.minimumWidth = 50;
                GridLayoutTab.this.vGrabEditor.setEditor((Control)GridLayoutTab.this.vGrab, GridLayoutTab.this.newItem, 10);
                GridLayoutTab.this.vGrab.addTraverseListener(traverseListener);
                block12: for (int i = 0; i < GridLayoutTab.this.table.getColumnCount(); ++i) {
                    Rectangle rectangle = GridLayoutTab.this.newItem.getBounds(i);
                    if (!rectangle.contains(point)) continue;
                    switch (i) {
                        case 1: {
                            GridLayoutTab.this.combo.setFocus();
                            continue block12;
                        }
                        case 2: {
                            GridLayoutTab.this.widthText.setFocus();
                            continue block12;
                        }
                        case 3: {
                            GridLayoutTab.this.heightText.setFocus();
                            continue block12;
                        }
                        case 4: {
                            GridLayoutTab.this.hAlign.setFocus();
                            continue block12;
                        }
                        case 5: {
                            GridLayoutTab.this.vAlign.setFocus();
                            continue block12;
                        }
                        case 6: {
                            GridLayoutTab.this.hIndent.setFocus();
                            continue block12;
                        }
                        case 7: {
                            GridLayoutTab.this.hSpan.setFocus();
                            continue block12;
                        }
                        case 8: {
                            GridLayoutTab.this.vSpan.setFocus();
                            continue block12;
                        }
                        case 9: {
                            GridLayoutTab.this.hGrab.setFocus();
                            continue block12;
                        }
                        case 10: {
                            GridLayoutTab.this.vGrab.setFocus();
                            continue block12;
                        }
                        default: {
                            GridLayoutTab.this.resetEditors();
                        }
                    }
                }
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = new TableItem(GridLayoutTab.this.table, 0);
                String[] stringArray = new String[]{String.valueOf(GridLayoutTab.this.table.indexOf(tableItem)), "Button", "-1", "-1", "BEGINNING", "CENTER", "0", "1", "1", "false", "false"};
                tableItem.setText(stringArray);
                GridLayoutTab.this.data.addElement(stringArray);
                GridLayoutTab.this.resetEditors();
            }
        });
    }

    @Override
    void createControlWidgets() {
        this.size.setLayoutData((Object)new GridData());
        String[] stringArray = new String[]{"0", "3", "5", "10"};
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setText(LayoutExample.getResourceString("Margins_Spacing"));
        GridData gridData = new GridData(768);
        gridData.verticalSpan = 2;
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        new Label((Composite)group, 0).setText("marginHeight");
        this.marginHeight = new Combo((Composite)group, 0);
        this.marginHeight.setItems(stringArray);
        this.marginHeight.select(2);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        this.marginHeight.setLayoutData((Object)gridData);
        this.marginHeight.addSelectionListener(this.selectionListener);
        this.marginHeight.addTraverseListener(this.traverseListener);
        new Label((Composite)group, 0).setText("marginWidth");
        this.marginWidth = new Combo((Composite)group, 0);
        this.marginWidth.setItems(stringArray);
        this.marginWidth.select(2);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        this.marginWidth.setLayoutData((Object)gridData);
        this.marginWidth.addSelectionListener(this.selectionListener);
        this.marginWidth.addTraverseListener(this.traverseListener);
        new Label((Composite)group, 0).setText("horizontalSpacing");
        this.horizontalSpacing = new Combo((Composite)group, 0);
        this.horizontalSpacing.setItems(stringArray);
        this.horizontalSpacing.select(2);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        this.horizontalSpacing.setLayoutData((Object)gridData);
        this.horizontalSpacing.addSelectionListener(this.selectionListener);
        this.horizontalSpacing.addTraverseListener(this.traverseListener);
        new Label((Composite)group, 0).setText("verticalSpacing");
        this.verticalSpacing = new Combo((Composite)group, 0);
        this.verticalSpacing.setItems(stringArray);
        this.verticalSpacing.select(2);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        this.verticalSpacing.setLayoutData((Object)gridData);
        this.verticalSpacing.addSelectionListener(this.selectionListener);
        this.verticalSpacing.addTraverseListener(this.traverseListener);
        Group group2 = new Group((Composite)this.controlGroup, 0);
        group2.setText(LayoutExample.getResourceString("Columns"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(16);
        group2.setLayoutData((Object)gridData);
        this.numColumns = new Text((Composite)group2, 2048);
        this.numColumns.setText("1");
        this.numColumns.addSelectionListener(this.selectionListener);
        this.numColumns.addTraverseListener(this.traverseListener);
        gridData = new GridData(768);
        gridData.widthHint = 15;
        this.numColumns.setLayoutData((Object)gridData);
        new Label((Composite)group2, 0).setText("numColumns");
        this.makeColumnsEqualWidth = new Button((Composite)group2, 32);
        this.makeColumnsEqualWidth.setText("makeColumnsEqualWidth");
        this.makeColumnsEqualWidth.addSelectionListener(this.selectionListener);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 14;
        this.makeColumnsEqualWidth.setLayoutData((Object)gridData);
        super.createControlWidgets();
        this.controlGroup.pack();
    }

    @Override
    void createLayout() {
        this.gridLayout = new GridLayout();
        this.layoutComposite.setLayout((Layout)this.gridLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.hAlign.dispose();
        this.vAlign.dispose();
        this.hIndent.dispose();
        this.hSpan.dispose();
        this.vSpan.dispose();
        this.hGrab.dispose();
        this.vGrab.dispose();
    }

    @Override
    StringBuffer generateLayoutCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tGridLayout gridLayout = new GridLayout ();\n");
        if (this.gridLayout.numColumns != 1) {
            stringBuffer.append("\t\tgridLayout.numColumns = " + this.gridLayout.numColumns + ";\n");
        }
        if (this.gridLayout.makeColumnsEqualWidth) {
            stringBuffer.append("\t\tgridLayout.makeColumnsEqualWidth = true;\n");
        }
        if (this.gridLayout.marginHeight != 5) {
            stringBuffer.append("\t\tgridLayout.marginHeight = " + this.gridLayout.marginHeight + ";\n");
        }
        if (this.gridLayout.marginWidth != 5) {
            stringBuffer.append("\t\tgridLayout.marginWidth = " + this.gridLayout.marginWidth + ";\n");
        }
        if (this.gridLayout.horizontalSpacing != 5) {
            stringBuffer.append("\t\tgridLayout.horizontalSpacing = " + this.gridLayout.horizontalSpacing + ";\n");
        }
        if (this.gridLayout.verticalSpacing != 5) {
            stringBuffer.append("\t\tgridLayout.verticalSpacing = " + this.gridLayout.verticalSpacing + ";\n");
        }
        stringBuffer.append("\t\tshell.setLayout (gridLayout);\n");
        boolean bl = true;
        for (int i = 0; i < this.children.length; ++i) {
            String string;
            int n;
            Control control = this.children[i];
            stringBuffer.append(this.getChildCode(control, i));
            GridData gridData = (GridData)control.getLayoutData();
            if (gridData == null) continue;
            stringBuffer.append("\t\t");
            if (bl) {
                stringBuffer.append("GridData ");
                bl = false;
            }
            stringBuffer.append("data = new GridData ();\n");
            if (gridData.widthHint != -1) {
                stringBuffer.append("\t\tdata.widthHint = " + gridData.widthHint + ";\n");
            }
            if (gridData.heightHint != -1) {
                stringBuffer.append("\t\tdata.heightHint = " + gridData.heightHint + ";\n");
            }
            if (gridData.horizontalAlignment != 1) {
                n = gridData.horizontalAlignment;
                string = n == 2 ? "GridData.CENTER" : (n == 3 ? "GridData.END" : "GridData.FILL");
                stringBuffer.append("\t\tdata.horizontalAlignment = " + string + ";\n");
            }
            if (gridData.verticalAlignment != 2) {
                n = gridData.verticalAlignment;
                string = n == 1 ? "GridData.BEGINNING" : (n == 3 ? "GridData.END" : "GridData.FILL");
                stringBuffer.append("\t\tdata.verticalAlignment = " + string + ";\n");
            }
            if (gridData.horizontalIndent != 0) {
                stringBuffer.append("\t\tdata.horizontalIndent = " + gridData.horizontalIndent + ";\n");
            }
            if (gridData.horizontalSpan != 1) {
                stringBuffer.append("\t\tdata.horizontalSpan = " + gridData.horizontalSpan + ";\n");
            }
            if (gridData.verticalSpan != 1) {
                stringBuffer.append("\t\tdata.verticalSpan = " + gridData.verticalSpan + ";\n");
            }
            if (gridData.grabExcessHorizontalSpace) {
                stringBuffer.append("\t\tdata.grabExcessHorizontalSpace = true;\n");
            }
            if (gridData.grabExcessVerticalSpace) {
                stringBuffer.append("\t\tdata.grabExcessVerticalSpace = true;\n");
            }
            if (stringBuffer.substring(stringBuffer.length() - 33).equals("GridData data = new GridData ();\n")) {
                stringBuffer.delete(stringBuffer.length() - 33, stringBuffer.length());
                bl = true;
                continue;
            }
            if (stringBuffer.substring(stringBuffer.length() - 24).equals("data = new GridData ();\n")) {
                stringBuffer.delete(stringBuffer.length() - 24, stringBuffer.length());
                continue;
            }
            stringBuffer.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
        }
        return stringBuffer;
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control", "width", "height", "horizontalAlignment", "verticalAlignment", "horizontalIndent", "horizontalSpan", "verticalSpan", "grabExcessHorizontalSpace", "grabExcessVerticalSpace"};
    }

    @Override
    String getTabText() {
        return "GridLayout";
    }

    @Override
    void resetEditors() {
        this.resetEditors(false);
    }

    @Override
    void resetEditors(boolean bl) {
        TableItem tableItem = this.comboEditor.getItem();
        if (tableItem != null) {
            int n = this.table.indexOf(tableItem);
            try {
                Integer.valueOf(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(tableItem.getText(2));
            }
            try {
                Integer.valueOf(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(tableItem.getText(3));
            }
            try {
                Integer.valueOf(this.hIndent.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.hIndent.setText(tableItem.getText(6));
            }
            try {
                Integer.valueOf(this.hSpan.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.hSpan.setText(tableItem.getText(7));
            }
            try {
                Integer.valueOf(this.vSpan.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.vSpan.setText(tableItem.getText(8));
            }
            String[] stringArray = new String[]{String.valueOf(n), this.combo.getText(), this.widthText.getText(), this.heightText.getText(), this.hAlign.getText(), this.vAlign.getText(), this.hIndent.getText(), this.hSpan.getText(), this.vSpan.getText(), this.hGrab.getText(), this.vGrab.getText()};
            this.data.setElementAt(stringArray, n);
            for (int i = 0; i < 11; ++i) {
                tableItem.setText(i, ((String[])this.data.elementAt(n))[i]);
            }
            if (!bl) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    @Override
    void setLayoutData() {
        Control[] controlArray = this.layoutComposite.getChildren();
        TableItem[] tableItemArray = this.table.getItems();
        for (int i = 0; i < controlArray.length; ++i) {
            int n;
            int n2;
            int n3;
            GridData gridData = new GridData();
            gridData.widthHint = Integer.valueOf(tableItemArray[i].getText(2));
            gridData.heightHint = Integer.valueOf(tableItemArray[i].getText(3));
            String string = tableItemArray[i].getText(4);
            gridData.horizontalAlignment = string.equals("CENTER") ? 2 : (string.equals("END") ? 3 : (string.equals("FILL") ? 4 : 1));
            String string2 = tableItemArray[i].getText(5);
            gridData.verticalAlignment = string2.equals("BEGINNING") ? 1 : (string2.equals("END") ? 3 : (string2.equals("FILL") ? 4 : 2));
            gridData.horizontalIndent = n3 = Integer.valueOf(tableItemArray[i].getText(6)).intValue();
            gridData.horizontalSpan = n2 = Integer.valueOf(tableItemArray[i].getText(7)).intValue();
            gridData.verticalSpan = n = Integer.valueOf(tableItemArray[i].getText(8)).intValue();
            String string3 = tableItemArray[i].getText(9);
            gridData.grabExcessHorizontalSpace = string3.equals("true");
            String string4 = tableItemArray[i].getText(10);
            gridData.grabExcessVerticalSpace = string4.equals("true");
            controlArray[i].setLayoutData((Object)gridData);
        }
    }

    @Override
    void setLayoutState() {
        try {
            this.gridLayout.numColumns = Integer.valueOf(this.numColumns.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.numColumns = 1;
        }
        this.gridLayout.makeColumnsEqualWidth = this.makeColumnsEqualWidth.getSelection();
        try {
            this.gridLayout.marginHeight = Integer.valueOf(this.marginHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.marginHeight = 5;
            this.marginHeight.select(2);
        }
        try {
            this.gridLayout.marginWidth = Integer.valueOf(this.marginWidth.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.marginWidth = 5;
            this.marginWidth.select(2);
        }
        try {
            this.gridLayout.horizontalSpacing = Integer.valueOf(this.horizontalSpacing.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.horizontalSpacing = 5;
            this.horizontalSpacing.select(2);
        }
        try {
            this.gridLayout.verticalSpacing = Integer.valueOf(this.verticalSpacing.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.gridLayout.verticalSpacing = 5;
            this.verticalSpacing.select(2);
        }
    }
}

