/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.layoutexample.FillLayoutTab;
import org.eclipse.swt.examples.layoutexample.FormLayoutTab;
import org.eclipse.swt.examples.layoutexample.GridLayoutTab;
import org.eclipse.swt.examples.layoutexample.RowLayoutTab;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class LayoutExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_layout");
    private TabFolder tabFolder;

    public LayoutExample(Composite composite) {
        this.tabFolder = new TabFolder(composite, 0);
        Tab[] tabArray = new Tab[]{new FillLayoutTab(this), new RowLayoutTab(this), new GridLayoutTab(this), new FormLayoutTab(this)};
        for (int i = 0; i < tabArray.length; ++i) {
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            tabItem.setText(tabArray[i].getTabText());
            tabItem.setControl((Control)tabArray[i].createTabFolderPage(this.tabFolder));
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void dispose() {
        this.tabFolder = null;
    }

    public static void main(String[] stringArray) {
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        new LayoutExample((Composite)shell);
        shell.setText(LayoutExample.getResourceString("window.title"));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                Shell[] shellArray = display.getShells();
                for (int i = 0; i < shellArray.length; ++i) {
                    if (shellArray[i] == shell) continue;
                    shellArray[i].close();
                }
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    static String getResourceString(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(LayoutExample.getResourceString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }
}

