/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Region;

public class ContainerFigure
extends Figure {
    private static final int INITIAL_ARRAY_SIZE = 16;
    Figure[] objectStack = null;
    int nextIndex = 0;

    public void add(Figure figure) {
        if (this.objectStack == null) {
            this.objectStack = new Figure[16];
        } else if (this.objectStack.length <= this.nextIndex) {
            Figure[] figureArray = new Figure[this.objectStack.length * 2];
            System.arraycopy(this.objectStack, 0, figureArray, 0, this.objectStack.length);
            this.objectStack = figureArray;
        }
        this.objectStack[this.nextIndex] = figure;
        ++this.nextIndex;
    }

    public boolean isEmpty() {
        return this.nextIndex == 0;
    }

    public void clear() {
        while (--this.nextIndex > 0) {
            this.objectStack[this.nextIndex] = null;
        }
        this.nextIndex = 0;
    }

    @Override
    public void draw(FigureDrawContext figureDrawContext) {
        for (int i = 0; i < this.nextIndex; ++i) {
            this.objectStack[i].draw(figureDrawContext);
        }
    }

    @Override
    public void addDamagedRegion(FigureDrawContext figureDrawContext, Region region) {
        for (int i = 0; i < this.nextIndex; ++i) {
            this.objectStack[i].addDamagedRegion(figureDrawContext, region);
        }
    }
}

