/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.graphics.Point;

public abstract class DragPaintSession
extends BasicPaintSession {
    private boolean dragInProgress = false;
    private Point anchorPosition = new Point(-1, -1);
    private Point tempPosition = new Point(-1, -1);

    protected DragPaintSession(PaintSurface paintSurface) {
        super(paintSurface);
    }

    @Override
    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.DragInteractivePaint.message"));
        this.anchorPosition.x = -1;
        this.dragInProgress = false;
    }

    @Override
    public void endSession() {
    }

    @Override
    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
        this.anchorPosition.x = -1;
        this.dragInProgress = false;
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        if (this.dragInProgress) {
            return;
        }
        this.dragInProgress = true;
        this.anchorPosition.x = mouseEvent.x;
        this.anchorPosition.y = mouseEvent.y;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            this.resetSession();
            return;
        }
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        if (this.anchorPosition.x == -1) {
            return;
        }
        this.getPaintSurface().commitRubberbandSelection();
    }

    public void mouseMove(MouseEvent mouseEvent) {
        PaintSurface paintSurface = this.getPaintSurface();
        if (!this.dragInProgress) {
            paintSurface.setStatusCoord(paintSurface.getCurrentPosition());
            return;
        }
        paintSurface.setStatusCoordRange(this.anchorPosition, paintSurface.getCurrentPosition());
        paintSurface.clearRubberbandSelection();
        this.tempPosition.x = mouseEvent.x;
        this.tempPosition.y = mouseEvent.y;
        paintSurface.addRubberbandSelection(this.createFigure(this.anchorPosition, this.tempPosition));
    }

    protected abstract Figure createFigure(Point var1, Point var2);
}

