/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.DragPaintSession;
import org.eclipse.swt.examples.paint.EllipseFigure;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.SolidEllipseFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class EllipseTool
extends DragPaintSession
implements PaintTool {
    private ToolSettings settings;

    public EllipseTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    @Override
    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    @Override
    public String getDisplayName() {
        return PaintExample.getResourceString("tool.Ellipse.label");
    }

    @Override
    protected Figure createFigure(Point point, Point point2) {
        ContainerFigure containerFigure = new ContainerFigure();
        if (this.settings.commonFillType != 0) {
            containerFigure.add(new SolidEllipseFigure(this.settings.commonBackgroundColor, point.x, point.y, point2.x, point2.y));
        }
        if (this.settings.commonFillType != 2) {
            containerFigure.add(new EllipseFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, point.x, point.y, point2.x, point2.y));
        }
        return containerFigure;
    }
}

