/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSession;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PaintSurface {
    private Point currentPosition = new Point(0, 0);
    private Canvas paintCanvas;
    private PaintSession paintSession;
    private Image image;
    private Image paintImage;
    private int imageWidth;
    private int imageHeight;
    private int visibleWidth;
    private int visibleHeight;
    private FigureDrawContext displayFDC = new FigureDrawContext();
    private FigureDrawContext imageFDC = new FigureDrawContext();
    private FigureDrawContext paintFDC = new FigureDrawContext();
    private ContainerFigure rubberband = new ContainerFigure();
    private int rubberbandHiddenNestingCount = 0;
    private Text statusText;
    private String statusActionInfo;
    private String statusMessageInfo;
    private String statusCoordInfo;

    public PaintSurface(Canvas canvas, Text text, Color color) {
        this.paintCanvas = canvas;
        this.statusText = text;
        this.clearStatus();
        Rectangle rectangle = canvas.getDisplay().getClientArea();
        this.imageWidth = rectangle.width;
        this.imageHeight = rectangle.height;
        this.image = new Image((Device)canvas.getDisplay(), this.imageWidth, this.imageHeight);
        this.imageFDC.gc = new GC((Drawable)this.image);
        this.imageFDC.gc.setBackground(color);
        this.imageFDC.gc.fillRectangle(0, 0, this.imageWidth, this.imageHeight);
        this.displayFDC.gc = new GC((Drawable)canvas);
        this.setPaintSession(null);
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ((PaintSurface)PaintSurface.this).displayFDC.gc.dispose();
            }
        });
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                PaintSurface.this.processMouseEventCoordinates(mouseEvent);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseDown(mouseEvent);
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                PaintSurface.this.processMouseEventCoordinates(mouseEvent);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseUp(mouseEvent);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                PaintSurface.this.processMouseEventCoordinates(mouseEvent);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseDoubleClick(mouseEvent);
                }
            }
        });
        canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                PaintSurface.this.processMouseEventCoordinates(mouseEvent);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseMove(mouseEvent);
                }
            }
        });
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (PaintSurface.this.rubberband.isEmpty()) {
                    paintEvent.gc.drawImage(PaintSurface.this.image, ((PaintSurface)PaintSurface.this).displayFDC.xOffset + paintEvent.x, ((PaintSurface)PaintSurface.this).displayFDC.yOffset + paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                } else {
                    Rectangle rectangle;
                    if (PaintSurface.this.paintImage != null) {
                        rectangle = PaintSurface.this.paintImage.getBounds();
                        if (paintEvent.width + paintEvent.x > rectangle.width || paintEvent.height + paintEvent.y > rectangle.height) {
                            ((PaintSurface)PaintSurface.this).paintFDC.gc.dispose();
                            PaintSurface.this.paintImage.dispose();
                            PaintSurface.this.paintImage = null;
                        }
                    }
                    if (PaintSurface.this.paintImage == null) {
                        rectangle = PaintSurface.this.getDisplay();
                        Rectangle rectangle2 = rectangle.getClientArea();
                        PaintSurface.this.paintImage = new Image((Device)rectangle, Math.max(rectangle2.width, paintEvent.width + paintEvent.x), Math.max(rectangle2.height, paintEvent.height + paintEvent.y));
                        ((PaintSurface)PaintSurface.this).paintFDC.gc = new GC((Drawable)PaintSurface.this.paintImage);
                    }
                    rectangle = new Region();
                    paintEvent.gc.getClipping((Region)rectangle);
                    ((PaintSurface)PaintSurface.this).paintFDC.gc.setClipping((Region)rectangle);
                    rectangle.dispose();
                    ((PaintSurface)PaintSurface.this).paintFDC.xOffset = ((PaintSurface)PaintSurface.this).displayFDC.xOffset;
                    ((PaintSurface)PaintSurface.this).paintFDC.yOffset = ((PaintSurface)PaintSurface.this).displayFDC.yOffset;
                    ((PaintSurface)PaintSurface.this).paintFDC.xScale = ((PaintSurface)PaintSurface.this).displayFDC.xScale;
                    ((PaintSurface)PaintSurface.this).paintFDC.yScale = ((PaintSurface)PaintSurface.this).displayFDC.yScale;
                    ((PaintSurface)PaintSurface.this).paintFDC.gc.drawImage(PaintSurface.this.image, ((PaintSurface)PaintSurface.this).displayFDC.xOffset + paintEvent.x, ((PaintSurface)PaintSurface.this).displayFDC.yOffset + paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                    PaintSurface.this.rubberband.draw(PaintSurface.this.paintFDC);
                    paintEvent.gc.drawImage(PaintSurface.this.paintImage, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                }
            }
        });
        canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                PaintSurface.this.handleResize();
            }
        });
        ScrollBar scrollBar = canvas.getHorizontalBar();
        scrollBar.setVisible(true);
        scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PaintSurface.this.scrollHorizontally((ScrollBar)selectionEvent.widget);
            }
        });
        ScrollBar scrollBar2 = canvas.getVerticalBar();
        scrollBar2.setVisible(true);
        scrollBar2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PaintSurface.this.scrollVertically((ScrollBar)selectionEvent.widget);
            }
        });
        this.handleResize();
    }

    public void dispose() {
        this.imageFDC.gc.dispose();
        this.image.dispose();
        if (this.paintImage != null) {
            this.paintImage.dispose();
            this.paintFDC.gc.dispose();
        }
        this.currentPosition = null;
        this.paintCanvas = null;
        this.paintSession = null;
        this.image = null;
        this.paintImage = null;
        this.displayFDC = null;
        this.imageFDC = null;
        this.paintFDC = null;
        this.rubberband = null;
        this.statusText = null;
        this.statusActionInfo = null;
        this.statusMessageInfo = null;
        this.statusCoordInfo = null;
    }

    public void setFocus() {
        this.paintCanvas.setFocus();
    }

    public Display getDisplay() {
        return this.paintCanvas.getDisplay();
    }

    public Shell getShell() {
        return this.paintCanvas.getShell();
    }

    public void setPaintSession(PaintSession paintSession) {
        if (this.paintSession != null) {
            if (this.paintSession == paintSession) {
                return;
            }
            this.paintSession.endSession();
        }
        this.paintSession = paintSession;
        this.clearStatus();
        if (paintSession != null) {
            this.setStatusAction(paintSession.getDisplayName());
            paintSession.beginSession();
        } else {
            this.setStatusAction(PaintExample.getResourceString("tool.Null.label"));
            this.setStatusMessage(PaintExample.getResourceString("session.Null.message"));
        }
    }

    public PaintSession getPaintSession() {
        return this.paintSession;
    }

    public PaintTool getPaintTool() {
        return this.paintSession != null && this.paintSession instanceof PaintTool ? (PaintTool)this.paintSession : null;
    }

    public Point getCurrentPosition() {
        return this.currentPosition;
    }

    public void drawFigure(Figure figure) {
        figure.draw(this.imageFDC);
        figure.draw(this.displayFDC);
    }

    public void addRubberbandSelection(Figure figure) {
        this.rubberband.add(figure);
        if (!this.isRubberbandHidden()) {
            figure.draw(this.displayFDC);
        }
    }

    public void clearRubberbandSelection() {
        if (!this.isRubberbandHidden()) {
            Region region = new Region();
            this.rubberband.addDamagedRegion(this.displayFDC, region);
            Rectangle rectangle = region.getBounds();
            this.paintCanvas.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            region.dispose();
        }
        this.rubberband.clear();
    }

    public void commitRubberbandSelection() {
        this.rubberband.draw(this.imageFDC);
        if (this.isRubberbandHidden()) {
            this.rubberband.draw(this.displayFDC);
        }
        this.rubberband.clear();
    }

    public void hideRubberband() {
        if (this.rubberbandHiddenNestingCount++ <= 0) {
            Region region = new Region();
            this.rubberband.addDamagedRegion(this.displayFDC, region);
            Rectangle rectangle = region.getBounds();
            this.paintCanvas.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            region.dispose();
        }
    }

    public void showRubberband() {
        if (this.rubberbandHiddenNestingCount <= 0) {
            throw new IllegalStateException("rubberbandHiddenNestingCount > 0");
        }
        if (--this.rubberbandHiddenNestingCount == 0) {
            this.rubberband.draw(this.displayFDC);
        }
    }

    public boolean isRubberbandHidden() {
        return this.rubberbandHiddenNestingCount > 0;
    }

    public void scrollHorizontally(ScrollBar scrollBar) {
        int n;
        int n2;
        if (this.image == null) {
            return;
        }
        if (this.imageWidth > this.visibleWidth && (n2 = this.displayFDC.xOffset) != (n = Math.min(scrollBar.getSelection(), this.imageWidth - this.visibleWidth))) {
            this.paintCanvas.update();
            this.displayFDC.xOffset = n;
            this.paintCanvas.scroll(Math.max(n2 - n, 0), 0, Math.max(n - n2, 0), 0, this.visibleWidth, this.visibleHeight, false);
        }
    }

    public void scrollVertically(ScrollBar scrollBar) {
        int n;
        int n2;
        if (this.image == null) {
            return;
        }
        if (this.imageHeight > this.visibleHeight && (n2 = this.displayFDC.yOffset) != (n = Math.min(scrollBar.getSelection(), this.imageHeight - this.visibleHeight))) {
            this.paintCanvas.update();
            this.displayFDC.yOffset = n;
            this.paintCanvas.scroll(0, Math.max(n2 - n, 0), 0, Math.max(n - n2, 0), this.visibleWidth, this.visibleHeight, false);
        }
    }

    private void handleResize() {
        ScrollBar scrollBar;
        this.paintCanvas.update();
        Rectangle rectangle = this.paintCanvas.getClientArea();
        this.visibleWidth = rectangle.width;
        this.visibleHeight = rectangle.height;
        ScrollBar scrollBar2 = this.paintCanvas.getHorizontalBar();
        if (scrollBar2 != null) {
            this.displayFDC.xOffset = Math.min(scrollBar2.getSelection(), this.imageWidth - this.visibleWidth);
            if (this.imageWidth <= this.visibleWidth) {
                scrollBar2.setEnabled(false);
                scrollBar2.setSelection(0);
            } else {
                scrollBar2.setEnabled(true);
                scrollBar2.setValues(this.displayFDC.xOffset, 0, this.imageWidth, this.visibleWidth, 8, this.visibleWidth);
            }
        }
        if ((scrollBar = this.paintCanvas.getVerticalBar()) != null) {
            this.displayFDC.yOffset = Math.min(scrollBar.getSelection(), this.imageHeight - this.visibleHeight);
            if (this.imageHeight <= this.visibleHeight) {
                scrollBar.setEnabled(false);
                scrollBar.setSelection(0);
            } else {
                scrollBar.setEnabled(true);
                scrollBar.setValues(this.displayFDC.yOffset, 0, this.imageHeight, this.visibleHeight, 8, this.visibleHeight);
            }
        }
    }

    private void processMouseEventCoordinates(MouseEvent mouseEvent) {
        this.currentPosition.x = mouseEvent.x = Math.min(Math.max(mouseEvent.x, 0), this.visibleWidth - 1) + this.displayFDC.xOffset;
        this.currentPosition.y = mouseEvent.y = Math.min(Math.max(mouseEvent.y, 0), this.visibleHeight - 1) + this.displayFDC.yOffset;
    }

    public void clearStatus() {
        this.statusActionInfo = "";
        this.statusMessageInfo = "";
        this.statusCoordInfo = "";
        this.updateStatus();
    }

    public void setStatusAction(String string) {
        this.statusActionInfo = string != null ? string : "";
        this.updateStatus();
    }

    public void setStatusMessage(String string) {
        this.statusMessageInfo = string != null ? string : "";
        this.updateStatus();
    }

    public void setStatusCoord(Point point) {
        this.statusCoordInfo = point != null ? PaintExample.getResourceString("status.Coord.format", new Object[]{point.x, point.y}) : "";
        this.updateStatus();
    }

    public void setStatusCoordRange(Point point, Point point2) {
        this.statusCoordInfo = PaintExample.getResourceString("status.CoordRange.format", new Object[]{point.x, point.y, point2.x, point2.y});
        this.updateStatus();
    }

    private void updateStatus() {
        this.statusText.setText(PaintExample.getResourceString("status.Bar.format", new Object[]{this.statusActionInfo, this.statusMessageInfo, this.statusCoordInfo}));
    }
}

