/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.DragPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.RectangleFigure;
import org.eclipse.swt.examples.paint.SolidRectangleFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class RectangleTool
extends DragPaintSession
implements PaintTool {
    private ToolSettings settings;

    public RectangleTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    @Override
    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    @Override
    public String getDisplayName() {
        return PaintExample.getResourceString("tool.Rectangle.label");
    }

    @Override
    protected Figure createFigure(Point point, Point point2) {
        switch (this.settings.commonFillType) {
            default: {
                return new RectangleFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, point.x, point.y, point2.x, point2.y);
            }
            case 2: {
                return new SolidRectangleFigure(this.settings.commonBackgroundColor, point.x, point.y, point2.x, point2.y);
            }
            case 1: 
        }
        ContainerFigure containerFigure = new ContainerFigure();
        containerFigure.add(new SolidRectangleFigure(this.settings.commonBackgroundColor, point.x, point.y, point2.x, point2.y));
        containerFigure.add(new RectangleFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, point.x, point.y, point2.x, point2.y));
        return containerFigure;
    }
}

