/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;

public class SolidPolygonFigure
extends Figure {
    private Color color;
    private int[] points;

    public SolidPolygonFigure(Color color, Point[] pointArray, int n) {
        this.color = color;
        this.points = new int[n * 2];
        for (int i = 0; i < n; ++i) {
            this.points[i * 2] = pointArray[i].x;
            this.points[i * 2 + 1] = pointArray[i].y;
        }
    }

    @Override
    public void draw(FigureDrawContext figureDrawContext) {
        int[] nArray = new int[this.points.length];
        for (int i = 0; i < this.points.length; i += 2) {
            nArray[i] = this.points[i] * figureDrawContext.xScale - figureDrawContext.xOffset;
            nArray[i + 1] = this.points[i + 1] * figureDrawContext.yScale - figureDrawContext.yOffset;
        }
        figureDrawContext.gc.setBackground(this.color);
        figureDrawContext.gc.fillPolygon(nArray);
    }

    @Override
    public void addDamagedRegion(FigureDrawContext figureDrawContext, Region region) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.points.length; i += 2) {
            if (this.points[i] < n) {
                n = this.points[i];
            }
            if (this.points[i] > n3) {
                n3 = this.points[i];
            }
            if (this.points[i + 1] < n2) {
                n2 = this.points[i + 1];
            }
            if (this.points[i + 1] <= n4) continue;
            n4 = this.points[i + 1];
        }
        region.add(figureDrawContext.toClientRectangle(n, n2, n3, n4));
    }
}

