/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;

public class TextFigure
extends Figure {
    private Color color;
    private Font font;
    private String text;
    private int x;
    private int y;

    public TextFigure(Color color, Font font, String string, int n, int n2) {
        this.color = color;
        this.font = font;
        this.text = string;
        this.x = n;
        this.y = n2;
    }

    @Override
    public void draw(FigureDrawContext figureDrawContext) {
        Point point = figureDrawContext.toClientPoint(this.x, this.y);
        figureDrawContext.gc.setFont(this.font);
        figureDrawContext.gc.setForeground(this.color);
        figureDrawContext.gc.drawText(this.text, point.x, point.y, true);
    }

    @Override
    public void addDamagedRegion(FigureDrawContext figureDrawContext, Region region) {
        Font font = figureDrawContext.gc.getFont();
        figureDrawContext.gc.setFont(this.font);
        Point point = figureDrawContext.gc.textExtent(this.text);
        figureDrawContext.gc.setFont(font);
        region.add(figureDrawContext.toClientRectangle(this.x, this.y, this.x + point.x, this.y + point.y));
    }
}

