/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.texteditor;

import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.texteditor.Images;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TextEditor {
    Shell shell;
    ToolBar toolBar;
    StyledText text;
    Images images = new Images();
    Vector cachedStyles = new Vector();
    Color RED = null;
    Color BLUE = null;
    Color GREEN = null;
    Font font = null;
    ToolItem boldButton;
    ToolItem italicButton;
    ToolItem underlineButton;
    ToolItem strikeoutButton;
    static ResourceBundle resources = ResourceBundle.getBundle("examples_texteditor");

    Menu createEditMenu() {
        Menu menu = this.shell.getMenuBar();
        Menu menu2 = new Menu(menu);
        MenuItem menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resources.getString("Cut_menuitem"));
        menuItem.setAccelerator(SWT.MOD1 + 88);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.handleCutCopy();
                TextEditor.this.text.cut();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resources.getString("Copy_menuitem"));
        menuItem.setAccelerator(SWT.MOD1 + 67);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.handleCutCopy();
                TextEditor.this.text.copy();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resources.getString("Paste_menuitem"));
        menuItem.setAccelerator(SWT.MOD1 + 86);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.text.paste();
            }
        });
        new MenuItem(menu2, 2);
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resources.getString("Font_menuitem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.setFont();
            }
        });
        return menu2;
    }

    Menu createFileMenu() {
        Menu menu = this.shell.getMenuBar();
        Menu menu2 = new Menu(menu);
        MenuItem menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resources.getString("Exit_menuitem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.shell.close();
            }
        });
        return menu2;
    }

    void setStyle(Widget widget) {
        Point point = this.text.getSelectionRange();
        if (point == null || point.y == 0) {
            return;
        }
        for (int i = point.x; i < point.x + point.y; ++i) {
            StyleRange styleRange;
            StyleRange styleRange2 = this.text.getStyleRangeAtOffset(i);
            if (styleRange2 != null) {
                styleRange = (StyleRange)styleRange2.clone();
                styleRange.start = i;
                styleRange.length = 1;
            } else {
                styleRange = new StyleRange(i, 1, null, null, 0);
            }
            if (widget == this.boldButton) {
                styleRange.fontStyle ^= 1;
            } else if (widget == this.italicButton) {
                styleRange.fontStyle ^= 2;
            } else if (widget == this.underlineButton) {
                styleRange.underline = !styleRange.underline;
            } else if (widget == this.strikeoutButton) {
                styleRange.strikeout = !styleRange.strikeout;
            }
            this.text.setStyleRange(styleRange);
        }
        this.text.setSelectionRange(point.x + point.y, 0);
    }

    void clear() {
        Point point = this.text.getSelectionRange();
        if (point != null && point.y != 0) {
            StyleRange styleRange = new StyleRange(point.x, point.y, null, null, 0);
            this.text.setStyleRange(styleRange);
        }
        this.text.setSelectionRange(point.x + point.y, 0);
    }

    void fgColor(Color color) {
        Point point = this.text.getSelectionRange();
        if (point == null || point.y == 0) {
            return;
        }
        for (int i = point.x; i < point.x + point.y; ++i) {
            StyleRange styleRange;
            StyleRange styleRange2 = this.text.getStyleRangeAtOffset(i);
            if (styleRange2 != null) {
                styleRange = (StyleRange)styleRange2.clone();
                styleRange.start = i;
                styleRange.length = 1;
                styleRange.foreground = color;
            } else {
                styleRange = new StyleRange(i, 1, color, null, 0);
            }
            this.text.setStyleRange(styleRange);
        }
        this.text.setSelectionRange(point.x + point.y, 0);
    }

    void createMenuBar() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(resources.getString("File_menuitem"));
        menuItem.setMenu(this.createFileMenu());
        MenuItem menuItem2 = new MenuItem(menu, 64);
        menuItem2.setText(resources.getString("Edit_menuitem"));
        menuItem2.setMenu(this.createEditMenu());
    }

    void createShell(Display display) {
        this.shell = new Shell(display);
        this.shell.setText(resources.getString("Window_title"));
        this.images.loadAll(display);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TextEditor.this.font != null) {
                    TextEditor.this.font.dispose();
                }
                TextEditor.this.images.freeAll();
                TextEditor.this.RED.dispose();
                TextEditor.this.GREEN.dispose();
                TextEditor.this.BLUE.dispose();
            }
        });
    }

    void createStyledText() {
        this.initializeColors();
        this.text = new StyledText((Composite)this.shell, 2818);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)gridData);
        this.text.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
                TextEditor.this.handleExtendedModify(extendedModifyEvent);
            }
        });
    }

    void createToolBar() {
        this.toolBar = new ToolBar((Composite)this.shell, 0);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.setStyle(selectionEvent.widget);
            }
        };
        this.boldButton = new ToolItem(this.toolBar, 32);
        this.boldButton.setImage(this.images.Bold);
        this.boldButton.setToolTipText(resources.getString("Bold"));
        this.boldButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.italicButton = new ToolItem(this.toolBar, 32);
        this.italicButton.setImage(this.images.Italic);
        this.italicButton.setToolTipText(resources.getString("Italic"));
        this.italicButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.underlineButton = new ToolItem(this.toolBar, 32);
        this.underlineButton.setImage(this.images.Underline);
        this.underlineButton.setToolTipText(resources.getString("Underline"));
        this.underlineButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.strikeoutButton = new ToolItem(this.toolBar, 32);
        this.strikeoutButton.setImage(this.images.Strikeout);
        this.strikeoutButton.setToolTipText(resources.getString("Strikeout"));
        this.strikeoutButton.addSelectionListener((SelectionListener)selectionAdapter);
        ToolItem toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.images.Red);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.fgColor(TextEditor.this.RED);
            }
        });
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.images.Green);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.fgColor(TextEditor.this.GREEN);
            }
        });
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.images.Blue);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.fgColor(TextEditor.this.BLUE);
            }
        });
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.images.Erase);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditor.this.clear();
            }
        });
    }

    void handleCutCopy() {
        this.cachedStyles = new Vector();
        Point point = this.text.getSelectionRange();
        int n = point.x;
        for (int i = point.x; i <= point.x + point.y - 1; ++i) {
            StyleRange styleRange = this.text.getStyleRangeAtOffset(i);
            if (styleRange == null) continue;
            styleRange.start -= n;
            if (!this.cachedStyles.isEmpty()) {
                StyleRange styleRange2 = (StyleRange)this.cachedStyles.lastElement();
                if (styleRange2.similarTo(styleRange) && styleRange2.start + styleRange2.length == styleRange.start) {
                    ++styleRange2.length;
                    continue;
                }
                this.cachedStyles.addElement(styleRange);
                continue;
            }
            this.cachedStyles.addElement(styleRange);
        }
    }

    void handleExtendedModify(ExtendedModifyEvent extendedModifyEvent) {
        if (extendedModifyEvent.length == 0) {
            return;
        }
        if (extendedModifyEvent.length == 1 || this.text.getTextRange(extendedModifyEvent.start, extendedModifyEvent.length).equals(this.text.getLineDelimiter())) {
            int n = this.text.getCaretOffset();
            StyleRange styleRange = null;
            if (n < this.text.getCharCount()) {
                styleRange = this.text.getStyleRangeAtOffset(n);
            }
            if (styleRange != null) {
                styleRange = (StyleRange)styleRange.clone();
                styleRange.start = extendedModifyEvent.start;
                styleRange.length = extendedModifyEvent.length;
            } else {
                styleRange = new StyleRange(extendedModifyEvent.start, extendedModifyEvent.length, null, null, 0);
            }
            if (this.boldButton.getSelection()) {
                styleRange.fontStyle |= 1;
            }
            if (this.italicButton.getSelection()) {
                styleRange.fontStyle |= 2;
            }
            styleRange.underline = this.underlineButton.getSelection();
            styleRange.strikeout = this.strikeoutButton.getSelection();
            if (!styleRange.isUnstyled()) {
                this.text.setStyleRange(styleRange);
            }
        } else {
            for (int i = 0; i < this.cachedStyles.size(); ++i) {
                StyleRange styleRange = (StyleRange)this.cachedStyles.elementAt(i);
                StyleRange styleRange2 = (StyleRange)styleRange.clone();
                styleRange2.start = styleRange.start + extendedModifyEvent.start;
                this.text.setStyleRange(styleRange2);
            }
        }
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        TextEditor textEditor = new TextEditor();
        Shell shell = textEditor.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        this.createShell(display);
        this.createMenuBar();
        this.createToolBar();
        this.createStyledText();
        this.shell.setSize(500, 300);
        this.shell.open();
        return this.shell;
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.shell);
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.shell.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    void initializeColors() {
        Display display = Display.getDefault();
        this.RED = new Color((Device)display, new RGB(255, 0, 0));
        this.BLUE = new Color((Device)display, new RGB(0, 0, 255));
        this.GREEN = new Color((Device)display, new RGB(0, 255, 0));
    }
}

