/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import common.Assert;
import jxl.HeaderFooter;
import jxl.Range;
import jxl.Sheet;
import jxl.biff.SheetRangeImpl;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;

public final class SheetSettings {
    private PageOrientation orientation;
    private PaperSize paperSize;
    private boolean sheetProtected;
    private boolean hidden;
    private boolean selected;
    private HeaderFooter header;
    private double headerMargin;
    private HeaderFooter footer;
    private double footerMargin;
    private int scaleFactor;
    private int zoomFactor;
    private int pageStart;
    private int fitWidth;
    private int fitHeight;
    private int horizontalPrintResolution;
    private int verticalPrintResolution;
    private double leftMargin;
    private double rightMargin;
    private double topMargin;
    private double bottomMargin;
    private boolean fitToPages;
    private boolean showGridLines;
    private boolean printGridLines;
    private boolean printHeaders;
    private boolean pageBreakPreviewMode;
    private boolean displayZeroValues;
    private String password;
    private int passwordHash;
    private int defaultColumnWidth;
    private int defaultRowHeight;
    private int horizontalFreeze;
    private int verticalFreeze;
    private boolean verticalCentre;
    private boolean horizontalCentre;
    private int copies;
    private boolean automaticFormulaCalculation;
    private boolean recalculateFormulasBeforeSave;
    private int pageBreakPreviewMagnification;
    private int normalMagnification;
    private Range printArea;
    private Sheet sheet;
    private static final PageOrientation DEFAULT_ORIENTATION = PageOrientation.PORTRAIT;
    private static final PaperSize DEFAULT_PAPER_SIZE = PaperSize.A4;
    private static final double DEFAULT_HEADER_MARGIN = 0.5;
    private static final double DEFAULT_FOOTER_MARGIN = 0.5;
    private static final int DEFAULT_PRINT_RESOLUTION = 300;
    private static final double DEFAULT_WIDTH_MARGIN = 0.75;
    private static final double DEFAULT_HEIGHT_MARGIN = 1.0;
    private static final int DEFAULT_DEFAULT_COLUMN_WIDTH = 8;
    private static final int DEFAULT_ZOOM_FACTOR = 100;
    private static final int DEFAULT_NORMAL_MAGNIFICATION = 100;
    private static final int DEFAULT_PAGE_BREAK_PREVIEW_MAGNIFICATION = 60;
    public static final int DEFAULT_DEFAULT_ROW_HEIGHT = 255;

    public SheetSettings(Sheet sheet) {
        this.sheet = sheet;
        this.orientation = DEFAULT_ORIENTATION;
        this.paperSize = DEFAULT_PAPER_SIZE;
        this.sheetProtected = false;
        this.hidden = false;
        this.selected = false;
        this.headerMargin = 0.5;
        this.footerMargin = 0.5;
        this.horizontalPrintResolution = 300;
        this.verticalPrintResolution = 300;
        this.leftMargin = 0.75;
        this.rightMargin = 0.75;
        this.topMargin = 1.0;
        this.bottomMargin = 1.0;
        this.fitToPages = false;
        this.showGridLines = true;
        this.printGridLines = false;
        this.printHeaders = false;
        this.pageBreakPreviewMode = false;
        this.displayZeroValues = true;
        this.defaultColumnWidth = 8;
        this.defaultRowHeight = 255;
        this.zoomFactor = 100;
        this.pageBreakPreviewMagnification = 60;
        this.normalMagnification = 100;
        this.horizontalFreeze = 0;
        this.verticalFreeze = 0;
        this.copies = 1;
        this.header = new HeaderFooter();
        this.footer = new HeaderFooter();
        this.automaticFormulaCalculation = true;
        this.recalculateFormulasBeforeSave = true;
    }

    public SheetSettings(SheetSettings sheetSettings, Sheet sheet) {
        Assert.verify(sheetSettings != null);
        this.sheet = sheet;
        this.orientation = sheetSettings.orientation;
        this.paperSize = sheetSettings.paperSize;
        this.sheetProtected = sheetSettings.sheetProtected;
        this.hidden = sheetSettings.hidden;
        this.selected = false;
        this.headerMargin = sheetSettings.headerMargin;
        this.footerMargin = sheetSettings.footerMargin;
        this.scaleFactor = sheetSettings.scaleFactor;
        this.pageStart = sheetSettings.pageStart;
        this.fitWidth = sheetSettings.fitWidth;
        this.fitHeight = sheetSettings.fitHeight;
        this.horizontalPrintResolution = sheetSettings.horizontalPrintResolution;
        this.verticalPrintResolution = sheetSettings.verticalPrintResolution;
        this.leftMargin = sheetSettings.leftMargin;
        this.rightMargin = sheetSettings.rightMargin;
        this.topMargin = sheetSettings.topMargin;
        this.bottomMargin = sheetSettings.bottomMargin;
        this.fitToPages = sheetSettings.fitToPages;
        this.password = sheetSettings.password;
        this.passwordHash = sheetSettings.passwordHash;
        this.defaultColumnWidth = sheetSettings.defaultColumnWidth;
        this.defaultRowHeight = sheetSettings.defaultRowHeight;
        this.zoomFactor = sheetSettings.zoomFactor;
        this.pageBreakPreviewMagnification = sheetSettings.pageBreakPreviewMagnification;
        this.normalMagnification = sheetSettings.normalMagnification;
        this.showGridLines = sheetSettings.showGridLines;
        this.displayZeroValues = sheetSettings.displayZeroValues;
        this.pageBreakPreviewMode = sheetSettings.pageBreakPreviewMode;
        this.horizontalFreeze = sheetSettings.horizontalFreeze;
        this.verticalFreeze = sheetSettings.verticalFreeze;
        this.horizontalCentre = sheetSettings.horizontalCentre;
        this.verticalCentre = sheetSettings.verticalCentre;
        this.copies = sheetSettings.copies;
        this.header = new HeaderFooter(sheetSettings.header);
        this.footer = new HeaderFooter(sheetSettings.footer);
        this.automaticFormulaCalculation = sheetSettings.automaticFormulaCalculation;
        this.recalculateFormulasBeforeSave = sheetSettings.recalculateFormulasBeforeSave;
        if (sheetSettings.printArea != null) {
            this.printArea = new SheetRangeImpl(this.sheet, sheetSettings.getPrintArea().getTopLeft().getColumn(), sheetSettings.getPrintArea().getTopLeft().getRow(), sheetSettings.getPrintArea().getBottomRight().getColumn(), sheetSettings.getPrintArea().getBottomRight().getRow());
        }
    }

    public void setOrientation(PageOrientation pageOrientation) {
        this.orientation = pageOrientation;
    }

    public PageOrientation getOrientation() {
        return this.orientation;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public boolean isProtected() {
        return this.sheetProtected;
    }

    public void setProtected(boolean bl) {
        this.sheetProtected = bl;
    }

    public void setHeaderMargin(double d) {
        this.headerMargin = d;
    }

    public double getHeaderMargin() {
        return this.headerMargin;
    }

    public void setFooterMargin(double d) {
        this.footerMargin = d;
    }

    public double getFooterMargin() {
        return this.footerMargin;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setSelected() {
        this.setSelected(true);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setScaleFactor(int n) {
        this.scaleFactor = n;
        this.fitToPages = false;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setPageStart(int n) {
        this.pageStart = n;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public void setFitWidth(int n) {
        this.fitWidth = n;
        this.fitToPages = true;
    }

    public int getFitWidth() {
        return this.fitWidth;
    }

    public void setFitHeight(int n) {
        this.fitHeight = n;
        this.fitToPages = true;
    }

    public int getFitHeight() {
        return this.fitHeight;
    }

    public void setHorizontalPrintResolution(int n) {
        this.horizontalPrintResolution = n;
    }

    public int getHorizontalPrintResolution() {
        return this.horizontalPrintResolution;
    }

    public void setVerticalPrintResolution(int n) {
        this.verticalPrintResolution = n;
    }

    public int getVerticalPrintResolution() {
        return this.verticalPrintResolution;
    }

    public void setRightMargin(double d) {
        this.rightMargin = d;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setLeftMargin(double d) {
        this.leftMargin = d;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public void setTopMargin(double d) {
        this.topMargin = d;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(double d) {
        this.bottomMargin = d;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public double getDefaultWidthMargin() {
        return 0.75;
    }

    public double getDefaultHeightMargin() {
        return 1.0;
    }

    public boolean getFitToPages() {
        return this.fitToPages;
    }

    public void setFitToPages(boolean bl) {
        this.fitToPages = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(int n) {
        this.passwordHash = n;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int n) {
        this.defaultColumnWidth = n;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int n) {
        this.defaultRowHeight = n;
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int n) {
        this.zoomFactor = n;
    }

    public int getPageBreakPreviewMagnification() {
        return this.pageBreakPreviewMagnification;
    }

    public void setPageBreakPreviewMagnification(int n) {
        this.pageBreakPreviewMagnification = n;
    }

    public int getNormalMagnification() {
        return this.normalMagnification;
    }

    public void setNormalMagnification(int n) {
        this.normalMagnification = n;
    }

    public boolean getDisplayZeroValues() {
        return this.displayZeroValues;
    }

    public void setDisplayZeroValues(boolean bl) {
        this.displayZeroValues = bl;
    }

    public boolean getShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(boolean bl) {
        this.showGridLines = bl;
    }

    public boolean getPageBreakPreviewMode() {
        return this.pageBreakPreviewMode;
    }

    public void setPageBreakPreviewMode(boolean bl) {
        this.pageBreakPreviewMode = bl;
    }

    public boolean getPrintGridLines() {
        return this.printGridLines;
    }

    public void setPrintGridLines(boolean bl) {
        this.printGridLines = bl;
    }

    public boolean getPrintHeaders() {
        return this.printHeaders;
    }

    public void setPrintHeaders(boolean bl) {
        this.printHeaders = bl;
    }

    public int getHorizontalFreeze() {
        return this.horizontalFreeze;
    }

    public void setHorizontalFreeze(int n) {
        this.horizontalFreeze = Math.max(n, 0);
    }

    public int getVerticalFreeze() {
        return this.verticalFreeze;
    }

    public void setVerticalFreeze(int n) {
        this.verticalFreeze = Math.max(n, 0);
    }

    public void setCopies(int n) {
        this.copies = n;
    }

    public int getCopies() {
        return this.copies;
    }

    public HeaderFooter getHeader() {
        return this.header;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    public HeaderFooter getFooter() {
        return this.footer;
    }

    public boolean isHorizontalCentre() {
        return this.horizontalCentre;
    }

    public void setHorizontalCentre(boolean bl) {
        this.horizontalCentre = bl;
    }

    public boolean isVerticalCentre() {
        return this.verticalCentre;
    }

    public void setVerticalCentre(boolean bl) {
        this.verticalCentre = bl;
    }

    public void setAutomaticFormulaCalculation(boolean bl) {
        this.automaticFormulaCalculation = bl;
    }

    public boolean getAutomaticFormulaCalculation() {
        return this.automaticFormulaCalculation;
    }

    public void setRecalculateFormulasBeforeSave(boolean bl) {
        this.recalculateFormulasBeforeSave = bl;
    }

    public boolean getRecalculateFormulasBeforeSave() {
        return this.recalculateFormulasBeforeSave;
    }

    public void setPrintArea(int n, int n2, int n3, int n4) {
        this.printArea = new SheetRangeImpl(this.sheet, n, n2, n3, n4);
    }

    public Range getPrintArea() {
        return this.printArea;
    }
}

