/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import common.Logger;
import java.util.HashMap;
import java.util.Locale;
import jxl.biff.CountryCode;
import jxl.biff.formula.FunctionNames;

public final class WorkbookSettings {
    private static Logger logger = Logger.getLogger(WorkbookSettings.class);
    private int initialFileSize = 0x500000;
    private int arrayGrowSize = 0x100000;
    private boolean drawingsDisabled;
    private boolean namesDisabled;
    private boolean formulaReferenceAdjustDisabled;
    private boolean gcDisabled;
    private boolean rationalizationDisabled;
    private boolean mergedCellCheckingDisabled;
    private boolean propertySetsDisabled;
    private boolean cellValidationDisabled;
    private boolean ignoreBlankCells;
    private boolean autoFilterDisabled;
    private Locale locale;
    private FunctionNames functionNames;
    private String encoding;
    private int characterSet;
    private String excelDisplayLanguage;
    private String excelRegionalSettings;
    private HashMap localeFunctionNames = new HashMap();
    private static final int DEFAULT_INITIAL_FILE_SIZE = 0x500000;
    private static final int DEFAULT_ARRAY_GROW_SIZE = 0x100000;

    public WorkbookSettings() {
        this.excelDisplayLanguage = CountryCode.USA.getCode();
        this.excelRegionalSettings = CountryCode.UK.getCode();
        try {
            boolean bl = true;
            this.setSuppressWarnings(bl);
            this.drawingsDisabled = Boolean.getBoolean("jxl.nodrawings");
            this.namesDisabled = Boolean.getBoolean("jxl.nonames");
            this.gcDisabled = Boolean.getBoolean("jxl.nogc");
            this.rationalizationDisabled = Boolean.getBoolean("jxl.norat");
            this.mergedCellCheckingDisabled = Boolean.getBoolean("jxl.nomergedcellchecks");
            this.formulaReferenceAdjustDisabled = Boolean.getBoolean("jxl.noformulaadjust");
            this.propertySetsDisabled = Boolean.getBoolean("jxl.nopropertysets");
            this.ignoreBlankCells = Boolean.getBoolean("jxl.ignoreblanks");
            this.cellValidationDisabled = Boolean.getBoolean("jxl.nocellvalidation");
            this.autoFilterDisabled = !Boolean.getBoolean("jxl.autofilter");
            this.encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            logger.warn("Error accessing system properties.", securityException);
        }
        try {
            this.locale = System.getProperty("jxl.lang") == null || System.getProperty("jxl.country") == null ? Locale.getDefault() : new Locale(System.getProperty("jxl.lang"), System.getProperty("jxl.country"));
            if (System.getProperty("jxl.encoding") != null) {
                this.encoding = System.getProperty("jxl.encoding");
            }
        }
        catch (SecurityException securityException) {
            logger.warn("Error accessing system properties.", securityException);
            this.locale = Locale.getDefault();
        }
    }

    public void setArrayGrowSize(int n) {
        this.arrayGrowSize = n;
    }

    public int getArrayGrowSize() {
        return this.arrayGrowSize;
    }

    public void setInitialFileSize(int n) {
        this.initialFileSize = n;
    }

    public int getInitialFileSize() {
        return this.initialFileSize;
    }

    public boolean getDrawingsDisabled() {
        return this.drawingsDisabled;
    }

    public boolean getGCDisabled() {
        return this.gcDisabled;
    }

    public boolean getNamesDisabled() {
        return this.namesDisabled;
    }

    public void setNamesDisabled(boolean bl) {
        this.namesDisabled = bl;
    }

    public void setDrawingsDisabled(boolean bl) {
        this.drawingsDisabled = bl;
    }

    public void setRationalization(boolean bl) {
        this.rationalizationDisabled = !bl;
    }

    public boolean getRationalizationDisabled() {
        return this.rationalizationDisabled;
    }

    public boolean getMergedCellCheckingDisabled() {
        return this.mergedCellCheckingDisabled;
    }

    public void setMergedCellChecking(boolean bl) {
        this.mergedCellCheckingDisabled = !bl;
    }

    public void setPropertySets(boolean bl) {
        this.propertySetsDisabled = !bl;
    }

    public boolean getPropertySetsDisabled() {
        return this.propertySetsDisabled;
    }

    public void setSuppressWarnings(boolean bl) {
        logger.setSuppressWarnings(bl);
    }

    public boolean getFormulaAdjust() {
        return !this.formulaReferenceAdjustDisabled;
    }

    public void setFormulaAdjust(boolean bl) {
        this.formulaReferenceAdjustDisabled = !bl;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public FunctionNames getFunctionNames() {
        if (this.functionNames == null) {
            this.functionNames = (FunctionNames)this.localeFunctionNames.get(this.locale);
            if (this.functionNames == null) {
                this.functionNames = new FunctionNames(this.locale);
                this.localeFunctionNames.put(this.locale, this.functionNames);
            }
        }
        return this.functionNames;
    }

    public int getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(int n) {
        this.characterSet = n;
    }

    public void setGCDisabled(boolean bl) {
        this.gcDisabled = bl;
    }

    public void setIgnoreBlanks(boolean bl) {
        this.ignoreBlankCells = bl;
    }

    public boolean getIgnoreBlanks() {
        return this.ignoreBlankCells;
    }

    public void setCellValidationDisabled(boolean bl) {
        this.cellValidationDisabled = bl;
    }

    public boolean getCellValidationDisabled() {
        return this.cellValidationDisabled;
    }

    public String getExcelDisplayLanguage() {
        return this.excelDisplayLanguage;
    }

    public String getExcelRegionalSettings() {
        return this.excelRegionalSettings;
    }

    public void setExcelDisplayLanguage(String string) {
        this.excelDisplayLanguage = string;
    }

    public void setExcelRegionalSettings(String string) {
        this.excelRegionalSettings = string;
    }

    public boolean getAutoFilterDisabled() {
        return this.autoFilterDisabled;
    }

    public void setAutoFilterDisabled(boolean bl) {
        this.autoFilterDisabled = bl;
    }
}

