/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import java.util.Collection;
import jxl.biff.DVParser;
import jxl.biff.DataValiditySettingsRecord;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Comment;
import jxl.write.biff.CellValue;

public class BaseCellFeatures {
    public static Logger logger = Logger.getLogger(BaseCellFeatures.class);
    private String comment;
    private double commentWidth;
    private double commentHeight;
    private Comment commentDrawing;
    private ComboBox comboBox;
    private DataValiditySettingsRecord validationSettings;
    private DVParser dvParser;
    private boolean dropDown;
    private boolean dataValidation;
    private CellValue writableCell;
    private static final double defaultCommentWidth = 3.0;
    private static final double defaultCommentHeight = 4.0;
    public static final ValidationCondition BETWEEN = new ValidationCondition(DVParser.BETWEEN);
    public static final ValidationCondition NOT_BETWEEN = new ValidationCondition(DVParser.NOT_BETWEEN);
    public static final ValidationCondition EQUAL = new ValidationCondition(DVParser.EQUAL);
    public static final ValidationCondition NOT_EQUAL = new ValidationCondition(DVParser.NOT_EQUAL);
    public static final ValidationCondition GREATER_THAN = new ValidationCondition(DVParser.GREATER_THAN);
    public static final ValidationCondition LESS_THAN = new ValidationCondition(DVParser.LESS_THAN);
    public static final ValidationCondition GREATER_EQUAL = new ValidationCondition(DVParser.GREATER_EQUAL);
    public static final ValidationCondition LESS_EQUAL = new ValidationCondition(DVParser.LESS_EQUAL);

    protected BaseCellFeatures() {
    }

    public BaseCellFeatures(BaseCellFeatures baseCellFeatures) {
        this.comment = baseCellFeatures.comment;
        this.commentWidth = baseCellFeatures.commentWidth;
        this.commentHeight = baseCellFeatures.commentHeight;
        this.dropDown = baseCellFeatures.dropDown;
        this.dataValidation = baseCellFeatures.dataValidation;
        this.validationSettings = baseCellFeatures.validationSettings;
    }

    protected String getComment() {
        return this.comment;
    }

    public double getCommentWidth() {
        return this.commentWidth;
    }

    public double getCommentHeight() {
        return this.commentHeight;
    }

    public final void setWritableCell(CellValue cellValue) {
        this.writableCell = cellValue;
    }

    public void setReadComment(String string, double d, double d2) {
        this.comment = string;
        this.commentWidth = d;
        this.commentHeight = d2;
    }

    public void setValidationSettings(DataValiditySettingsRecord dataValiditySettingsRecord) {
        Assert.verify(dataValiditySettingsRecord != null);
        this.validationSettings = dataValiditySettingsRecord;
        this.dataValidation = true;
    }

    public void setComment(String string) {
        this.setComment(string, 3.0, 4.0);
    }

    public void setComment(String string, double d, double d2) {
        this.comment = string;
        this.commentWidth = d;
        this.commentHeight = d2;
        if (this.commentDrawing != null) {
            this.commentDrawing.setCommentText(string);
            this.commentDrawing.setWidth(d);
            this.commentDrawing.setWidth(d2);
        }
    }

    public void removeComment() {
        this.comment = null;
        if (this.commentDrawing != null) {
            this.writableCell.removeComment(this.commentDrawing);
            this.commentDrawing = null;
        }
    }

    public final void setCommentDrawing(Comment comment) {
        this.commentDrawing = comment;
    }

    public final Comment getCommentDrawing() {
        return this.commentDrawing;
    }

    public String getDataValidationList() {
        if (this.validationSettings == null) {
            return null;
        }
        return this.validationSettings.getValidationFormula();
    }

    public void setDataValidationList(Collection collection) {
        this.clearValidationSettings();
        this.dvParser = new DVParser(collection);
        this.dropDown = true;
        this.dataValidation = true;
    }

    public void setDataValidationRange(int n, int n2, int n3, int n4) {
        this.clearValidationSettings();
        this.dvParser = new DVParser(n, n2, n3, n4);
        this.dropDown = true;
        this.dataValidation = true;
    }

    public void setDataValidationRange(String string) {
        this.clearValidationSettings();
        this.dvParser = new DVParser(string);
        this.dropDown = true;
        this.dataValidation = true;
    }

    public void setNumberValidation(double d, ValidationCondition validationCondition) {
        this.clearValidationSettings();
        this.dvParser = new DVParser(d, Double.NaN, validationCondition.getCondition());
        this.dropDown = false;
        this.dataValidation = true;
    }

    public void setNumberValidation(double d, double d2, ValidationCondition validationCondition) {
        this.clearValidationSettings();
        this.dvParser = new DVParser(d, d2, validationCondition.getCondition());
        this.dropDown = false;
        this.dataValidation = true;
    }

    public boolean hasDataValidation() {
        return this.dataValidation;
    }

    private void clearValidationSettings() {
        this.validationSettings = null;
        this.dvParser = null;
        this.dropDown = false;
        this.comboBox = null;
        this.dataValidation = false;
    }

    public boolean hasDropDown() {
        return this.dropDown;
    }

    public void setComboBox(ComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public DVParser getDVParser() {
        if (this.dvParser != null) {
            return this.dvParser;
        }
        if (this.validationSettings != null) {
            this.dvParser = new DVParser(this.validationSettings.getDVParser());
            return this.dvParser;
        }
        return null;
    }

    protected static class ValidationCondition {
        private DVParser.Condition condition;
        private static ValidationCondition[] types = new ValidationCondition[0];

        ValidationCondition(DVParser.Condition condition) {
            this.condition = condition;
            ValidationCondition[] validationConditionArray = types;
            types = new ValidationCondition[validationConditionArray.length + 1];
            System.arraycopy(validationConditionArray, 0, types, 0, validationConditionArray.length);
            ValidationCondition.types[validationConditionArray.length] = this;
        }

        public DVParser.Condition getCondition() {
            return this.condition;
        }
    }
}

