/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class ConditionalFormatRangeRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(ConditionalFormatRangeRecord.class);
    private Range enclosingRange;
    private Range[] ranges;
    private int numRanges;
    private boolean initialized = false;
    private boolean modified = false;
    private byte[] data = this.getRecord().getData();

    public ConditionalFormatRangeRecord(Record record) {
        super(record);
    }

    private void initialize() {
        this.enclosingRange = new Range();
        this.enclosingRange.firstRow = IntegerHelper.getInt(this.data[4], this.data[5]);
        this.enclosingRange.lastRow = IntegerHelper.getInt(this.data[6], this.data[7]);
        this.enclosingRange.firstColumn = IntegerHelper.getInt(this.data[8], this.data[9]);
        this.enclosingRange.lastColumn = IntegerHelper.getInt(this.data[10], this.data[11]);
        this.numRanges = IntegerHelper.getInt(this.data[12], this.data[13]);
        this.ranges = new Range[this.numRanges];
        int n = 14;
        for (int i = 0; i < this.numRanges; ++i) {
            this.ranges[i] = new Range();
            this.ranges[i].firstRow = IntegerHelper.getInt(this.data[n], this.data[n + 1]);
            this.ranges[i].lastRow = IntegerHelper.getInt(this.data[n + 2], this.data[n + 3]);
            this.ranges[i].firstColumn = IntegerHelper.getInt(this.data[n + 4], this.data[n + 5]);
            this.ranges[i].lastColumn = IntegerHelper.getInt(this.data[n + 6], this.data[n + 7]);
            n += 8;
        }
        this.initialized = true;
    }

    public void insertColumn(int n) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.insertColumn(n);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].insertColumn(n);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public void removeColumn(int n) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.removeColumn(n);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].removeColumn(n);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public void removeRow(int n) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.removeRow(n);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].removeRow(n);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public void insertRow(int n) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.insertRow(n);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].insertRow(n);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public byte[] getData() {
        if (!this.modified) {
            return this.data;
        }
        byte[] byArray = new byte[14 + this.ranges.length * 8];
        System.arraycopy(this.data, 0, byArray, 0, 4);
        IntegerHelper.getTwoBytes(this.enclosingRange.firstRow, byArray, 4);
        IntegerHelper.getTwoBytes(this.enclosingRange.lastRow, byArray, 6);
        IntegerHelper.getTwoBytes(this.enclosingRange.firstColumn, byArray, 8);
        IntegerHelper.getTwoBytes(this.enclosingRange.lastColumn, byArray, 10);
        IntegerHelper.getTwoBytes(this.numRanges, byArray, 12);
        int n = 14;
        for (int i = 0; i < this.ranges.length; ++i) {
            IntegerHelper.getTwoBytes(this.ranges[i].firstRow, byArray, n);
            IntegerHelper.getTwoBytes(this.ranges[i].lastRow, byArray, n + 2);
            IntegerHelper.getTwoBytes(this.ranges[i].firstColumn, byArray, n + 4);
            IntegerHelper.getTwoBytes(this.ranges[i].lastColumn, byArray, n + 6);
            n += 8;
        }
        return byArray;
    }

    private static class Range {
        public int firstRow;
        public int firstColumn;
        public int lastRow;
        public int lastColumn;
        public boolean modified = false;

        public void insertColumn(int n) {
            if (n > this.lastColumn) {
                return;
            }
            if (n <= this.firstColumn) {
                ++this.firstColumn;
                this.modified = true;
            }
            if (n <= this.lastColumn) {
                ++this.lastColumn;
                this.modified = true;
            }
        }

        public void removeColumn(int n) {
            if (n > this.lastColumn) {
                return;
            }
            if (n < this.firstColumn) {
                --this.firstColumn;
                this.modified = true;
            }
            if (n <= this.lastColumn) {
                --this.lastColumn;
                this.modified = true;
            }
        }

        public void removeRow(int n) {
            if (n > this.lastRow) {
                return;
            }
            if (n < this.firstRow) {
                --this.firstRow;
                this.modified = true;
            }
            if (n <= this.lastRow) {
                --this.lastRow;
                this.modified = true;
            }
        }

        public void insertRow(int n) {
            if (n > this.lastRow) {
                return;
            }
            if (n <= this.firstRow) {
                ++this.firstRow;
                this.modified = true;
            }
            if (n <= this.lastRow) {
                ++this.lastColumn;
                this.modified = true;
            }
        }
    }
}

