/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.CellReferenceHelper;
import jxl.biff.EmptyCell;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;

public class DVParser {
    private static Logger logger = Logger.getLogger(DVParser.class);
    public static final DVType ANY = new DVType(0, "any");
    public static final DVType INTEGER = new DVType(1, "int");
    public static final DVType DECIMAL = new DVType(2, "dec");
    public static final DVType LIST = new DVType(3, "list");
    public static final DVType DATE = new DVType(4, "date");
    public static final DVType TIME = new DVType(5, "time");
    public static final DVType TEXT_LENGTH = new DVType(6, "strlen");
    public static final DVType FORMULA = new DVType(7, "form");
    public static final ErrorStyle STOP = new ErrorStyle(0);
    public static final ErrorStyle WARNING = new ErrorStyle(1);
    public static final ErrorStyle INFO = new ErrorStyle(2);
    public static final Condition BETWEEN = new Condition(0, "{0} <= x <= {1}");
    public static final Condition NOT_BETWEEN = new Condition(1, "!({0} <= x <= {1}");
    public static final Condition EQUAL = new Condition(2, "x == {0}");
    public static final Condition NOT_EQUAL = new Condition(3, "x != {0}");
    public static final Condition GREATER_THAN = new Condition(4, "x > {0}");
    public static final Condition LESS_THAN = new Condition(5, "x < {0}");
    public static final Condition GREATER_EQUAL = new Condition(6, "x >= {0}");
    public static final Condition LESS_EQUAL = new Condition(7, "x <= {0}");
    private static int STRING_LIST_GIVEN_MASK = 128;
    private static int EMPTY_CELLS_ALLOWED_MASK = 256;
    private static int SUPPRESS_ARROW_MASK = 512;
    private static int SHOW_PROMPT_MASK = 262144;
    private static int SHOW_ERROR_MASK = 524288;
    private static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");
    private DVType type;
    private ErrorStyle errorStyle;
    private Condition condition;
    private boolean stringListGiven;
    private boolean emptyCellsAllowed;
    private boolean suppressArrow;
    private boolean showPrompt;
    private boolean showError;
    private String promptTitle;
    private String errorTitle;
    private String promptText;
    private String errorText;
    private FormulaParser formula1;
    private String formula1String;
    private FormulaParser formula2;
    private String formula2String;
    private int column1;
    private int row1;
    private int column2;
    private int row2;

    public DVParser(byte[] byArray, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) throws FormulaException {
        byte[] byArray2;
        Assert.verify(workbookMethods != null);
        int n = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        int n2 = n & 0xF;
        this.type = DVType.getType(n2);
        int n3 = (n & 0x70) >> 4;
        this.errorStyle = ErrorStyle.getErrorStyle(n3);
        int n4 = (n & 0xF00000) >> 20;
        this.condition = Condition.getCondition(n4);
        this.stringListGiven = (n & STRING_LIST_GIVEN_MASK) != 0;
        this.emptyCellsAllowed = (n & EMPTY_CELLS_ALLOWED_MASK) != 0;
        this.suppressArrow = (n & SUPPRESS_ARROW_MASK) != 0;
        this.showPrompt = (n & SHOW_PROMPT_MASK) != 0;
        this.showError = (n & SHOW_ERROR_MASK) != 0;
        int n5 = 4;
        int n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        if (n6 > 0 && byArray[n5 + 2] == 0) {
            this.promptTitle = StringHelper.getString(byArray, n6, n5 + 3, workbookSettings);
            n5 += n6 + 3;
        } else if (n6 > 0) {
            this.promptTitle = StringHelper.getUnicodeString(byArray, n6, n5 + 3);
            n5 += n6 * 2 + 3;
        } else {
            n5 += 2;
        }
        n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        if (n6 > 0 && byArray[n5 + 2] == 0) {
            this.errorTitle = StringHelper.getString(byArray, n6, n5 + 3, workbookSettings);
            n5 += n6 + 3;
        } else if (n6 > 0) {
            this.errorTitle = StringHelper.getUnicodeString(byArray, n6, n5 + 3);
            n5 += n6 * 2 + 3;
        } else {
            n5 += 2;
        }
        n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        if (n6 > 0 && byArray[n5 + 2] == 0) {
            this.promptText = StringHelper.getString(byArray, n6, n5 + 3, workbookSettings);
            n5 += n6 + 3;
        } else if (n6 > 0) {
            this.promptText = StringHelper.getUnicodeString(byArray, n6, n5 + 3);
            n5 += n6 * 2 + 3;
        } else {
            n5 += 2;
        }
        n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        if (n6 > 0 && byArray[n5 + 2] == 0) {
            this.errorText = StringHelper.getString(byArray, n6, n5 + 3, workbookSettings);
            n5 += n6 + 3;
        } else if (n6 > 0) {
            this.errorText = StringHelper.getUnicodeString(byArray, n6, n5 + 3);
            n5 += n6 * 2 + 3;
        } else {
            n5 += 2;
        }
        int n7 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        int n8 = n5 += 4;
        int n9 = IntegerHelper.getInt(byArray[n5 += n7], byArray[n5 + 1]);
        int n10 = n5 += 4;
        n5 += n9;
        this.row1 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        this.row2 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        this.column1 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        this.column2 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        n5 += 2;
        EmptyCell emptyCell = new EmptyCell(this.column1, this.row1);
        if (n7 != 0) {
            byArray2 = new byte[n7];
            System.arraycopy(byArray, n8, byArray2, 0, n7);
            this.formula1 = new FormulaParser(byArray2, emptyCell, externalSheet, workbookMethods, workbookSettings);
            try {
                this.formula1.parse();
            }
            catch (FormulaException formulaException) {
                // empty catch block
            }
        }
        if (n9 != 0) {
            byArray2 = new byte[n9];
            System.arraycopy(byArray, n10, byArray2, 0, n9);
            this.formula2 = new FormulaParser(byArray2, emptyCell, externalSheet, workbookMethods, workbookSettings);
            try {
                this.formula2.parse();
            }
            catch (FormulaException formulaException) {
                // empty catch block
            }
        }
    }

    public DVParser(Collection collection) {
        this.type = LIST;
        this.errorStyle = STOP;
        this.condition = BETWEEN;
        this.stringListGiven = true;
        this.emptyCellsAllowed = true;
        this.suppressArrow = false;
        this.showPrompt = true;
        this.showError = true;
        this.promptTitle = "\u0000";
        this.errorTitle = "\u0000";
        this.promptText = "\u0000";
        this.errorText = "\u0000";
        if (collection.size() == 0) {
            logger.warn("no validation strings - ignoring");
        }
        Iterator iterator = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(iterator.next().toString());
        while (iterator.hasNext()) {
            stringBuffer.append('\u0000');
            stringBuffer.append(' ');
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append('\"');
        this.formula1String = stringBuffer.toString();
    }

    public DVParser(String string) {
        this.type = LIST;
        this.errorStyle = STOP;
        this.condition = BETWEEN;
        this.stringListGiven = false;
        this.emptyCellsAllowed = true;
        this.suppressArrow = false;
        this.showPrompt = true;
        this.showError = true;
        this.promptTitle = "\u0000";
        this.errorTitle = "\u0000";
        this.promptText = "\u0000";
        this.errorText = "\u0000";
        this.formula1String = string;
    }

    public DVParser(int n, int n2, int n3, int n4) {
        this.type = LIST;
        this.errorStyle = STOP;
        this.condition = BETWEEN;
        this.stringListGiven = false;
        this.emptyCellsAllowed = true;
        this.suppressArrow = false;
        this.showPrompt = true;
        this.showError = true;
        this.promptTitle = "\u0000";
        this.errorTitle = "\u0000";
        this.promptText = "\u0000";
        this.errorText = "\u0000";
        StringBuffer stringBuffer = new StringBuffer();
        CellReferenceHelper.getCellReference(n, n2, stringBuffer);
        stringBuffer.append(':');
        CellReferenceHelper.getCellReference(n3, n4, stringBuffer);
        this.formula1String = stringBuffer.toString();
    }

    public DVParser(double d, double d2, Condition condition) {
        this.type = DECIMAL;
        this.errorStyle = STOP;
        this.condition = condition;
        this.stringListGiven = false;
        this.emptyCellsAllowed = true;
        this.suppressArrow = false;
        this.showPrompt = true;
        this.showError = true;
        this.promptTitle = "\u0000";
        this.errorTitle = "\u0000";
        this.promptText = "\u0000";
        this.errorText = "\u0000";
        this.formula1String = DECIMAL_FORMAT.format(d);
        if (!Double.isNaN(d2)) {
            this.formula2String = DECIMAL_FORMAT.format(d2);
        }
    }

    public DVParser(DVParser dVParser) {
        this.type = dVParser.type;
        this.errorStyle = dVParser.errorStyle;
        this.condition = dVParser.condition;
        this.stringListGiven = dVParser.stringListGiven;
        this.emptyCellsAllowed = dVParser.emptyCellsAllowed;
        this.suppressArrow = dVParser.suppressArrow;
        this.showPrompt = dVParser.showPrompt;
        this.showError = dVParser.showError;
        this.promptTitle = dVParser.promptTitle;
        this.promptText = dVParser.promptText;
        this.errorTitle = dVParser.errorTitle;
        this.errorText = dVParser.errorText;
        try {
            this.formula1String = dVParser.formula1.getFormula();
            this.formula2String = dVParser.formula2 != null ? dVParser.formula2.getFormula() : null;
        }
        catch (FormulaException formulaException) {
            logger.warn("Cannot parse validation formula:  " + formulaException.getMessage());
        }
    }

    public byte[] getData() {
        byte[] byArray = this.formula1 != null ? this.formula1.getBytes() : new byte[]{};
        byte[] byArray2 = this.formula2 != null ? this.formula2.getBytes() : new byte[]{};
        int n = 4 + this.promptTitle.length() * 2 + 2 + this.errorTitle.length() * 2 + 2 + this.promptText.length() * 2 + 2 + this.errorText.length() * 2 + 2 + byArray.length + 2 + byArray2.length + 2 + 4 + 10;
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        n3 |= this.type.getValue();
        n3 |= this.errorStyle.getValue() << 4;
        n3 |= this.condition.getValue() << 20;
        if (this.stringListGiven) {
            n3 |= STRING_LIST_GIVEN_MASK;
        }
        if (this.emptyCellsAllowed) {
            n3 |= EMPTY_CELLS_ALLOWED_MASK;
        }
        if (this.suppressArrow) {
            n3 |= SUPPRESS_ARROW_MASK;
        }
        if (this.showPrompt) {
            n3 |= SHOW_PROMPT_MASK;
        }
        if (this.showError) {
            n3 |= SHOW_ERROR_MASK;
        }
        IntegerHelper.getFourBytes(n3, byArray3, n2);
        IntegerHelper.getTwoBytes(this.promptTitle.length(), byArray3, n2 += 4);
        StringHelper.getUnicodeBytes(this.promptTitle, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.errorTitle.length(), byArray3, n2 += this.promptTitle.length() * 2);
        StringHelper.getUnicodeBytes(this.errorTitle, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.promptText.length(), byArray3, n2 += this.errorTitle.length() * 2);
        StringHelper.getUnicodeBytes(this.promptText, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.errorText.length(), byArray3, n2 += this.promptText.length() * 2);
        StringHelper.getUnicodeBytes(this.errorText, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(byArray.length, byArray3, n2 += this.errorText.length() * 2);
        System.arraycopy(byArray, 0, byArray3, n2 += 4, byArray.length);
        IntegerHelper.getTwoBytes(byArray2.length, byArray3, n2 += byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n2 += 4, byArray2.length);
        IntegerHelper.getTwoBytes(1, byArray3, n2 += byArray2.length);
        IntegerHelper.getTwoBytes(this.row1, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.row2, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.column1, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.column2, byArray3, n2 += 2);
        n2 += 2;
        return byArray3;
    }

    public void insertRow(int n) {
        if (this.formula1 != null) {
            this.formula1.rowInserted(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.rowInserted(0, n, true);
        }
        if (this.row1 >= n) {
            ++this.row1;
        }
        if (this.row2 >= n) {
            ++this.row2;
        }
    }

    public void insertColumn(int n) {
        if (this.formula1 != null) {
            this.formula1.columnInserted(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.columnInserted(0, n, true);
        }
        if (this.column1 >= n) {
            ++this.column1;
        }
        if (this.column2 >= n) {
            ++this.column2;
        }
    }

    public void removeRow(int n) {
        if (this.formula1 != null) {
            this.formula1.rowRemoved(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.rowRemoved(0, n, true);
        }
        if (this.row1 > n) {
            --this.row1;
        }
        if (this.row2 >= n) {
            --this.row2;
        }
    }

    public void removeColumn(int n) {
        if (this.formula1 != null) {
            this.formula1.columnRemoved(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.columnRemoved(0, n, true);
        }
        if (this.column1 > n) {
            --this.column1;
        }
        if (this.column2 >= n) {
            --this.column2;
        }
    }

    public int getFirstColumn() {
        return this.column1;
    }

    public int getLastColumn() {
        return this.column2;
    }

    public int getFirstRow() {
        return this.row1;
    }

    public int getLastRow() {
        return this.row2;
    }

    String getValidationFormula() throws FormulaException {
        if (this.type == LIST) {
            return this.formula1.getFormula();
        }
        String string = this.formula1.getFormula();
        String string2 = this.formula2 != null ? this.formula2.getFormula() : null;
        return this.condition.getConditionString(string, string2) + "; x " + this.type.getDescription();
    }

    public void setCell(int n, int n2, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) throws FormulaException {
        this.row1 = n2;
        this.row2 = n2;
        this.column1 = n;
        this.column2 = n;
        this.formula1 = new FormulaParser(this.formula1String, externalSheet, workbookMethods, workbookSettings);
        this.formula1.parse();
        if (this.formula2String != null) {
            this.formula2 = new FormulaParser(this.formula2String, externalSheet, workbookMethods, workbookSettings);
            this.formula2.parse();
        }
    }

    public static class Condition {
        private int value;
        private MessageFormat format;
        private static Condition[] types = new Condition[0];

        Condition(int n, String string) {
            this.value = n;
            this.format = new MessageFormat(string);
            Condition[] conditionArray = types;
            types = new Condition[conditionArray.length + 1];
            System.arraycopy(conditionArray, 0, types, 0, conditionArray.length);
            Condition.types[conditionArray.length] = this;
        }

        static Condition getCondition(int n) {
            Condition condition = null;
            for (int i = 0; i < types.length && condition == null; ++i) {
                if (Condition.types[i].value != n) continue;
                condition = types[i];
            }
            return condition;
        }

        public int getValue() {
            return this.value;
        }

        public String getConditionString(String string, String string2) {
            return this.format.format(new String[]{string, string2});
        }
    }

    public static class ErrorStyle {
        private int value;
        private static ErrorStyle[] types = new ErrorStyle[0];

        ErrorStyle(int n) {
            this.value = n;
            ErrorStyle[] errorStyleArray = types;
            types = new ErrorStyle[errorStyleArray.length + 1];
            System.arraycopy(errorStyleArray, 0, types, 0, errorStyleArray.length);
            ErrorStyle.types[errorStyleArray.length] = this;
        }

        static ErrorStyle getErrorStyle(int n) {
            ErrorStyle errorStyle = null;
            for (int i = 0; i < types.length && errorStyle == null; ++i) {
                if (ErrorStyle.types[i].value != n) continue;
                errorStyle = types[i];
            }
            return errorStyle;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class DVType {
        private int value;
        private String desc;
        private static DVType[] types = new DVType[0];

        DVType(int n, String string) {
            this.value = n;
            this.desc = string;
            DVType[] dVTypeArray = types;
            types = new DVType[dVTypeArray.length + 1];
            System.arraycopy(dVTypeArray, 0, types, 0, dVTypeArray.length);
            DVType.types[dVTypeArray.length] = this;
        }

        static DVType getType(int n) {
            DVType dVType = null;
            for (int i = 0; i < types.length && dVType == null; ++i) {
                if (DVType.types[i].value != n) continue;
                dVType = types[i];
            }
            return dVType;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

