/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.DValParser;
import jxl.biff.DataValidityListRecord;
import jxl.biff.DataValiditySettingsRecord;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.write.biff.File;

public class DataValidation {
    private static Logger logger = Logger.getLogger(DataValidation.class);
    private DataValidityListRecord validityList;
    private ArrayList validitySettings;
    private WorkbookMethods workbook;
    private ExternalSheet externalSheet;
    private WorkbookSettings workbookSettings;
    private int comboBoxObjectId;
    private boolean copied;
    public static final int DEFAULT_OBJECT_ID = -1;

    public DataValidation(DataValidityListRecord dataValidityListRecord) {
        this.validityList = dataValidityListRecord;
        this.validitySettings = new ArrayList(this.validityList.getNumberOfSettings());
        this.copied = false;
    }

    public DataValidation(int n, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        this.workbook = workbookMethods;
        this.externalSheet = externalSheet;
        this.workbookSettings = workbookSettings;
        this.validitySettings = new ArrayList();
        this.comboBoxObjectId = n;
        this.copied = false;
    }

    public DataValidation(DataValidation dataValidation, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        this.workbook = workbookMethods;
        this.externalSheet = externalSheet;
        this.workbookSettings = workbookSettings;
        this.copied = true;
        this.validityList = new DataValidityListRecord(dataValidation.getDataValidityList());
        this.validitySettings = new ArrayList();
        DataValiditySettingsRecord[] dataValiditySettingsRecordArray = dataValidation.getDataValiditySettings();
        for (int i = 0; i < dataValiditySettingsRecordArray.length; ++i) {
            this.validitySettings.add(new DataValiditySettingsRecord(dataValiditySettingsRecordArray[i], this.externalSheet, this.workbook, this.workbookSettings));
        }
    }

    public void add(DataValiditySettingsRecord dataValiditySettingsRecord) {
        this.validitySettings.add(dataValiditySettingsRecord);
        dataValiditySettingsRecord.setDataValidation(this);
        if (this.copied) {
            Assert.verify(this.validityList != null);
            this.validityList.dvAdded();
        }
    }

    public DataValidityListRecord getDataValidityList() {
        return this.validityList;
    }

    public DataValiditySettingsRecord[] getDataValiditySettings() {
        DataValiditySettingsRecord[] dataValiditySettingsRecordArray = new DataValiditySettingsRecord[]{};
        return this.validitySettings.toArray(dataValiditySettingsRecordArray);
    }

    public void write(File file) throws IOException {
        if (this.validityList == null) {
            DValParser dValParser = new DValParser(this.comboBoxObjectId, this.validitySettings.size());
            this.validityList = new DataValidityListRecord(dValParser);
        }
        if (!this.validityList.hasDVRecords()) {
            return;
        }
        file.write(this.validityList);
        for (DataValiditySettingsRecord dataValiditySettingsRecord : this.validitySettings) {
            file.write(dataValiditySettingsRecord);
        }
    }

    public void insertRow(int n) {
        for (DataValiditySettingsRecord dataValiditySettingsRecord : this.validitySettings) {
            dataValiditySettingsRecord.insertRow(n);
        }
    }

    public void removeRow(int n) {
        Iterator iterator = this.validitySettings.iterator();
        while (iterator.hasNext()) {
            DataValiditySettingsRecord dataValiditySettingsRecord = (DataValiditySettingsRecord)iterator.next();
            if (dataValiditySettingsRecord.getFirstRow() == n && dataValiditySettingsRecord.getLastRow() == n) {
                iterator.remove();
                this.validityList.dvRemoved();
                continue;
            }
            dataValiditySettingsRecord.removeRow(n);
        }
    }

    public void insertColumn(int n) {
        for (DataValiditySettingsRecord dataValiditySettingsRecord : this.validitySettings) {
            dataValiditySettingsRecord.insertColumn(n);
        }
    }

    public void removeColumn(int n) {
        Iterator iterator = this.validitySettings.iterator();
        while (iterator.hasNext()) {
            DataValiditySettingsRecord dataValiditySettingsRecord = (DataValiditySettingsRecord)iterator.next();
            if (dataValiditySettingsRecord.getFirstColumn() == n && dataValiditySettingsRecord.getLastColumn() == n) {
                iterator.remove();
                this.validityList.dvRemoved();
                continue;
            }
            dataValiditySettingsRecord.removeColumn(n);
        }
    }

    public DataValiditySettingsRecord getDataValiditySettings(int n, int n2) {
        boolean bl = false;
        DataValiditySettingsRecord dataValiditySettingsRecord = null;
        Iterator iterator = this.validitySettings.iterator();
        while (iterator.hasNext() && !bl) {
            DataValiditySettingsRecord dataValiditySettingsRecord2 = (DataValiditySettingsRecord)iterator.next();
            if (dataValiditySettingsRecord2.getFirstColumn() != n || dataValiditySettingsRecord2.getFirstRow() != n2) continue;
            bl = true;
            dataValiditySettingsRecord = dataValiditySettingsRecord2;
        }
        return dataValiditySettingsRecord;
    }

    public int getComboBoxObjectId() {
        return this.comboBoxObjectId;
    }
}

