/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherStream;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.read.biff.File;

public class Chart
implements ByteData,
EscherStream {
    private static final Logger logger = Logger.getLogger(Chart.class);
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private int startpos;
    private int endpos;
    private File file;
    private DrawingData drawingData;
    private int drawingNumber;
    private byte[] data;
    private boolean initialized;
    private WorkbookSettings workbookSettings;

    public Chart(MsoDrawingRecord msoDrawingRecord, ObjRecord objRecord, DrawingData drawingData, int n, int n2, File file, WorkbookSettings workbookSettings) {
        this.msoDrawingRecord = msoDrawingRecord;
        this.objRecord = objRecord;
        this.startpos = n;
        this.endpos = n2;
        this.file = file;
        this.workbookSettings = workbookSettings;
        if (this.msoDrawingRecord != null) {
            this.drawingData = drawingData;
            this.drawingData.addData(this.msoDrawingRecord.getRecord().getData());
            this.drawingNumber = this.drawingData.getNumDrawings() - 1;
        }
        this.initialized = false;
        Assert.verify(msoDrawingRecord != null && objRecord != null || msoDrawingRecord == null && objRecord == null);
    }

    public byte[] getBytes() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.data;
    }

    public byte[] getData() {
        return this.msoDrawingRecord.getRecord().getData();
    }

    private void initialize() {
        this.data = this.file.read(this.startpos, this.endpos - this.startpos);
        this.initialized = true;
    }

    public void rationalize(IndexMapping indexMapping, IndexMapping indexMapping2, IndexMapping indexMapping3) {
        if (!this.initialized) {
            this.initialize();
        }
        int n = 0;
        int n2 = 0;
        Type type = null;
        for (int i = 0; i < this.data.length; i += n2 + 4) {
            int n3;
            n = IntegerHelper.getInt(this.data[i], this.data[i + 1]);
            n2 = IntegerHelper.getInt(this.data[i + 2], this.data[i + 3]);
            type = Type.getType(n);
            if (type == Type.FONTX) {
                n3 = IntegerHelper.getInt(this.data[i + 4], this.data[i + 5]);
                IntegerHelper.getTwoBytes(indexMapping2.getNewIndex(n3), this.data, i + 4);
                continue;
            }
            if (type == Type.FBI) {
                n3 = IntegerHelper.getInt(this.data[i + 12], this.data[i + 13]);
                IntegerHelper.getTwoBytes(indexMapping2.getNewIndex(n3), this.data, i + 12);
                continue;
            }
            if (type == Type.IFMT) {
                n3 = IntegerHelper.getInt(this.data[i + 4], this.data[i + 5]);
                IntegerHelper.getTwoBytes(indexMapping3.getNewIndex(n3), this.data, i + 4);
                continue;
            }
            if (type != Type.ALRUNS) continue;
            n3 = IntegerHelper.getInt(this.data[i + 4], this.data[i + 5]);
            int n4 = i + 6;
            for (int j = 0; j < n3; ++j) {
                int n5 = IntegerHelper.getInt(this.data[n4 + 2], this.data[n4 + 3]);
                IntegerHelper.getTwoBytes(indexMapping2.getNewIndex(n5), this.data, n4 + 2);
                n4 += 4;
            }
        }
    }

    EscherContainer getSpContainer() {
        EscherContainer escherContainer = this.drawingData.getSpContainer(this.drawingNumber);
        return escherContainer;
    }

    MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

