/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

abstract class EscherRecord {
    private static Logger logger = Logger.getLogger(EscherRecord.class);
    private EscherRecordData data;
    protected static final int HEADER_LENGTH = 8;

    protected EscherRecord(EscherRecordData escherRecordData) {
        this.data = escherRecordData;
    }

    protected EscherRecord(EscherRecordType escherRecordType) {
        this.data = new EscherRecordData(escherRecordType);
    }

    protected void setContainer(boolean bl) {
        this.data.setContainer(bl);
    }

    public int getLength() {
        return this.data.getLength() + 8;
    }

    protected final EscherStream getEscherStream() {
        return this.data.getEscherStream();
    }

    protected final int getPos() {
        return this.data.getPos();
    }

    protected final int getInstance() {
        return this.data.getInstance();
    }

    protected final void setInstance(int n) {
        this.data.setInstance(n);
    }

    protected final void setVersion(int n) {
        this.data.setVersion(n);
    }

    public EscherRecordType getType() {
        return this.data.getType();
    }

    abstract byte[] getData();

    final byte[] setHeaderData(byte[] byArray) {
        return this.data.setHeaderData(byArray);
    }

    byte[] getBytes() {
        return this.data.getBytes();
    }

    protected int getStreamLength() {
        return this.data.getStreamLength();
    }

    protected EscherRecordData getEscherData() {
        return this.data;
    }
}

