/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class ObjRecord
extends WritableRecordData {
    private static final Logger logger = Logger.getLogger(ObjRecord.class);
    private ObjType type;
    private boolean read;
    private int objectId;
    public static final ObjType TBD2 = new ObjType(1, "TBD2");
    public static final ObjType TBD = new ObjType(2, "TBD");
    public static final ObjType CHART = new ObjType(5, "Chart");
    public static final ObjType TEXT = new ObjType(6, "Text");
    public static final ObjType BUTTON = new ObjType(7, "Button");
    public static final ObjType PICTURE = new ObjType(8, "Picture");
    public static final ObjType CHECKBOX = new ObjType(14, "Checkbox");
    public static final ObjType OPTION = new ObjType(12, "Option");
    public static final ObjType EDITBOX = new ObjType(13, "Edit Box");
    public static final ObjType LABEL = new ObjType(14, "Label");
    public static final ObjType DIALOGUEBOX = new ObjType(15, "Dialogue Box");
    public static final ObjType LISTBOX = new ObjType(18, "List Box");
    public static final ObjType GROUPBOX = new ObjType(19, "Group Box");
    public static final ObjType COMBOBOX = new ObjType(20, "Combo Box");
    public static final ObjType MSOFFICEDRAWING = new ObjType(30, "MS Office Drawing");
    public static final ObjType FORMCONTROL = new ObjType(20, "Form Combo Box");
    public static final ObjType EXCELNOTE = new ObjType(25, "Excel Note");
    public static final ObjType UNKNOWN = new ObjType(255, "Unknown");
    private static final int COMMON_DATA_LENGTH = 22;
    private static final int CLIPBOARD_FORMAT_LENGTH = 6;
    private static final int PICTURE_OPTION_LENGTH = 6;
    private static final int NOTE_STRUCTURE_LENGTH = 26;
    private static final int COMBOBOX_STRUCTURE_LENGTH = 44;
    private static final int END_LENGTH = 4;

    public ObjRecord(Record record) {
        super(record);
        byte[] byArray = record.getData();
        int n = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.read = true;
        this.type = ObjType.getType(n);
        if (this.type == UNKNOWN) {
            logger.warn("unknown object type code " + n);
        }
        this.objectId = IntegerHelper.getInt(byArray[6], byArray[7]);
    }

    ObjRecord(int n, ObjType objType) {
        super(Type.OBJ);
        this.objectId = n;
        this.type = objType;
    }

    public byte[] getData() {
        if (this.read) {
            return this.getRecord().getData();
        }
        if (this.type == PICTURE || this.type == CHART) {
            return this.getPictureData();
        }
        if (this.type == EXCELNOTE) {
            return this.getNoteData();
        }
        if (this.type == COMBOBOX) {
            return this.getComboBoxData();
        }
        Assert.verify(false);
        return null;
    }

    private byte[] getPictureData() {
        int n = 38;
        int n2 = 0;
        byte[] byArray = new byte[n];
        IntegerHelper.getTwoBytes(21, byArray, n2);
        IntegerHelper.getTwoBytes(18, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(this.type.value, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(this.objectId, byArray, n2 + 6);
        IntegerHelper.getTwoBytes(24593, byArray, n2 + 8);
        IntegerHelper.getTwoBytes(7, byArray, n2 += 22);
        IntegerHelper.getTwoBytes(2, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(65535, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(8, byArray, n2 += 6);
        IntegerHelper.getTwoBytes(2, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(1, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(0, byArray, n2 += 6);
        IntegerHelper.getTwoBytes(0, byArray, n2 + 2);
        n2 += 4;
        return byArray;
    }

    private byte[] getNoteData() {
        int n = 52;
        int n2 = 0;
        byte[] byArray = new byte[n];
        IntegerHelper.getTwoBytes(21, byArray, n2);
        IntegerHelper.getTwoBytes(18, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(this.type.value, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(this.objectId, byArray, n2 + 6);
        IntegerHelper.getTwoBytes(16401, byArray, n2 + 8);
        IntegerHelper.getTwoBytes(13, byArray, n2 += 22);
        IntegerHelper.getTwoBytes(22, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(0, byArray, n2 += 26);
        IntegerHelper.getTwoBytes(0, byArray, n2 + 2);
        n2 += 4;
        return byArray;
    }

    private byte[] getComboBoxData() {
        int n = 70;
        int n2 = 0;
        byte[] byArray = new byte[n];
        IntegerHelper.getTwoBytes(21, byArray, n2);
        IntegerHelper.getTwoBytes(18, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(this.type.value, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(this.objectId, byArray, n2 + 6);
        IntegerHelper.getTwoBytes(0, byArray, n2 + 8);
        IntegerHelper.getTwoBytes(12, byArray, n2 += 22);
        IntegerHelper.getTwoBytes(20, byArray, n2 + 2);
        byArray[n2 + 14] = 1;
        byArray[n2 + 16] = 4;
        byArray[n2 + 20] = 16;
        byArray[n2 + 24] = 19;
        byArray[n2 + 26] = -18;
        byArray[n2 + 27] = 31;
        byArray[n2 + 30] = 4;
        byArray[n2 + 34] = 1;
        byArray[n2 + 35] = 6;
        byArray[n2 + 38] = 2;
        byArray[n2 + 40] = 8;
        byArray[n2 + 42] = 64;
        IntegerHelper.getTwoBytes(0, byArray, n2 += 44);
        IntegerHelper.getTwoBytes(0, byArray, n2 + 2);
        n2 += 4;
        return byArray;
    }

    public Record getRecord() {
        return super.getRecord();
    }

    public ObjType getType() {
        return this.type;
    }

    public int getObjectId() {
        return this.objectId;
    }

    private static final class ObjType {
        public int value;
        public String desc;
        private static ObjType[] types = new ObjType[0];

        ObjType(int n, String string) {
            this.value = n;
            this.desc = string;
            ObjType[] objTypeArray = types;
            types = new ObjType[types.length + 1];
            System.arraycopy(objTypeArray, 0, types, 0, objTypeArray.length);
            ObjType.types[objTypeArray.length] = this;
        }

        public String toString() {
            return this.desc;
        }

        public static ObjType getType(int n) {
            ObjType objType = UNKNOWN;
            for (int i = 0; i < types.length && objType == UNKNOWN; ++i) {
                if (ObjType.types[i].value != n) continue;
                objType = types[i];
            }
            return objType;
        }
    }
}

