/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class Opt
extends EscherAtom {
    private static Logger logger = Logger.getLogger(Opt.class);
    private byte[] data;
    private int numProperties;
    private ArrayList properties;

    public Opt(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.numProperties = this.getInstance();
        this.readProperties();
    }

    private void readProperties() {
        this.properties = new ArrayList();
        int n = 0;
        byte[] byArray = this.getBytes();
        for (int i = 0; i < this.numProperties; ++i) {
            int n2 = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
            int n3 = n2 & 0x3FFF;
            int n4 = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3], byArray[n + 4], byArray[n + 5]);
            Property property = new Property(n3, (n2 & 0x4000) != 0, (n2 & 0x8000) != 0, n4);
            n += 6;
            this.properties.add(property);
        }
        for (Property property : this.properties) {
            if (!property.complex) continue;
            property.stringValue = StringHelper.getUnicodeString(byArray, property.value / 2, n);
            n += property.value;
        }
    }

    public Opt() {
        super(EscherRecordType.OPT);
        this.properties = new ArrayList();
        this.setVersion(3);
    }

    byte[] getData() {
        this.numProperties = this.properties.size();
        this.setInstance(this.numProperties);
        this.data = new byte[this.numProperties * 6];
        int n = 0;
        for (Property property : this.properties) {
            int n2 = property.id & 0x3FFF;
            if (property.blipId) {
                n2 |= 0x4000;
            }
            if (property.complex) {
                n2 |= 0x8000;
            }
            IntegerHelper.getTwoBytes(n2, this.data, n);
            IntegerHelper.getFourBytes(property.value, this.data, n + 2);
            n += 6;
        }
        for (Property property : this.properties) {
            if (!property.complex || property.stringValue == null) continue;
            byte[] byArray = new byte[this.data.length + property.stringValue.length() * 2];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            StringHelper.getUnicodeBytes(property.stringValue, byArray, this.data.length);
            this.data = byArray;
        }
        return this.setHeaderData(this.data);
    }

    void addProperty(int n, boolean bl, boolean bl2, int n2) {
        Property property = new Property(n, bl, bl2, n2);
        this.properties.add(property);
    }

    void addProperty(int n, boolean bl, boolean bl2, int n2, String string) {
        Property property = new Property(n, bl, bl2, n2, string);
        this.properties.add(property);
    }

    Property getProperty(int n) {
        boolean bl = false;
        Property property = null;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext() && !bl) {
            property = (Property)iterator.next();
            if (property.id != n) continue;
            bl = true;
        }
        return bl ? property : null;
    }

    static final class Property {
        int id;
        boolean blipId;
        boolean complex;
        int value;
        String stringValue;

        public Property(int n, boolean bl, boolean bl2, int n2) {
            this.id = n;
            this.blipId = bl;
            this.complex = bl2;
            this.value = n2;
        }

        public Property(int n, boolean bl, boolean bl2, int n2, String string) {
            this.id = n;
            this.blipId = bl;
            this.complex = bl2;
            this.value = n2;
            this.stringValue = string;
        }
    }
}

