/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class TextObjectRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(TextObjectRecord.class);
    private byte[] data;
    private int textLength;

    TextObjectRecord(String string) {
        super(Type.TXO);
        this.textLength = string.length();
    }

    public TextObjectRecord(Record record) {
        super(record);
        this.data = this.getRecord().getData();
        this.textLength = IntegerHelper.getInt(this.data[10], this.data[11]);
    }

    public TextObjectRecord(byte[] byArray) {
        super(Type.TXO);
        this.data = byArray;
    }

    public byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        this.data = new byte[18];
        int n = 0;
        n |= 2;
        n |= 0x10;
        IntegerHelper.getTwoBytes(n |= 0x200, this.data, 0);
        IntegerHelper.getTwoBytes(this.textLength, this.data, 10);
        IntegerHelper.getTwoBytes(16, this.data, 12);
        return this.data;
    }
}

