/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class Area3d
extends Operand
implements ParsedThing {
    private static Logger logger = Logger.getLogger(Area3d.class);
    private int sheet;
    private int columnFirst;
    private int rowFirst;
    private int columnLast;
    private int rowLast;
    private boolean columnFirstRelative;
    private boolean rowFirstRelative;
    private boolean columnLastRelative;
    private boolean rowLastRelative;
    private ExternalSheet workbook;

    Area3d(ExternalSheet externalSheet) {
        this.workbook = externalSheet;
    }

    Area3d(String string, ExternalSheet externalSheet) throws FormulaException {
        this.workbook = externalSheet;
        int n = string.lastIndexOf(":");
        Assert.verify(n != -1);
        String string2 = string.substring(n + 1);
        int n2 = string.indexOf(33);
        String string3 = string.substring(n2 + 1, n);
        this.columnFirst = CellReferenceHelper.getColumn(string3);
        this.rowFirst = CellReferenceHelper.getRow(string3);
        String string4 = string.substring(0, n2);
        if (string4.charAt(0) == '\'' && string4.charAt(string4.length() - 1) == '\'') {
            string4 = string4.substring(1, string4.length() - 1);
        }
        this.sheet = externalSheet.getExternalSheetIndex(string4);
        if (this.sheet < 0) {
            throw new FormulaException(FormulaException.SHEET_REF_NOT_FOUND, string4);
        }
        this.columnLast = CellReferenceHelper.getColumn(string2);
        this.rowLast = CellReferenceHelper.getRow(string2);
        this.columnFirstRelative = true;
        this.rowFirstRelative = true;
        this.columnLastRelative = true;
        this.rowLastRelative = true;
    }

    int getFirstColumn() {
        return this.columnFirst;
    }

    int getFirstRow() {
        return this.rowFirst;
    }

    int getLastColumn() {
        return this.columnLast;
    }

    int getLastRow() {
        return this.rowLast;
    }

    public int read(byte[] byArray, int n) {
        this.sheet = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.rowFirst = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        this.rowLast = IntegerHelper.getInt(byArray[n + 4], byArray[n + 5]);
        int n2 = IntegerHelper.getInt(byArray[n + 6], byArray[n + 7]);
        this.columnFirst = n2 & 0xFF;
        this.columnFirstRelative = (n2 & 0x4000) != 0;
        this.rowFirstRelative = (n2 & 0x8000) != 0;
        n2 = IntegerHelper.getInt(byArray[n + 8], byArray[n + 9]);
        this.columnLast = n2 & 0xFF;
        this.columnLastRelative = (n2 & 0x4000) != 0;
        this.rowLastRelative = (n2 & 0x8000) != 0;
        return 10;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.sheet, this.columnFirst, this.rowFirst, this.workbook, stringBuffer);
        stringBuffer.append(':');
        CellReferenceHelper.getCellReference(this.columnLast, this.rowLast, stringBuffer);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[11];
        byArray[0] = Token.AREA3D.getCode();
        IntegerHelper.getTwoBytes(this.sheet, byArray, 1);
        IntegerHelper.getTwoBytes(this.rowFirst, byArray, 3);
        IntegerHelper.getTwoBytes(this.rowLast, byArray, 5);
        int n = this.columnFirst;
        if (this.rowFirstRelative) {
            n |= 0x8000;
        }
        if (this.columnFirstRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 7);
        n = this.columnLast;
        if (this.rowLastRelative) {
            n |= 0x8000;
        }
        if (this.columnLastRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 9);
        return byArray;
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        if (this.columnFirstRelative) {
            this.columnFirst += n;
        }
        if (this.columnLastRelative) {
            this.columnLast += n;
        }
        if (this.rowFirstRelative) {
            this.rowFirst += n2;
        }
        if (this.rowLastRelative) {
            this.rowLast += n2;
        }
    }

    public void columnInserted(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.columnFirst >= n2) {
            ++this.columnFirst;
        }
        if (this.columnLast >= n2) {
            ++this.columnLast;
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (n2 < this.columnFirst) {
            --this.columnFirst;
        }
        if (n2 <= this.columnLast) {
            --this.columnLast;
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.rowLast == 65535) {
            return;
        }
        if (n2 <= this.rowFirst) {
            ++this.rowFirst;
        }
        if (n2 <= this.rowLast) {
            ++this.rowLast;
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.rowLast == 65535) {
            return;
        }
        if (n2 < this.rowFirst) {
            --this.rowFirst;
        }
        if (n2 <= this.rowLast) {
            --this.rowLast;
        }
    }

    protected void setRangeData(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.sheet = n;
        this.columnFirst = n2;
        this.columnLast = n3;
        this.rowFirst = n4;
        this.rowLast = n5;
        this.columnFirstRelative = bl;
        this.columnLastRelative = bl2;
        this.rowFirstRelative = bl3;
        this.rowLastRelative = bl4;
    }

    void handleImportedCellReferences() {
        this.setInvalid();
    }
}

