/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import jxl.Cell;
import jxl.WorkbookSettings;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Parser;
import jxl.biff.formula.StringFormulaParser;
import jxl.biff.formula.TokenFormulaParser;

public class FormulaParser {
    private static final Logger logger = Logger.getLogger(FormulaParser.class);
    private Parser parser;

    public FormulaParser(byte[] byArray, Cell cell, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) throws FormulaException {
        if (externalSheet.getWorkbookBof() != null && !externalSheet.getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.BIFF8_SUPPORTED);
        }
        Assert.verify(workbookMethods != null);
        this.parser = new TokenFormulaParser(byArray, cell, externalSheet, workbookMethods, workbookSettings);
    }

    public FormulaParser(String string, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        this.parser = new StringFormulaParser(string, externalSheet, workbookMethods, workbookSettings);
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        this.parser.adjustRelativeCellReferences(n, n2);
    }

    public void parse() throws FormulaException {
        this.parser.parse();
    }

    public String getFormula() throws FormulaException {
        return this.parser.getFormula();
    }

    public byte[] getBytes() {
        return this.parser.getBytes();
    }

    public void columnInserted(int n, int n2, boolean bl) {
        this.parser.columnInserted(n, n2, bl);
    }

    public void columnRemoved(int n, int n2, boolean bl) {
        this.parser.columnRemoved(n, n2, bl);
    }

    public void rowInserted(int n, int n2, boolean bl) {
        this.parser.rowInserted(n, n2, bl);
    }

    public void rowRemoved(int n, int n2, boolean bl) {
        this.parser.rowRemoved(n, n2, bl);
    }

    public boolean handleImportedCellReferences() {
        return this.parser.handleImportedCellReferences();
    }
}

