/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.NumberValue;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class IntegerValue
extends NumberValue
implements ParsedThing {
    private static Logger logger = Logger.getLogger(IntegerValue.class);
    private double value;
    private boolean outOfRange;

    public IntegerValue() {
        this.outOfRange = false;
    }

    public IntegerValue(String string) {
        try {
            this.value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn(numberFormatException, numberFormatException);
            this.value = 0.0;
        }
        short s = (short)this.value;
        this.outOfRange = this.value != (double)s;
    }

    public int read(byte[] byArray, int n) {
        this.value = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        return 2;
    }

    byte[] getBytes() {
        byte[] byArray = new byte[3];
        byArray[0] = Token.INTEGER.getCode();
        IntegerHelper.getTwoBytes((int)this.value, byArray, 1);
        return byArray;
    }

    public double getValue() {
        return this.value;
    }

    boolean isOutOfRange() {
        return this.outOfRange;
    }

    void handleImportedCellReferences() {
    }
}

