/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.Cell;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class SharedFormulaArea
extends Operand
implements ParsedThing {
    private int columnFirst;
    private int rowFirst;
    private int columnLast;
    private int rowLast;
    private boolean columnFirstRelative;
    private boolean rowFirstRelative;
    private boolean columnLastRelative;
    private boolean rowLastRelative;
    private Cell relativeTo;

    public SharedFormulaArea(Cell cell) {
        this.relativeTo = cell;
    }

    int getFirstColumn() {
        return this.columnFirst;
    }

    int getFirstRow() {
        return this.rowFirst;
    }

    int getLastColumn() {
        return this.columnLast;
    }

    int getLastRow() {
        return this.rowLast;
    }

    public int read(byte[] byArray, int n) {
        this.rowFirst = IntegerHelper.getShort(byArray[n], byArray[n + 1]);
        this.rowLast = IntegerHelper.getShort(byArray[n + 2], byArray[n + 3]);
        int n2 = IntegerHelper.getInt(byArray[n + 4], byArray[n + 5]);
        this.columnFirst = n2 & 0xFF;
        this.columnFirstRelative = (n2 & 0x4000) != 0;
        boolean bl = this.rowFirstRelative = (n2 & 0x8000) != 0;
        if (this.columnFirstRelative) {
            this.columnFirst = this.relativeTo.getColumn() + this.columnFirst;
        }
        if (this.rowFirstRelative) {
            this.rowFirst = this.relativeTo.getRow() + this.rowFirst;
        }
        n2 = IntegerHelper.getInt(byArray[n + 6], byArray[n + 7]);
        this.columnLast = n2 & 0xFF;
        this.columnLastRelative = (n2 & 0x4000) != 0;
        boolean bl2 = this.rowLastRelative = (n2 & 0x8000) != 0;
        if (this.columnLastRelative) {
            this.columnLast = this.relativeTo.getColumn() + this.columnLast;
        }
        if (this.rowLastRelative) {
            this.rowLast = this.relativeTo.getRow() + this.rowLast;
        }
        return 8;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.columnFirst, this.rowFirst, stringBuffer);
        stringBuffer.append(':');
        CellReferenceHelper.getCellReference(this.columnLast, this.rowLast, stringBuffer);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[9];
        byArray[0] = Token.AREA.getCode();
        IntegerHelper.getTwoBytes(this.rowFirst, byArray, 1);
        IntegerHelper.getTwoBytes(this.rowLast, byArray, 3);
        IntegerHelper.getTwoBytes(this.columnFirst, byArray, 5);
        IntegerHelper.getTwoBytes(this.columnLast, byArray, 7);
        return byArray;
    }

    void handleImportedCellReferences() {
    }
}

