/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.StringHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class StringValue
extends Operand
implements ParsedThing {
    private static final Logger logger = Logger.getLogger(StringValue.class);
    private String value;
    private WorkbookSettings settings;

    public StringValue(WorkbookSettings workbookSettings) {
        this.settings = workbookSettings;
    }

    public StringValue(String string) {
        this.value = string;
    }

    public int read(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = 2;
        if ((byArray[n + 1] & 1) == 0) {
            this.value = StringHelper.getString(byArray, n2, n + 2, this.settings);
            n3 += n2;
        } else {
            this.value = StringHelper.getUnicodeString(byArray, n2, n + 2);
            n3 += n2 * 2;
        }
        return n3;
    }

    byte[] getBytes() {
        byte[] byArray = new byte[this.value.length() * 2 + 3];
        byArray[0] = Token.STRING.getCode();
        byArray[1] = (byte)this.value.length();
        byArray[2] = 1;
        StringHelper.getUnicodeBytes(this.value, byArray, 3);
        return byArray;
    }

    public void getString(StringBuffer stringBuffer) {
        stringBuffer.append("\"");
        stringBuffer.append(this.value);
        stringBuffer.append("\"");
    }

    void handleImportedCellReferences() {
    }
}

