/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import common.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jxl.CellType;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.biff.WritableRecordData;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.read.biff.BiffException;
import jxl.write.Blank;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.HyperlinkRecord;

public class ReadWrite {
    private static Logger logger = Logger.getLogger(ReadWrite.class);
    private File inputWorkbook;
    private File outputWorkbook;

    public ReadWrite(String string, String string2) {
        this.inputWorkbook = new File(string);
        this.outputWorkbook = new File(string2);
        logger.setSuppressWarnings(Boolean.getBoolean("jxl.nowarnings"));
        logger.info("Input file:  " + string);
        logger.info("Output file:  " + string2);
    }

    public void readWrite() throws IOException, BiffException, WriteException {
        logger.info("Reading...");
        Workbook workbook = Workbook.getWorkbook(this.inputWorkbook);
        logger.info("Copying...");
        WritableWorkbook writableWorkbook = Workbook.createWorkbook(this.outputWorkbook, workbook);
        if (this.inputWorkbook.getName().equals("jxlrwtest.xls")) {
            this.modify(writableWorkbook);
        }
        writableWorkbook.write();
        writableWorkbook.close();
        logger.info("Done");
    }

    private void modify(WritableWorkbook writableWorkbook) throws WriteException {
        Object object;
        Object object2;
        CellValue cellValue;
        WritableRecordData writableRecordData;
        WritableRecordData writableRecordData2;
        logger.info("Modifying...");
        WritableSheet writableSheet = writableWorkbook.getSheet("modified");
        WritableCell writableCell = null;
        WritableCellFormat writableCellFormat = null;
        Label label = null;
        WritableCellFeatures writableCellFeatures = null;
        writableCell = writableSheet.getWritableCell(1, 3);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 4);
        WritableFont writableFont2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.SINGLE);
        writableCellFormat = new WritableCellFormat(writableFont2);
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 5);
        WritableFont writableFont3 = new WritableFont(WritableFont.ARIAL, 10);
        writableCellFormat = new WritableCellFormat(writableFont3);
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 6);
        if (writableCell.getType() == CellType.LABEL) {
            writableRecordData2 = (Label)writableCell;
            writableRecordData2.setString(writableRecordData2.getString() + " - mod");
        }
        writableCell = writableSheet.getWritableCell(1, 9);
        writableRecordData2 = new NumberFormat("#.0000000");
        writableCellFormat = new WritableCellFormat((DisplayFormat)((Object)writableRecordData2));
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 10);
        NumberFormat numberFormat = new NumberFormat("0.####E0");
        writableCellFormat = new WritableCellFormat(numberFormat);
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 11);
        writableCell.setCellFormat(WritableWorkbook.NORMAL_STYLE);
        writableCell = writableSheet.getWritableCell(1, 12);
        if (writableCell.getType() == CellType.NUMBER) {
            writableRecordData = (Number)writableCell;
            writableRecordData.setValue(42.0);
        }
        if ((writableCell = writableSheet.getWritableCell(1, 13)).getType() == CellType.NUMBER) {
            writableRecordData = (Number)writableCell;
            writableRecordData.setValue(writableRecordData.getValue() + 0.1);
        }
        writableCell = writableSheet.getWritableCell(1, 16);
        writableRecordData = new DateFormat("dd MMM yyyy HH:mm:ss");
        writableCellFormat = new WritableCellFormat((DisplayFormat)((Object)writableRecordData));
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 17);
        writableCellFormat = new WritableCellFormat(DateFormats.FORMAT9);
        writableCell.setCellFormat(writableCellFormat);
        writableCell = writableSheet.getWritableCell(1, 18);
        if (writableCell.getType() == CellType.DATE) {
            cellValue = (DateTime)writableCell;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1998, 1, 18, 11, 23, 28);
            object2 = calendar.getTime();
            ((DateTime)cellValue).setDate((Date)object2);
        }
        if ((writableCell = writableSheet.getWritableCell(1, 22)).getType() == CellType.NUMBER) {
            cellValue = (Number)writableCell;
            ((Number)cellValue).setValue(6.8);
        }
        if ((writableCell = writableSheet.getWritableCell(1, 29)).getType() == CellType.LABEL) {
            label = (Label)writableCell;
            label.setString("Modified string contents");
        }
        writableSheet.insertRow(34);
        writableSheet.removeRow(38);
        writableSheet.insertColumn(9);
        writableSheet.removeColumn(11);
        writableSheet.removeRow(43);
        writableSheet.insertRow(43);
        cellValue = writableSheet.getWritableHyperlinks();
        for (int i = 0; i < ((CellValue)cellValue).length; ++i) {
            object2 = cellValue[i];
            if (((HyperlinkRecord)object2).getColumn() == 1 && ((HyperlinkRecord)object2).getRow() == 39) {
                try {
                    ((WritableHyperlink)object2).setURL(new URL("http://www.andykhan.com/jexcelapi/index.html"));
                }
                catch (MalformedURLException malformedURLException) {
                    logger.warn(malformedURLException.toString());
                }
                continue;
            }
            if (((HyperlinkRecord)object2).getColumn() == 1 && ((HyperlinkRecord)object2).getRow() == 40) {
                ((WritableHyperlink)object2).setFile(new File("../jexcelapi/docs/overview-summary.html"));
                continue;
            }
            if (((HyperlinkRecord)object2).getColumn() == 1 && ((HyperlinkRecord)object2).getRow() == 41) {
                ((WritableHyperlink)object2).setFile(new File("d:/home/jexcelapi/docs/jxl/package-summary.html"));
                continue;
            }
            if (((HyperlinkRecord)object2).getColumn() != 1 || ((HyperlinkRecord)object2).getRow() != 44) continue;
            writableSheet.removeHyperlink((WritableHyperlink)object2);
        }
        WritableCell writableCell2 = writableSheet.getWritableCell(5, 30);
        object2 = new WritableCellFormat(writableCell2.getCellFormat());
        ((WritableCellFormat)object2).setBackground(Colour.RED);
        writableCell2.setCellFormat((CellFormat)object2);
        label = new Label(0, 49, "Modified merged cells");
        writableSheet.addCell(label);
        Number number = (Number)writableSheet.getWritableCell(0, 70);
        number.setValue(9.0);
        number = (Number)writableSheet.getWritableCell(0, 71);
        number.setValue(10.0);
        number = (Number)writableSheet.getWritableCell(0, 73);
        number.setValue(4.0);
        Formula formula = new Formula(1, 80, "ROUND(COS(original!B10),2)");
        writableSheet.addCell(formula);
        formula = new Formula(1, 83, "value1+value2");
        writableSheet.addCell(formula);
        formula = new Formula(1, 84, "AVERAGE(value1,value1*4,value2)");
        writableSheet.addCell(formula);
        Label label2 = new Label(0, 88, "Some copied cells", (CellFormat)writableCellFormat);
        writableSheet.addCell(label2);
        label2 = new Label(0, 89, "Number from B9");
        writableSheet.addCell(label2);
        WritableCell writableCell3 = writableSheet.getWritableCell(1, 9).copyTo(1, 89);
        writableSheet.addCell(writableCell3);
        label2 = new Label(0, 90, "Label from B4 (modified format)");
        writableSheet.addCell(label2);
        writableCell3 = writableSheet.getWritableCell(1, 3).copyTo(1, 90);
        writableSheet.addCell(writableCell3);
        label2 = new Label(0, 91, "Date from B17");
        writableSheet.addCell(label2);
        writableCell3 = writableSheet.getWritableCell(1, 16).copyTo(1, 91);
        writableSheet.addCell(writableCell3);
        label2 = new Label(0, 92, "Boolean from E16");
        writableSheet.addCell(label2);
        writableCell3 = writableSheet.getWritableCell(4, 15).copyTo(1, 92);
        writableSheet.addCell(writableCell3);
        label2 = new Label(0, 93, "URL from B40");
        writableSheet.addCell(label2);
        writableCell3 = writableSheet.getWritableCell(1, 39).copyTo(1, 93);
        writableSheet.addCell(writableCell3);
        for (int i = 0; i < 6; ++i) {
            object = new Number(1, 94 + i, (double)(i + 1) + (double)i / 8.0);
            writableSheet.addCell((WritableCell)object);
        }
        label2 = new Label(0, 100, "Formula from B27");
        writableSheet.addCell(label2);
        writableCell3 = writableSheet.getWritableCell(1, 26).copyTo(1, 100);
        writableSheet.addCell(writableCell3);
        label2 = new Label(0, 101, "A brand new formula");
        writableSheet.addCell(label2);
        Formula formula2 = new Formula(1, 101, "SUM(B94:B96)");
        writableSheet.addCell(formula2);
        label2 = new Label(0, 102, "A copy of it");
        writableSheet.addCell(label2);
        writableCell3 = writableSheet.getWritableCell(1, 101).copyTo(1, 102);
        writableSheet.addCell(writableCell3);
        object = writableSheet.getImage(1);
        writableSheet.removeImage((WritableImage)object);
        object = new WritableImage(1.0, 116.0, 2.0, 9.0, new File("resources/littlemoretonhall.png"));
        writableSheet.addImage((WritableImage)object);
        label2 = new Label(0, 151, "Added drop down validation");
        writableSheet.addCell(label2);
        Blank blank = new Blank(1, 151);
        writableCellFeatures = new WritableCellFeatures();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("The Fellowship of the Ring");
        arrayList.add("The Two Towers");
        arrayList.add("The Return of the King");
        writableCellFeatures.setDataValidationList(arrayList);
        blank.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(blank);
        label2 = new Label(0, 152, "Added number validation 2.718 < x < 3.142");
        writableSheet.addCell(label2);
        blank = new Blank(1, 152);
        writableCellFeatures = new WritableCellFeatures();
        writableCellFeatures.setNumberValidation(2.718, 3.142, WritableCellFeatures.BETWEEN);
        blank.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(blank);
        writableCell = writableSheet.getWritableCell(0, 156);
        label = (Label)writableCell;
        label.setString("Label text modified");
        writableCell = writableSheet.getWritableCell(0, 157);
        writableCellFeatures = writableCell.getWritableCellFeatures();
        writableCellFeatures.setComment("modified comment text");
        writableCell = writableSheet.getWritableCell(0, 158);
        writableCellFeatures = writableCell.getWritableCellFeatures();
        writableCellFeatures.removeComment();
    }
}

