/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.BooleanCell;
import jxl.BooleanFormulaCell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class BooleanFormulaRecord
extends CellValue
implements BooleanCell,
FormulaData,
BooleanFormulaCell {
    private boolean value;
    private ExternalSheet externalSheet;
    private WorkbookMethods nameTable;
    private String formulaString;
    private byte[] data;

    public BooleanFormulaRecord(Record record, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl) {
        super(record, formattingRecords, sheetImpl);
        this.externalSheet = externalSheet;
        this.nameTable = workbookMethods;
        this.value = false;
        this.data = this.getRecord().getData();
        Assert.verify(this.data[6] != 2);
        this.value = this.data[8] == 1;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public CellType getType() {
        return CellType.BOOLEAN_FORMULA;
    }

    public byte[] getFormulaData() throws FormulaException {
        if (!this.getSheet().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.BIFF8_SUPPORTED);
        }
        byte[] byArray = new byte[this.data.length - 6];
        System.arraycopy(this.data, 6, byArray, 0, this.data.length - 6);
        return byArray;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] byArray = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, byArray, 0, byArray.length);
            FormulaParser formulaParser = new FormulaParser(byArray, this, this.externalSheet, this.nameTable, this.getSheet().getWorkbook().getSettings());
            formulaParser.parse();
            this.formulaString = formulaParser.getFormula();
        }
        return this.formulaString;
    }
}

