/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.io.UnsupportedEncodingException;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

class BoundsheetRecord
extends RecordData {
    private int offset;
    private byte typeFlag;
    private byte visibilityFlag;
    private int length;
    private String name;
    public static Biff7 biff7 = new Biff7();

    public BoundsheetRecord(Record record) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.offset = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.typeFlag = byArray[5];
        this.visibilityFlag = byArray[4];
        this.length = byArray[6];
        if (byArray[7] == 0) {
            byte[] byArray2 = new byte[this.length];
            System.arraycopy(byArray, 8, byArray2, 0, this.length);
            this.name = new String(byArray2);
        } else {
            byte[] byArray3 = new byte[this.length * 2];
            System.arraycopy(byArray, 8, byArray3, 0, this.length * 2);
            try {
                this.name = new String(byArray3, "UnicodeLittle");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.name = "Error";
            }
        }
    }

    public BoundsheetRecord(Record record, Biff7 biff7) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.offset = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.typeFlag = byArray[5];
        this.visibilityFlag = byArray[4];
        this.length = byArray[6];
        byte[] byArray2 = new byte[this.length];
        System.arraycopy(byArray, 7, byArray2, 0, this.length);
        this.name = new String(byArray2);
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.visibilityFlag != 0;
    }

    public boolean isSheet() {
        return this.typeFlag == 0;
    }

    public boolean isChart() {
        return this.typeFlag == 2;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

