/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import jxl.CellFeatures;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

class DateRecord
implements DateCell,
CellFeaturesAccessor {
    private static Logger logger = Logger.getLogger(DateRecord.class);
    private Date date;
    private int row;
    private int column;
    private boolean time;
    private DateFormat format;
    private CellFormat cellFormat;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private SheetImpl sheet;
    private CellFeatures features;
    private boolean initialized;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final int nonLeapDay = 61;
    private static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private static final int utcOffsetDays = 25569;
    private static final int utcOffsetDays1904 = 24107;
    private static final long secondsInADay = 86400L;
    private static final long msInASecond = 1000L;
    private static final long msInADay = 86400000L;

    public DateRecord(NumberCell numberCell, int n, FormattingRecords formattingRecords, boolean bl, SheetImpl sheetImpl) {
        this.row = numberCell.getRow();
        this.column = numberCell.getColumn();
        this.xfIndex = n;
        this.formattingRecords = formattingRecords;
        this.sheet = sheetImpl;
        this.initialized = false;
        this.format = this.formattingRecords.getDateFormat(this.xfIndex);
        double d = numberCell.getValue();
        if (Math.abs(d) < 1.0) {
            if (this.format == null) {
                this.format = timeFormat;
            }
            this.time = true;
        } else {
            if (this.format == null) {
                this.format = dateFormat;
            }
            this.time = false;
        }
        if (!bl && !this.time && d < 61.0) {
            d += 1.0;
        }
        this.format.setTimeZone(gmtZone);
        int n2 = bl ? 24107 : 25569;
        double d2 = d - (double)n2;
        long l = Math.round(d2 * 86400.0) * 1000L;
        this.date = new Date(l);
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public Date getDate() {
        return this.date;
    }

    public String getContents() {
        return this.format.format(this.date);
    }

    public CellType getType() {
        return CellType.DATE;
    }

    public boolean isTime() {
        return this.time;
    }

    public DateFormat getDateFormat() {
        Assert.verify(this.format != null);
        return this.format;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }

    public boolean isHidden() {
        ColumnInfoRecord columnInfoRecord = this.sheet.getColumnInfo(this.column);
        if (columnInfoRecord != null && columnInfoRecord.getWidth() == 0) {
            return true;
        }
        RowRecord rowRecord = this.sheet.getRowInfo(this.row);
        return rowRecord != null && (rowRecord.getRowHeight() == 0 || rowRecord.isCollapsed());
    }

    protected final SheetImpl getSheet() {
        return this.sheet;
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(CellFeatures cellFeatures) {
        this.features = cellFeatures;
    }
}

