/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class HeaderRecord
extends RecordData {
    private static Logger logger = Logger.getLogger(HeaderRecord.class);
    private String header;
    public static Biff7 biff7 = new Biff7();

    HeaderRecord(Record record, WorkbookSettings workbookSettings) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        if (byArray.length == 0) {
            return;
        }
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        boolean bl = byArray[2] == 1;
        this.header = bl ? StringHelper.getUnicodeString(byArray, n, 3) : StringHelper.getString(byArray, n, 3, workbookSettings);
    }

    HeaderRecord(Record record, WorkbookSettings workbookSettings, Biff7 biff7) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        if (byArray.length == 0) {
            return;
        }
        byte by = byArray[0];
        this.header = StringHelper.getString(byArray, by, 1, workbookSettings);
    }

    String getHeader() {
        return this.header;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

