/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

class HorizontalPageBreaksRecord
extends RecordData {
    private final Logger logger = Logger.getLogger(HorizontalPageBreaksRecord.class);
    private int[] rowBreaks;
    public static Biff7 biff7 = new Biff7();

    public HorizontalPageBreaksRecord(Record record) {
        super(record);
        byte[] byArray = record.getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        int n2 = 2;
        this.rowBreaks = new int[n];
        for (int i = 0; i < n; ++i) {
            this.rowBreaks[i] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            n2 += 6;
        }
    }

    public HorizontalPageBreaksRecord(Record record, Biff7 biff7) {
        super(record);
        byte[] byArray = record.getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        int n2 = 2;
        this.rowBreaks = new int[n];
        for (int i = 0; i < n; ++i) {
            this.rowBreaks[i] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            n2 += 2;
        }
    }

    public int[] getRowBreaks() {
        return this.rowBreaks;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

