/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

class MulBlankCell
implements Cell,
CellFeaturesAccessor {
    private static Logger logger = Logger.getLogger(MulBlankCell.class);
    private int row;
    private int column;
    private CellFormat cellFormat;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private SheetImpl sheet;
    private CellFeatures features;

    public MulBlankCell(int n, int n2, int n3, FormattingRecords formattingRecords, SheetImpl sheetImpl) {
        this.row = n;
        this.column = n2;
        this.xfIndex = n3;
        this.formattingRecords = formattingRecords;
        this.sheet = sheetImpl;
        this.initialized = false;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public String getContents() {
        return "";
    }

    public CellType getType() {
        return CellType.EMPTY;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }

    public boolean isHidden() {
        ColumnInfoRecord columnInfoRecord = this.sheet.getColumnInfo(this.column);
        if (columnInfoRecord != null && columnInfoRecord.getWidth() == 0) {
            return true;
        }
        RowRecord rowRecord = this.sheet.getRowInfo(this.row);
        return rowRecord != null && (rowRecord.getRowHeight() == 0 || rowRecord.isCollapsed());
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(CellFeatures cellFeatures) {
        if (this.features != null) {
            logger.warn("current cell features not null - overwriting");
        }
        this.features = cellFeatures;
    }
}

