/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.CellType;
import jxl.ErrorCell;
import jxl.ErrorFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaErrorCode;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.File;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

public class SharedErrorFormulaRecord
extends BaseSharedFormulaRecord
implements ErrorCell,
FormulaData,
ErrorFormulaCell {
    private static Logger logger = Logger.getLogger(SharedErrorFormulaRecord.class);
    private int errorCode;
    private byte[] data;
    private FormulaErrorCode error;

    public SharedErrorFormulaRecord(Record record, File file, int n, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl) {
        super(record, formattingRecords, externalSheet, workbookMethods, sheetImpl, file.getPos());
        this.errorCode = n;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getContents() {
        if (this.error == null) {
            this.error = FormulaErrorCode.getErrorCode(this.errorCode);
        }
        return this.error != FormulaErrorCode.UNKNOWN ? this.error.getDescription() : "ERROR " + this.errorCode;
    }

    public CellType getType() {
        return CellType.FORMULA_ERROR;
    }

    public byte[] getFormulaData() throws FormulaException {
        if (!this.getSheet().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.BIFF8_SUPPORTED);
        }
        FormulaParser formulaParser = new FormulaParser(this.getTokens(), this, this.getExternalSheet(), this.getNameTable(), this.getSheet().getWorkbook().getSettings());
        formulaParser.parse();
        byte[] byArray = formulaParser.getBytes();
        byte[] byArray2 = new byte[byArray.length + 22];
        IntegerHelper.getTwoBytes(this.getRow(), byArray2, 0);
        IntegerHelper.getTwoBytes(this.getColumn(), byArray2, 2);
        IntegerHelper.getTwoBytes(this.getXFIndex(), byArray2, 4);
        byArray2[6] = 2;
        byArray2[8] = (byte)this.errorCode;
        byArray2[12] = -1;
        byArray2[13] = -1;
        System.arraycopy(byArray, 0, byArray2, 22, byArray.length);
        IntegerHelper.getTwoBytes(byArray.length, byArray2, 20);
        byte[] byArray3 = new byte[byArray2.length - 6];
        System.arraycopy(byArray2, 6, byArray3, 0, byArray2.length - 6);
        return byArray3;
    }
}

