/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.text.NumberFormat;
import java.util.ArrayList;
import jxl.Cell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SharedDateFormulaRecord;
import jxl.read.biff.SharedNumberFormulaRecord;
import jxl.read.biff.SheetImpl;

class SharedFormulaRecord {
    private static Logger logger = Logger.getLogger(SharedFormulaRecord.class);
    private int firstRow;
    private int lastRow;
    private int firstCol;
    private int lastCol;
    private BaseSharedFormulaRecord templateFormula;
    private ArrayList formulas;
    private byte[] tokens;
    private ExternalSheet externalSheet;
    private SheetImpl sheet;

    public SharedFormulaRecord(Record record, BaseSharedFormulaRecord baseSharedFormulaRecord, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl) {
        this.sheet = sheetImpl;
        byte[] byArray = record.getData();
        this.firstRow = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.lastRow = IntegerHelper.getInt(byArray[2], byArray[3]);
        this.firstCol = byArray[4] & 0xFF;
        this.lastCol = byArray[5] & 0xFF;
        this.formulas = new ArrayList();
        this.templateFormula = baseSharedFormulaRecord;
        this.tokens = new byte[byArray.length - 10];
        System.arraycopy(byArray, 10, this.tokens, 0, this.tokens.length);
    }

    public boolean add(BaseSharedFormulaRecord baseSharedFormulaRecord) {
        int n;
        boolean bl = false;
        int n2 = baseSharedFormulaRecord.getRow();
        if (n2 >= this.firstRow && n2 <= this.lastRow && (n = baseSharedFormulaRecord.getColumn()) >= this.firstCol && n <= this.lastCol) {
            this.formulas.add(baseSharedFormulaRecord);
            bl = true;
        }
        return bl;
    }

    Cell[] getFormulas(FormattingRecords formattingRecords, boolean bl) {
        BaseSharedFormulaRecord baseSharedFormulaRecord;
        Cell[] cellArray = new Cell[this.formulas.size() + 1];
        if (this.templateFormula == null) {
            logger.warn("Shared formula template formula is null");
            return new Cell[0];
        }
        this.templateFormula.setTokens(this.tokens);
        NumberFormat numberFormat = null;
        if (this.templateFormula.getType() == CellType.NUMBER_FORMULA) {
            baseSharedFormulaRecord = (SharedNumberFormulaRecord)this.templateFormula;
            numberFormat = ((SharedNumberFormulaRecord)baseSharedFormulaRecord).getNumberFormat();
            if (formattingRecords.isDate(this.templateFormula.getXFIndex())) {
                this.templateFormula = new SharedDateFormulaRecord((SharedNumberFormulaRecord)baseSharedFormulaRecord, formattingRecords, bl, this.sheet, baseSharedFormulaRecord.getFilePos());
                this.templateFormula.setTokens(baseSharedFormulaRecord.getTokens());
            }
        }
        cellArray[0] = this.templateFormula;
        baseSharedFormulaRecord = null;
        for (int i = 0; i < this.formulas.size(); ++i) {
            baseSharedFormulaRecord = (BaseSharedFormulaRecord)this.formulas.get(i);
            if (baseSharedFormulaRecord.getType() == CellType.NUMBER_FORMULA) {
                SharedNumberFormulaRecord sharedNumberFormulaRecord = (SharedNumberFormulaRecord)baseSharedFormulaRecord;
                if (formattingRecords.isDate(baseSharedFormulaRecord.getXFIndex())) {
                    baseSharedFormulaRecord = new SharedDateFormulaRecord(sharedNumberFormulaRecord, formattingRecords, bl, this.sheet, sharedNumberFormulaRecord.getFilePos());
                }
            }
            baseSharedFormulaRecord.setTokens(this.tokens);
            cellArray[i + 1] = baseSharedFormulaRecord;
        }
        return cellArray;
    }

    BaseSharedFormulaRecord getTemplateFormula() {
        return this.templateFormula;
    }
}

