/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

class VerticalPageBreaksRecord
extends RecordData {
    private final Logger logger = Logger.getLogger(VerticalPageBreaksRecord.class);
    private int[] columnBreaks;
    public static Biff7 biff7 = new Biff7();

    public VerticalPageBreaksRecord(Record record) {
        super(record);
        byte[] byArray = record.getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        int n2 = 2;
        this.columnBreaks = new int[n];
        for (int i = 0; i < n; ++i) {
            this.columnBreaks[i] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            n2 += 6;
        }
    }

    public VerticalPageBreaksRecord(Record record, Biff7 biff7) {
        super(record);
        byte[] byArray = record.getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        int n2 = 2;
        this.columnBreaks = new int[n];
        for (int i = 0; i < n; ++i) {
            this.columnBreaks[i] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            n2 += 2;
        }
    }

    public int[] getColumnBreaks() {
        return this.columnBreaks;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

