/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;

class ColumnInfoRecord
extends WritableRecordData {
    private byte[] data;
    private int column;
    private XFRecord style;
    private int xfIndex;
    private int width;
    private boolean hidden;

    public ColumnInfoRecord(int n, int n2, XFRecord xFRecord) {
        super(Type.COLINFO);
        this.column = n;
        this.width = n2;
        this.style = xFRecord;
        this.xfIndex = this.style.getXFIndex();
        this.hidden = false;
    }

    public ColumnInfoRecord(ColumnInfoRecord columnInfoRecord) {
        super(Type.COLINFO);
        this.column = columnInfoRecord.column;
        this.width = columnInfoRecord.width;
        this.style = columnInfoRecord.style;
        this.xfIndex = columnInfoRecord.xfIndex;
        this.hidden = columnInfoRecord.hidden;
    }

    public ColumnInfoRecord(jxl.read.biff.ColumnInfoRecord columnInfoRecord, int n, FormattingRecords formattingRecords) {
        super(Type.COLINFO);
        this.column = n;
        this.width = columnInfoRecord.getWidth();
        this.xfIndex = columnInfoRecord.getXFIndex();
        this.style = formattingRecords.getXFRecord(this.xfIndex);
    }

    public ColumnInfoRecord(jxl.read.biff.ColumnInfoRecord columnInfoRecord, int n) {
        super(Type.COLINFO);
        this.column = n;
        this.width = columnInfoRecord.getWidth();
        this.xfIndex = columnInfoRecord.getXFIndex();
    }

    public int getColumn() {
        return this.column;
    }

    public void incrementColumn() {
        ++this.column;
    }

    public void decrementColumn() {
        --this.column;
    }

    int getWidth() {
        return this.width;
    }

    void setWidth(int n) {
        this.width = n;
    }

    public byte[] getData() {
        this.data = new byte[12];
        IntegerHelper.getTwoBytes(this.column, this.data, 0);
        IntegerHelper.getTwoBytes(this.column, this.data, 2);
        IntegerHelper.getTwoBytes(this.width, this.data, 4);
        IntegerHelper.getTwoBytes(this.xfIndex, this.data, 6);
        int n = 6;
        if (this.hidden) {
            n |= 1;
        }
        IntegerHelper.getTwoBytes(n, this.data, 8);
        return this.data;
    }

    public XFRecord getCellFormat() {
        return this.style;
    }

    public void setCellFormat(XFRecord xFRecord) {
        this.style = xFRecord;
    }

    public int getXfIndex() {
        return this.xfIndex;
    }

    void rationalize(IndexMapping indexMapping) {
        this.xfIndex = indexMapping.getNewIndex(this.xfIndex);
    }

    void setHidden(boolean bl) {
        this.hidden = bl;
    }

    boolean getHidden() {
        return this.hidden;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColumnInfoRecord)) {
            return false;
        }
        ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)object;
        if (this.column != columnInfoRecord.column || this.xfIndex != columnInfoRecord.xfIndex || this.width != columnInfoRecord.width || this.hidden != columnInfoRecord.hidden) {
            return false;
        }
        if (this.style == null && columnInfoRecord.style != null || this.style != null && columnInfoRecord.style == null) {
            return false;
        }
        return this.style.equals(columnInfoRecord.style);
    }

    public int hashCode() {
        int n = 137;
        int n2 = 79;
        n = n * n2 + this.column;
        n = n * n2 + this.xfIndex;
        n = n * n2 + this.width;
        n = n * n2 + (this.hidden ? 1 : 0);
        if (this.style != null) {
            n ^= this.style.hashCode();
        }
        return n;
    }
}

