/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;
import jxl.write.biff.CopyAdditionalPropertySetsException;

final class CompoundFile
extends BaseCompoundFile {
    private static Logger logger = Logger.getLogger(CompoundFile.class);
    private OutputStream out;
    private byte[] excelData;
    private int size;
    private int requiredSize;
    private int numBigBlockDepotBlocks;
    private int numSmallBlockDepotChainBlocks;
    private int numSmallBlockDepotBlocks;
    private int numExtensionBlocks;
    private int extensionBlock;
    private int excelDataBlocks;
    private int rootStartBlock;
    private int excelDataStartBlock;
    private int bbdStartBlock;
    private int sbdStartBlockChain;
    private int sbdStartBlock;
    private int additionalPropertyBlocks;
    private int numSmallBlocks;
    private int numPropertySets;
    private int numRootEntryBlocks;
    private ArrayList additionalPropertySets;
    private HashMap standardPropertySets;
    private int bbdPos;
    private byte[] bigBlockDepot;

    public CompoundFile(byte[] byArray, int n, OutputStream outputStream, jxl.read.biff.CompoundFile compoundFile) throws CopyAdditionalPropertySetsException, IOException {
        this.size = n;
        this.excelData = byArray;
        this.readAdditionalPropertySets(compoundFile);
        this.numRootEntryBlocks = 1;
        this.numPropertySets = 4 + (this.additionalPropertySets != null ? this.additionalPropertySets.size() : 0);
        if (this.additionalPropertySets != null) {
            this.numSmallBlockDepotChainBlocks = this.getBigBlocksRequired(this.numSmallBlocks * 4);
            this.numSmallBlockDepotBlocks = this.getBigBlocksRequired(this.numSmallBlocks * 64);
            this.numRootEntryBlocks += this.getBigBlocksRequired(this.additionalPropertySets.size() * 128);
        }
        int n2 = this.getBigBlocksRequired(n);
        this.requiredSize = n < 4096 ? 4096 : n2 * 512;
        this.out = outputStream;
        this.excelDataBlocks = this.requiredSize / 512;
        this.numBigBlockDepotBlocks = 1;
        int n3 = 109;
        int n4 = this.excelDataBlocks + 8 + 8 + this.additionalPropertyBlocks + this.numSmallBlockDepotBlocks + this.numSmallBlockDepotChainBlocks + this.numRootEntryBlocks;
        int n5 = n4 + this.numBigBlockDepotBlocks;
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)n5 / 128.0);
        n5 = n4 + this.numBigBlockDepotBlocks;
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)n5 / 128.0);
        n5 = n4 + this.numBigBlockDepotBlocks;
        if (this.numBigBlockDepotBlocks > n3 - 1) {
            this.extensionBlock = 0;
            int n6 = this.numBigBlockDepotBlocks - n3 + 1;
            this.numExtensionBlocks = (int)Math.ceil((double)n6 / 127.0);
            n5 = n4 + this.numExtensionBlocks + this.numBigBlockDepotBlocks;
            this.numBigBlockDepotBlocks = (int)Math.ceil((double)n5 / 128.0);
            n5 = n4 + this.numExtensionBlocks + this.numBigBlockDepotBlocks;
        } else {
            this.extensionBlock = -2;
            this.numExtensionBlocks = 0;
        }
        this.excelDataStartBlock = this.numExtensionBlocks;
        this.sbdStartBlock = -2;
        if (this.additionalPropertySets != null && this.numSmallBlockDepotBlocks != 0) {
            this.sbdStartBlock = this.excelDataStartBlock + this.excelDataBlocks + this.additionalPropertyBlocks + 16;
        }
        this.sbdStartBlockChain = -2;
        if (this.sbdStartBlock != -2) {
            this.sbdStartBlockChain = this.sbdStartBlock + this.numSmallBlockDepotBlocks;
        }
        this.bbdStartBlock = this.sbdStartBlockChain != -2 ? this.sbdStartBlockChain + this.numSmallBlockDepotChainBlocks : this.excelDataStartBlock + this.excelDataBlocks + this.additionalPropertyBlocks + 16;
        this.rootStartBlock = this.bbdStartBlock + this.numBigBlockDepotBlocks;
        if (n5 != this.rootStartBlock + this.numRootEntryBlocks) {
            logger.warn("Root start block and total blocks are inconsistent  generated file may be corrupt");
            logger.warn("RootStartBlock " + this.rootStartBlock + " totalBlocks " + n5);
        }
    }

    private void readAdditionalPropertySets(jxl.read.biff.CompoundFile compoundFile) throws CopyAdditionalPropertySetsException, IOException {
        if (compoundFile == null) {
            return;
        }
        this.additionalPropertySets = new ArrayList();
        this.standardPropertySets = new HashMap();
        int n = 0;
        int n2 = compoundFile.getNumberOfPropertySets();
        for (int i = 0; i < n2; ++i) {
            Object object;
            BaseCompoundFile.PropertyStorage propertyStorage = compoundFile.getPropertySet(i);
            boolean bl = false;
            if (propertyStorage.name.equalsIgnoreCase("Root Entry")) {
                bl = true;
                ReadPropertyStorage readPropertyStorage = new ReadPropertyStorage(propertyStorage, null, i);
                this.standardPropertySets.put("Root Entry", readPropertyStorage);
            }
            for (int j = 0; j < STANDARD_PROPERTY_SETS.length && !bl; ++j) {
                if (!propertyStorage.name.equalsIgnoreCase(STANDARD_PROPERTY_SETS[j])) continue;
                object = compoundFile.findPropertyStorage(propertyStorage.name);
                Assert.verify(object != null);
                if (object != propertyStorage) continue;
                bl = true;
                ReadPropertyStorage readPropertyStorage = new ReadPropertyStorage(propertyStorage, null, i);
                this.standardPropertySets.put(STANDARD_PROPERTY_SETS[j], readPropertyStorage);
            }
            if (bl) continue;
            try {
                int n3;
                byte[] byArray = null;
                byArray = propertyStorage.size > 0 ? compoundFile.getStream(i) : new byte[]{};
                object = new ReadPropertyStorage(propertyStorage, byArray, i);
                this.additionalPropertySets.add(object);
                if (byArray.length > 4096) {
                    n3 = this.getBigBlocksRequired(byArray.length);
                    n += n3;
                    continue;
                }
                n3 = this.getSmallBlocksRequired(byArray.length);
                this.numSmallBlocks += n3;
                continue;
            }
            catch (BiffException biffException) {
                logger.error(biffException);
                throw new CopyAdditionalPropertySetsException();
            }
        }
        this.additionalPropertyBlocks = n;
    }

    public void write() throws IOException {
        this.writeHeader();
        this.writeExcelData();
        this.writeDocumentSummaryData();
        this.writeSummaryData();
        this.writeAdditionalPropertySets();
        this.writeSmallBlockDepot();
        this.writeSmallBlockDepotChain();
        this.writeBigBlockDepot();
        this.writePropertySets();
    }

    private void writeAdditionalPropertySets() throws IOException {
        if (this.additionalPropertySets == null) {
            return;
        }
        for (ReadPropertyStorage readPropertyStorage : this.additionalPropertySets) {
            byte[] byArray = readPropertyStorage.data;
            if (byArray.length <= 4096) continue;
            int n = this.getBigBlocksRequired(byArray.length);
            int n2 = n * 512;
            this.out.write(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[n2 - byArray.length];
            this.out.write(byArray2, 0, byArray2.length);
        }
    }

    private void writeExcelData() throws IOException {
        this.out.write(this.excelData, 0, this.size);
        byte[] byArray = new byte[this.requiredSize - this.size];
        this.out.write(byArray);
    }

    private void writeDocumentSummaryData() throws IOException {
        byte[] byArray = new byte[4096];
        this.out.write(byArray);
    }

    private void writeSummaryData() throws IOException {
        byte[] byArray = new byte[4096];
        this.out.write(byArray);
    }

    private void writeHeader() throws IOException {
        int n;
        byte[] byArray = new byte[512];
        byte[] byArray2 = new byte[512 * this.numExtensionBlocks];
        System.arraycopy(IDENTIFIER, 0, byArray, 0, IDENTIFIER.length);
        byArray[24] = 62;
        byArray[26] = 3;
        byArray[28] = -2;
        byArray[29] = -1;
        byArray[30] = 9;
        byArray[32] = 6;
        byArray[57] = 16;
        IntegerHelper.getFourBytes(this.numBigBlockDepotBlocks, byArray, 44);
        IntegerHelper.getFourBytes(this.sbdStartBlockChain, byArray, 60);
        IntegerHelper.getFourBytes(this.numSmallBlockDepotChainBlocks, byArray, 64);
        IntegerHelper.getFourBytes(this.extensionBlock, byArray, 68);
        IntegerHelper.getFourBytes(this.numExtensionBlocks, byArray, 72);
        IntegerHelper.getFourBytes(this.rootStartBlock, byArray, 48);
        int n2 = 76;
        int n3 = Math.min(this.numBigBlockDepotBlocks, 109);
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            IntegerHelper.getFourBytes(this.bbdStartBlock + n, byArray, n2);
            n2 += 4;
            ++n4;
        }
        for (n = n2; n < 512; ++n) {
            byArray[n] = -1;
        }
        this.out.write(byArray);
        n2 = 0;
        for (n = 0; n < this.numExtensionBlocks; ++n) {
            int n5;
            n3 = Math.min(this.numBigBlockDepotBlocks - n4, 127);
            for (n5 = 0; n5 < n3; ++n5) {
                IntegerHelper.getFourBytes(this.bbdStartBlock + n4 + n5, byArray2, n2);
                n2 += 4;
            }
            n5 = (n4 += n3) == this.numBigBlockDepotBlocks ? -2 : n + 1;
            IntegerHelper.getFourBytes(n5, byArray2, n2);
            n2 += 4;
        }
        if (this.numExtensionBlocks > 0) {
            for (n = n2; n < byArray2.length; ++n) {
                byArray2[n] = -1;
            }
            this.out.write(byArray2);
        }
    }

    private void checkBbdPos() throws IOException {
        if (this.bbdPos >= 512) {
            this.out.write(this.bigBlockDepot);
            this.bigBlockDepot = new byte[512];
            this.bbdPos = 0;
        }
    }

    private void writeBlockChain(int n, int n2) throws IOException {
        int n3;
        int n4 = n + 1;
        for (int i = n2 - 1; i > 0; i -= n3) {
            n3 = Math.min(i, (512 - this.bbdPos) / 4);
            for (int j = 0; j < n3; ++j) {
                IntegerHelper.getFourBytes(n4, this.bigBlockDepot, this.bbdPos);
                this.bbdPos += 4;
                ++n4;
            }
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
    }

    private void writeAdditionalPropertySetBlockChains() throws IOException {
        if (this.additionalPropertySets == null) {
            return;
        }
        int n = this.excelDataStartBlock + this.excelDataBlocks + 16;
        for (ReadPropertyStorage readPropertyStorage : this.additionalPropertySets) {
            if (readPropertyStorage.data.length <= 4096) continue;
            int n2 = this.getBigBlocksRequired(readPropertyStorage.data.length);
            this.writeBlockChain(n, n2);
            n += n2;
        }
    }

    private void writeSmallBlockDepotChain() throws IOException {
        if (this.sbdStartBlockChain == -2) {
            return;
        }
        byte[] byArray = new byte[this.numSmallBlockDepotChainBlocks * 512];
        int n = 0;
        int n2 = 1;
        for (ReadPropertyStorage readPropertyStorage : this.additionalPropertySets) {
            if (readPropertyStorage.data.length > 4096 || readPropertyStorage.data.length == 0) continue;
            int n3 = this.getSmallBlocksRequired(readPropertyStorage.data.length);
            for (int i = 0; i < n3 - 1; ++i) {
                IntegerHelper.getFourBytes(n2, byArray, n);
                n += 4;
                ++n2;
            }
            IntegerHelper.getFourBytes(-2, byArray, n);
            n += 4;
            ++n2;
        }
        this.out.write(byArray);
    }

    private void writeSmallBlockDepot() throws IOException {
        if (this.additionalPropertySets == null) {
            return;
        }
        byte[] byArray = new byte[this.numSmallBlockDepotBlocks * 512];
        int n = 0;
        for (ReadPropertyStorage readPropertyStorage : this.additionalPropertySets) {
            if (readPropertyStorage.data.length > 4096) continue;
            int n2 = this.getSmallBlocksRequired(readPropertyStorage.data.length);
            int n3 = n2 * 64;
            System.arraycopy(readPropertyStorage.data, 0, byArray, n, readPropertyStorage.data.length);
            n += n3;
        }
        this.out.write(byArray);
    }

    private void writeBigBlockDepot() throws IOException {
        int n;
        int n2;
        this.bigBlockDepot = new byte[512];
        this.bbdPos = 0;
        for (n2 = 0; n2 < this.numExtensionBlocks; ++n2) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        this.writeBlockChain(this.excelDataStartBlock, this.excelDataBlocks);
        for (n = n2 = this.excelDataStartBlock + this.excelDataBlocks + this.additionalPropertyBlocks; n < n2 + 7; ++n) {
            IntegerHelper.getFourBytes(n + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        for (n = n2 + 8; n < n2 + 15; ++n) {
            IntegerHelper.getFourBytes(n + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        this.writeAdditionalPropertySetBlockChains();
        if (this.sbdStartBlock != -2) {
            this.writeBlockChain(this.sbdStartBlock, this.numSmallBlockDepotBlocks);
            this.writeBlockChain(this.sbdStartBlockChain, this.numSmallBlockDepotChainBlocks);
        }
        for (n = 0; n < this.numBigBlockDepotBlocks; ++n) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        this.writeBlockChain(this.rootStartBlock, this.numRootEntryBlocks);
        if (this.bbdPos != 0) {
            for (n = this.bbdPos; n < 512; ++n) {
                this.bigBlockDepot[n] = -1;
            }
            this.out.write(this.bigBlockDepot);
        }
    }

    private int getBigBlocksRequired(int n) {
        int n2 = n / 512;
        return n % 512 > 0 ? n2 + 1 : n2;
    }

    private int getSmallBlocksRequired(int n) {
        int n2 = n / 64;
        return n % 64 > 0 ? n2 + 1 : n2;
    }

    private void writePropertySets() throws IOException {
        ReadPropertyStorage readPropertyStorage4;
        int n;
        byte[] byArray = new byte[512 * this.numRootEntryBlocks];
        int n2 = 0;
        int[] nArray = null;
        if (this.additionalPropertySets != null) {
            nArray = new int[this.numPropertySets];
            for (n = 0; n < STANDARD_PROPERTY_SETS.length; ++n) {
                ReadPropertyStorage readPropertyStorage2 = (ReadPropertyStorage)this.standardPropertySets.get(STANDARD_PROPERTY_SETS[n]);
                if (readPropertyStorage2 != null) {
                    nArray[readPropertyStorage2.number] = n;
                    continue;
                }
                logger.warn("Standard property set " + STANDARD_PROPERTY_SETS[n] + " not present in source file");
            }
            n = STANDARD_PROPERTY_SETS.length;
            for (ReadPropertyStorage readPropertyStorage3 : this.additionalPropertySets) {
                nArray[readPropertyStorage3.number] = n++;
            }
        }
        n = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.additionalPropertySets != null) {
            n5 += this.getBigBlocksRequired(this.requiredSize) * 512;
            n5 += this.getBigBlocksRequired(4096) * 512;
            n5 += this.getBigBlocksRequired(4096) * 512;
            for (ReadPropertyStorage readPropertyStorage4 : this.additionalPropertySets) {
                if (readPropertyStorage4.propertyStorage.type == 1) continue;
                if (readPropertyStorage4.propertyStorage.size >= 4096) {
                    n5 += this.getBigBlocksRequired(readPropertyStorage4.propertyStorage.size) * 512;
                    continue;
                }
                n5 += this.getSmallBlocksRequired(readPropertyStorage4.propertyStorage.size) * 64;
            }
        }
        Object object = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("Root Entry");
        ((BaseCompoundFile.PropertyStorage)object).setType(5);
        ((BaseCompoundFile.PropertyStorage)object).setStartBlock(this.sbdStartBlock);
        ((BaseCompoundFile.PropertyStorage)object).setSize(n5);
        ((BaseCompoundFile.PropertyStorage)object).setPrevious(-1);
        ((BaseCompoundFile.PropertyStorage)object).setNext(-1);
        ((BaseCompoundFile.PropertyStorage)object).setColour(0);
        n = 1;
        if (this.additionalPropertySets != null) {
            readPropertyStorage4 = (ReadPropertyStorage)this.standardPropertySets.get("Root Entry");
            n = nArray[readPropertyStorage4.propertyStorage.child];
        }
        ((BaseCompoundFile.PropertyStorage)object).setChild(n);
        System.arraycopy(((BaseCompoundFile.PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        object = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("Workbook");
        ((BaseCompoundFile.PropertyStorage)object).setType(2);
        ((BaseCompoundFile.PropertyStorage)object).setStartBlock(this.excelDataStartBlock);
        ((BaseCompoundFile.PropertyStorage)object).setSize(this.requiredSize);
        n3 = 3;
        n4 = -1;
        if (this.additionalPropertySets != null) {
            readPropertyStorage4 = (ReadPropertyStorage)this.standardPropertySets.get("Workbook");
            n3 = readPropertyStorage4.propertyStorage.previous != -1 ? nArray[readPropertyStorage4.propertyStorage.previous] : -1;
            n4 = readPropertyStorage4.propertyStorage.next != -1 ? nArray[readPropertyStorage4.propertyStorage.next] : -1;
        }
        ((BaseCompoundFile.PropertyStorage)object).setPrevious(n3);
        ((BaseCompoundFile.PropertyStorage)object).setNext(n4);
        ((BaseCompoundFile.PropertyStorage)object).setChild(-1);
        System.arraycopy(((BaseCompoundFile.PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        object = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("\u0005SummaryInformation");
        ((BaseCompoundFile.PropertyStorage)object).setType(2);
        ((BaseCompoundFile.PropertyStorage)object).setStartBlock(this.excelDataStartBlock + this.excelDataBlocks);
        ((BaseCompoundFile.PropertyStorage)object).setSize(4096);
        n3 = 1;
        n4 = 3;
        if (this.additionalPropertySets != null && (readPropertyStorage4 = (ReadPropertyStorage)this.standardPropertySets.get("\u0005SummaryInformation")) != null) {
            n3 = readPropertyStorage4.propertyStorage.previous != -1 ? nArray[readPropertyStorage4.propertyStorage.previous] : -1;
            n4 = readPropertyStorage4.propertyStorage.next != -1 ? nArray[readPropertyStorage4.propertyStorage.next] : -1;
        }
        ((BaseCompoundFile.PropertyStorage)object).setPrevious(n3);
        ((BaseCompoundFile.PropertyStorage)object).setNext(n4);
        ((BaseCompoundFile.PropertyStorage)object).setChild(-1);
        System.arraycopy(((BaseCompoundFile.PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        object = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("\u0005DocumentSummaryInformation");
        ((BaseCompoundFile.PropertyStorage)object).setType(2);
        ((BaseCompoundFile.PropertyStorage)object).setStartBlock(this.excelDataStartBlock + this.excelDataBlocks + 8);
        ((BaseCompoundFile.PropertyStorage)object).setSize(4096);
        ((BaseCompoundFile.PropertyStorage)object).setPrevious(-1);
        ((BaseCompoundFile.PropertyStorage)object).setNext(-1);
        ((BaseCompoundFile.PropertyStorage)object).setChild(-1);
        System.arraycopy(((BaseCompoundFile.PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        if (this.additionalPropertySets == null) {
            this.out.write(byArray);
            return;
        }
        int n6 = this.excelDataStartBlock + this.excelDataBlocks + 16;
        int n7 = 0;
        for (ReadPropertyStorage readPropertyStorage5 : this.additionalPropertySets) {
            int n8 = readPropertyStorage5.data.length > 4096 ? n6 : n7;
            object = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage(readPropertyStorage5.propertyStorage.name);
            ((BaseCompoundFile.PropertyStorage)object).setType(readPropertyStorage5.propertyStorage.type);
            ((BaseCompoundFile.PropertyStorage)object).setStartBlock(n8);
            ((BaseCompoundFile.PropertyStorage)object).setSize(readPropertyStorage5.propertyStorage.size);
            n3 = readPropertyStorage5.propertyStorage.previous != -1 ? nArray[readPropertyStorage5.propertyStorage.previous] : -1;
            n4 = readPropertyStorage5.propertyStorage.next != -1 ? nArray[readPropertyStorage5.propertyStorage.next] : -1;
            n = readPropertyStorage5.propertyStorage.child != -1 ? nArray[readPropertyStorage5.propertyStorage.child] : -1;
            ((BaseCompoundFile.PropertyStorage)object).setPrevious(n3);
            ((BaseCompoundFile.PropertyStorage)object).setNext(n4);
            ((BaseCompoundFile.PropertyStorage)object).setChild(n);
            System.arraycopy(((BaseCompoundFile.PropertyStorage)object).data, 0, byArray, n2, 128);
            n2 += 128;
            if (readPropertyStorage5.data.length > 4096) {
                n6 += this.getBigBlocksRequired(readPropertyStorage5.data.length);
                continue;
            }
            n7 += this.getSmallBlocksRequired(readPropertyStorage5.data.length);
        }
        this.out.write(byArray);
    }

    private static final class ReadPropertyStorage {
        BaseCompoundFile.PropertyStorage propertyStorage;
        byte[] data;
        int number;

        ReadPropertyStorage(BaseCompoundFile.PropertyStorage propertyStorage, byte[] byArray, int n) {
            this.propertyStorage = propertyStorage;
            this.data = byArray;
            this.number = n;
        }
    }
}

