/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import jxl.CellType;
import jxl.DateCell;
import jxl.biff.DoubleHelper;
import jxl.biff.Type;
import jxl.format.CellFormat;
import jxl.write.DateFormats;
import jxl.write.WritableCellFormat;
import jxl.write.biff.CellValue;

public abstract class DateRecord
extends CellValue {
    private static Logger logger = Logger.getLogger(DateRecord.class);
    private double value;
    private Date date;
    private boolean time;
    private static final int utcOffsetDays = 25569;
    private static final long msInADay = 86400000L;
    static final WritableCellFormat defaultDateFormat = new WritableCellFormat(DateFormats.DEFAULT);
    private static final int nonLeapDay = 61;

    protected DateRecord(int n, int n2, Date date) {
        this(n, n2, date, (CellFormat)defaultDateFormat, true);
    }

    protected DateRecord(int n, int n2, Date date, GMTDate gMTDate) {
        this(n, n2, date, (CellFormat)defaultDateFormat, false);
    }

    protected DateRecord(int n, int n2, Date date, CellFormat cellFormat) {
        super(Type.NUMBER, n, n2, cellFormat);
        this.date = date;
        this.calculateValue(true);
    }

    protected DateRecord(int n, int n2, Date date, CellFormat cellFormat, GMTDate gMTDate) {
        super(Type.NUMBER, n, n2, cellFormat);
        this.date = date;
        this.calculateValue(false);
    }

    protected DateRecord(int n, int n2, Date date, CellFormat cellFormat, boolean bl) {
        super(Type.NUMBER, n, n2, cellFormat);
        this.date = date;
        this.time = bl;
        this.calculateValue(false);
    }

    protected DateRecord(DateCell dateCell) {
        super(Type.NUMBER, dateCell);
        this.date = dateCell.getDate();
        this.time = dateCell.isTime();
        this.calculateValue(false);
    }

    protected DateRecord(int n, int n2, DateRecord dateRecord) {
        super(Type.NUMBER, n, n2, dateRecord);
        this.value = dateRecord.value;
        this.time = dateRecord.time;
        this.date = dateRecord.date;
    }

    private void calculateValue(boolean bl) {
        long l = 0L;
        long l2 = 0L;
        if (bl) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.date);
            l = calendar.get(15);
            l2 = calendar.get(16);
        }
        long l3 = this.date.getTime() + l + l2;
        double d = (double)l3 / 8.64E7;
        this.value = d + 25569.0;
        if (!this.time && this.value < 61.0) {
            this.value -= 1.0;
        }
        if (this.time) {
            this.value -= (double)((int)this.value);
        }
    }

    public CellType getType() {
        return CellType.DATE;
    }

    public byte[] getData() {
        byte[] byArray = super.getData();
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        DoubleHelper.getIEEEBytes(this.value, byArray2, byArray.length);
        return byArray2;
    }

    public String getContents() {
        return this.date.toString();
    }

    protected void setDate(Date date) {
        this.date = date;
        this.calculateValue(true);
    }

    protected void setDate(Date date, GMTDate gMTDate) {
        this.date = date;
        this.calculateValue(false);
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isTime() {
        return this.time;
    }

    public DateFormat getDateFormat() {
        return null;
    }

    protected static final class GMTDate {
    }
}

