/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import jxl.CellType;
import jxl.Hyperlink;
import jxl.Range;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.SheetRangeImpl;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;

public class HyperlinkRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(HyperlinkRecord.class);
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private URL url;
    private File file;
    private String location;
    private String contents;
    private LinkType linkType;
    private byte[] data;
    private Range range;
    private WritableSheet sheet;
    private boolean modified;
    private static final LinkType urlLink = new LinkType();
    private static final LinkType fileLink = new LinkType();
    private static final LinkType uncLink = new LinkType();
    private static final LinkType workbookLink = new LinkType();
    private static final LinkType unknown = new LinkType();

    protected HyperlinkRecord(Hyperlink hyperlink, WritableSheet writableSheet) {
        super(Type.HLINK);
        Assert.verify(hyperlink instanceof jxl.read.biff.HyperlinkRecord);
        jxl.read.biff.HyperlinkRecord hyperlinkRecord = (jxl.read.biff.HyperlinkRecord)hyperlink;
        this.data = hyperlinkRecord.getRecord().getData();
        this.sheet = writableSheet;
        this.firstRow = hyperlinkRecord.getRow();
        this.firstColumn = hyperlinkRecord.getColumn();
        this.lastRow = hyperlinkRecord.getLastRow();
        this.lastColumn = hyperlinkRecord.getLastColumn();
        this.range = new SheetRangeImpl(writableSheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        this.linkType = unknown;
        if (hyperlinkRecord.isFile()) {
            this.linkType = fileLink;
            this.file = hyperlinkRecord.getFile();
        } else if (hyperlinkRecord.isURL()) {
            this.linkType = urlLink;
            this.url = hyperlinkRecord.getURL();
        } else if (hyperlinkRecord.isLocation()) {
            this.linkType = workbookLink;
            this.location = hyperlinkRecord.getLocation();
        }
        this.modified = false;
    }

    protected HyperlinkRecord(int n, int n2, int n3, int n4, URL uRL, String string) {
        super(Type.HLINK);
        this.firstColumn = n;
        this.firstRow = n2;
        this.lastColumn = Math.max(this.firstColumn, n3);
        this.lastRow = Math.max(this.firstRow, n4);
        this.url = uRL;
        this.contents = string;
        this.linkType = urlLink;
        this.modified = true;
    }

    protected HyperlinkRecord(int n, int n2, int n3, int n4, File file, String string) {
        super(Type.HLINK);
        this.firstColumn = n;
        this.firstRow = n2;
        this.lastColumn = Math.max(this.firstColumn, n3);
        this.lastRow = Math.max(this.firstRow, n4);
        this.contents = string;
        this.file = file;
        this.linkType = file.getPath().startsWith("\\\\") ? uncLink : fileLink;
        this.modified = true;
    }

    protected HyperlinkRecord(int n, int n2, int n3, int n4, String string, WritableSheet writableSheet, int n5, int n6, int n7, int n8) {
        super(Type.HLINK);
        this.firstColumn = n;
        this.firstRow = n2;
        this.lastColumn = Math.max(this.firstColumn, n3);
        this.lastRow = Math.max(this.firstRow, n4);
        this.setLocation(writableSheet, n5, n6, n7, n8);
        this.contents = string;
        this.linkType = workbookLink;
        this.modified = true;
    }

    public boolean isFile() {
        return this.linkType == fileLink;
    }

    public boolean isUNC() {
        return this.linkType == uncLink;
    }

    public boolean isURL() {
        return this.linkType == urlLink;
    }

    public boolean isLocation() {
        return this.linkType == workbookLink;
    }

    public int getRow() {
        return this.firstRow;
    }

    public int getColumn() {
        return this.firstColumn;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public byte[] getData() {
        if (!this.modified) {
            return this.data;
        }
        byte[] byArray = new byte[32];
        IntegerHelper.getTwoBytes(this.firstRow, byArray, 0);
        IntegerHelper.getTwoBytes(this.lastRow, byArray, 2);
        IntegerHelper.getTwoBytes(this.firstColumn, byArray, 4);
        IntegerHelper.getTwoBytes(this.lastColumn, byArray, 6);
        byArray[8] = -48;
        byArray[9] = -55;
        byArray[10] = -22;
        byArray[11] = 121;
        byArray[12] = -7;
        byArray[13] = -70;
        byArray[14] = -50;
        byArray[15] = 17;
        byArray[16] = -116;
        byArray[17] = -126;
        byArray[18] = 0;
        byArray[19] = -86;
        byArray[20] = 0;
        byArray[21] = 75;
        byArray[22] = -87;
        byArray[23] = 11;
        byArray[24] = 2;
        byArray[25] = 0;
        byArray[26] = 0;
        byArray[27] = 0;
        int n = 0;
        if (this.isURL()) {
            n = 3;
            if (this.contents != null) {
                n |= 0x14;
            }
        } else if (this.isFile()) {
            n = 3;
            if (this.contents == null) {
                n |= 0x14;
            }
        } else if (this.isLocation()) {
            n = 8;
        } else if (this.isUNC()) {
            n = 259;
        }
        IntegerHelper.getFourBytes(n, byArray, 28);
        if (this.isURL()) {
            this.data = this.getURLData(byArray);
        } else if (this.isFile()) {
            this.data = this.getFileData(byArray);
        } else if (this.isLocation()) {
            this.data = this.getLocationData(byArray);
        } else if (this.isUNC()) {
            this.data = this.getUNCData(byArray);
        }
        return this.data;
    }

    public String toString() {
        if (this.isFile()) {
            return this.file.toString();
        }
        if (this.isURL()) {
            return this.url.toString();
        }
        if (this.isUNC()) {
            return this.file.toString();
        }
        return "";
    }

    public Range getRange() {
        return this.range;
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.linkType = urlLink;
        this.file = null;
        this.location = null;
        this.contents = null;
        this.url = uRL;
        this.modified = true;
        if (this.sheet == null) {
            return;
        }
        WritableCell writableCell = this.sheet.getWritableCell(this.firstColumn, this.firstRow);
        if (writableCell.getType() == CellType.LABEL) {
            Label label = (Label)writableCell;
            String string = uRL2.toString();
            String string2 = "";
            if (string.charAt(string.length() - 1) == '/' || string.charAt(string.length() - 1) == '\\') {
                string2 = string.substring(0, string.length() - 1);
            }
            if (label.getString().equals(string) || label.getString().equals(string2)) {
                logger.debug("equal");
                label.setString(uRL.toString());
            }
        }
    }

    public void setFile(File file) {
        this.linkType = fileLink;
        this.url = null;
        this.location = null;
        this.contents = null;
        this.file = file;
        this.modified = true;
        if (this.sheet == null) {
            return;
        }
        WritableCell writableCell = this.sheet.getWritableCell(this.firstColumn, this.firstRow);
        Assert.verify(writableCell.getType() == CellType.LABEL);
        Label label = (Label)writableCell;
        label.setString(file.toString());
    }

    protected void setLocation(String string, WritableSheet writableSheet, int n, int n2, int n3, int n4) {
        this.linkType = workbookLink;
        this.url = null;
        this.file = null;
        this.modified = true;
        this.contents = string;
        this.setLocation(writableSheet, n, n2, n3, n4);
        if (writableSheet == null) {
            return;
        }
        WritableCell writableCell = writableSheet.getWritableCell(this.firstColumn, this.firstRow);
        Assert.verify(writableCell.getType() == CellType.LABEL);
        Label label = (Label)writableCell;
        label.setString(string);
    }

    private void setLocation(WritableSheet writableSheet, int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        if (writableSheet.getName().indexOf(39) == -1) {
            stringBuffer.append(writableSheet.getName());
        } else {
            String string = writableSheet.getName();
            int n5 = 0;
            int n6 = string.indexOf(39, n5);
            while (n6 != -1 && n5 < string.length()) {
                stringBuffer.append(string.substring(n5, n6));
                stringBuffer.append("''");
                n5 = n6 + 1;
                n6 = string.indexOf(39, n5);
            }
            stringBuffer.append(string.substring(n5));
        }
        stringBuffer.append('\'');
        stringBuffer.append('!');
        n3 = Math.max(n, n3);
        n4 = Math.max(n2, n4);
        CellReferenceHelper.getCellReference(n, n2, stringBuffer);
        stringBuffer.append(':');
        CellReferenceHelper.getCellReference(n3, n4, stringBuffer);
        this.location = stringBuffer.toString();
    }

    void insertRow(int n) {
        Assert.verify(this.sheet != null && this.range != null);
        if (n > this.lastRow) {
            return;
        }
        if (n <= this.firstRow) {
            ++this.firstRow;
            this.modified = true;
        }
        if (n <= this.lastRow) {
            ++this.lastRow;
            this.modified = true;
        }
        if (this.modified) {
            this.range = new SheetRangeImpl(this.sheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        }
    }

    void insertColumn(int n) {
        Assert.verify(this.sheet != null && this.range != null);
        if (n > this.lastColumn) {
            return;
        }
        if (n <= this.firstColumn) {
            ++this.firstColumn;
            this.modified = true;
        }
        if (n <= this.lastColumn) {
            ++this.lastColumn;
            this.modified = true;
        }
        if (this.modified) {
            this.range = new SheetRangeImpl(this.sheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        }
    }

    void removeRow(int n) {
        Assert.verify(this.sheet != null && this.range != null);
        if (n > this.lastRow) {
            return;
        }
        if (n < this.firstRow) {
            --this.firstRow;
            this.modified = true;
        }
        if (n < this.lastRow) {
            --this.lastRow;
            this.modified = true;
        }
        if (this.modified) {
            Assert.verify(this.range != null);
            this.range = new SheetRangeImpl(this.sheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        }
    }

    void removeColumn(int n) {
        Assert.verify(this.sheet != null && this.range != null);
        if (n > this.lastColumn) {
            return;
        }
        if (n < this.firstColumn) {
            --this.firstColumn;
            this.modified = true;
        }
        if (n < this.lastColumn) {
            --this.lastColumn;
            this.modified = true;
        }
        if (this.modified) {
            Assert.verify(this.range != null);
            this.range = new SheetRangeImpl(this.sheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        }
    }

    private byte[] getURLData(byte[] byArray) {
        String string = this.url.toString();
        int n = byArray.length + 20 + (string.length() + 1) * 2;
        if (this.contents != null) {
            n += 4 + (this.contents.length() + 1) * 2;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n2 = byArray.length;
        if (this.contents != null) {
            IntegerHelper.getFourBytes(this.contents.length() + 1, byArray2, n2);
            StringHelper.getUnicodeBytes(this.contents, byArray2, n2 + 4);
            n2 += (this.contents.length() + 1) * 2 + 4;
        }
        byArray2[n2] = -32;
        byArray2[n2 + 1] = -55;
        byArray2[n2 + 2] = -22;
        byArray2[n2 + 3] = 121;
        byArray2[n2 + 4] = -7;
        byArray2[n2 + 5] = -70;
        byArray2[n2 + 6] = -50;
        byArray2[n2 + 7] = 17;
        byArray2[n2 + 8] = -116;
        byArray2[n2 + 9] = -126;
        byArray2[n2 + 10] = 0;
        byArray2[n2 + 11] = -86;
        byArray2[n2 + 12] = 0;
        byArray2[n2 + 13] = 75;
        byArray2[n2 + 14] = -87;
        byArray2[n2 + 15] = 11;
        IntegerHelper.getFourBytes((string.length() + 1) * 2, byArray2, n2 + 16);
        StringHelper.getUnicodeBytes(string, byArray2, n2 + 20);
        return byArray2;
    }

    private byte[] getUNCData(byte[] byArray) {
        String string = this.file.getPath();
        byte[] byArray2 = new byte[byArray.length + string.length() * 2 + 2 + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = byArray.length;
        int n2 = string.length() + 1;
        IntegerHelper.getFourBytes(n2, byArray2, n);
        StringHelper.getUnicodeBytes(string, byArray2, n + 4);
        return byArray2;
    }

    private byte[] getFileData(byte[] byArray) {
        int n;
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(this.file.getName());
        arrayList2.add(this.getShortName(this.file.getName()));
        for (File file = this.file.getParentFile(); file != null; file = file.getParentFile()) {
            arrayList.add(file.getName());
            arrayList2.add(this.getShortName(file.getName()));
        }
        int n2 = 0;
        int n3 = arrayList.size() - 1;
        boolean bl = true;
        while (bl) {
            charSequence = (String)arrayList.get(n3);
            if (((String)charSequence).equals("..")) {
                ++n2;
                arrayList.remove(n3);
                arrayList2.remove(n3);
            } else {
                bl = false;
            }
            --n3;
        }
        charSequence = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.file.getPath().charAt(1) == ':' && (n = (int)this.file.getPath().charAt(0)) != 67 && n != 99) {
            ((StringBuffer)charSequence).append((char)n);
            ((StringBuffer)charSequence).append(':');
            stringBuffer.append((char)n);
            stringBuffer.append(':');
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            ((StringBuffer)charSequence).append((String)arrayList.get(n));
            stringBuffer.append((String)arrayList2.get(n));
            if (n == 0) continue;
            ((StringBuffer)charSequence).append("\\");
            stringBuffer.append("\\");
        }
        String string = ((StringBuffer)charSequence).toString();
        String string2 = stringBuffer.toString();
        int n4 = byArray.length + 4 + (string2.length() + 1) * 2 + 16 + 2 + 4 + string.length() + 1 + 4 + 24;
        if (this.contents != null) {
            n4 += 4 + (this.contents.length() + 1) * 2;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n5 = byArray.length;
        if (this.contents != null) {
            IntegerHelper.getFourBytes(this.contents.length() + 1, byArray2, n5);
            StringHelper.getUnicodeBytes(this.contents, byArray2, n5 + 4);
            n5 += (this.contents.length() + 1) * 2 + 4;
        }
        int n6 = n5;
        IntegerHelper.getFourBytes(string2.length() + 1, byArray2, n6);
        StringHelper.getUnicodeBytes(string2, byArray2, n6 + 4);
        byArray2[n6 += 4 + (string2.length() + 1) * 2] = 3;
        byArray2[n6 + 1] = 3;
        byArray2[n6 + 2] = 0;
        byArray2[n6 + 3] = 0;
        byArray2[n6 + 4] = 0;
        byArray2[n6 + 5] = 0;
        byArray2[n6 + 6] = 0;
        byArray2[n6 + 7] = 0;
        byArray2[n6 + 8] = -64;
        byArray2[n6 + 9] = 0;
        byArray2[n6 + 10] = 0;
        byArray2[n6 + 11] = 0;
        byArray2[n6 + 12] = 0;
        byArray2[n6 + 13] = 0;
        byArray2[n6 + 14] = 0;
        byArray2[n6 + 15] = 70;
        IntegerHelper.getTwoBytes(n2, byArray2, n6 += 16);
        IntegerHelper.getFourBytes(string.length() + 1, byArray2, n6 += 2);
        StringHelper.getBytes(string, byArray2, n6 += 4);
        byArray2[n6 += string.length() + 1] = -1;
        byArray2[n6 + 1] = -1;
        byArray2[n6 + 2] = -83;
        byArray2[n6 + 3] = -34;
        return byArray2;
    }

    private String getShortName(String string) {
        int n = string.indexOf(46);
        String string2 = null;
        String string3 = null;
        if (n == -1) {
            string2 = string;
            string3 = "";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2.length() > 8) {
            string2 = string2.substring(0, 6) + "~" + (string2.length() - 6);
            string2 = string2.substring(0, 8);
        }
        if ((string3 = string3.substring(0, Math.min(3, string3.length()))).length() > 0) {
            return string2 + '.' + string3;
        }
        return string2;
    }

    private byte[] getLocationData(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 4 + (this.location.length() + 1) * 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = byArray.length;
        IntegerHelper.getFourBytes(this.location.length() + 1, byArray2, n);
        StringHelper.getUnicodeBytes(this.location, byArray2, n + 4);
        return byArray2;
    }

    void initialize(WritableSheet writableSheet) {
        this.sheet = writableSheet;
        this.range = new SheetRangeImpl(writableSheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
    }

    String getContents() {
        return this.contents;
    }

    protected void setContents(String string) {
        this.contents = string;
        this.modified = true;
    }

    private static class LinkType {
        private LinkType() {
        }
    }
}

