/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.DoubleHelper;
import jxl.biff.Type;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.write.biff.CellValue;

public abstract class NumberRecord
extends CellValue {
    private double value;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    protected NumberRecord(int n, int n2, double d) {
        super(Type.NUMBER, n, n2);
        this.value = d;
    }

    protected NumberRecord(int n, int n2, double d, CellFormat cellFormat) {
        super(Type.NUMBER, n, n2, cellFormat);
        this.value = d;
    }

    protected NumberRecord(NumberCell numberCell) {
        super(Type.NUMBER, numberCell);
        this.value = numberCell.getValue();
    }

    protected NumberRecord(int n, int n2, NumberRecord numberRecord) {
        super(Type.NUMBER, n, n2, numberRecord);
        this.value = numberRecord.value;
    }

    public CellType getType() {
        return CellType.NUMBER;
    }

    public byte[] getData() {
        byte[] byArray = super.getData();
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        DoubleHelper.getIEEEBytes(this.value, byArray2, byArray.length);
        return byArray2;
    }

    public String getContents() {
        if (this.format == null) {
            this.format = ((XFRecord)this.getCellFormat()).getNumberFormat();
            if (this.format == null) {
                this.format = defaultFormat;
            }
        }
        return this.format.format(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public NumberFormat getNumberFormat() {
        return null;
    }
}

