/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.text.NumberFormat;
import jxl.NumberFormulaCell;
import jxl.biff.DoubleHelper;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.WritableWorkbookImpl;

class ReadNumberFormulaRecord
extends ReadFormulaRecord
implements NumberFormulaCell {
    private static Logger logger = Logger.getLogger(ReadNumberFormulaRecord.class);

    public ReadNumberFormulaRecord(FormulaData formulaData) {
        super(formulaData);
    }

    public double getValue() {
        return ((NumberFormulaCell)((Object)this.getReadFormula())).getValue();
    }

    public NumberFormat getNumberFormat() {
        return ((NumberFormulaCell)((Object)this.getReadFormula())).getNumberFormat();
    }

    protected byte[] handleFormulaException() {
        byte[] byArray = null;
        byte[] byArray2 = super.getCellData();
        WritableWorkbookImpl writableWorkbookImpl = this.getSheet().getWorkbook();
        FormulaParser formulaParser = new FormulaParser(Double.toString(this.getValue()), writableWorkbookImpl, writableWorkbookImpl, writableWorkbookImpl.getSettings());
        try {
            formulaParser.parse();
        }
        catch (FormulaException formulaException) {
            logger.warn(formulaException.getMessage());
        }
        byte[] byArray3 = formulaParser.getBytes();
        byArray = new byte[byArray3.length + 16];
        IntegerHelper.getTwoBytes(byArray3.length, byArray, 14);
        System.arraycopy(byArray3, 0, byArray, 16, byArray3.length);
        byArray[8] = (byte)(byArray[8] | 2);
        byte[] byArray4 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray4, byArray2.length, byArray.length);
        DoubleHelper.getIEEEBytes(this.getValue(), byArray4, 6);
        return byArray4;
    }
}

