/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.CellType;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.write.Number;
import jxl.write.biff.CellValue;
import jxl.write.biff.File;
import jxl.write.biff.MulRKRecord;
import jxl.write.biff.StringRecord;

class RowRecord
extends WritableRecordData {
    private static final Logger logger = Logger.getLogger(RowRecord.class);
    private byte[] data;
    private CellValue[] cells;
    private int rowHeight;
    private boolean collapsed;
    private int rowNumber;
    private int numColumns;
    private int xfIndex;
    private XFRecord style;
    private boolean defaultFormat;
    private boolean matchesDefFontHeight;
    private static final int growSize = 10;
    private static final int maxRKValue = 0x1FFFFFFF;
    private static final int minRKValue = -536870912;
    private static int defaultHeightIndicator = 255;
    private static int maxColumns = 256;

    public RowRecord(int n) {
        super(Type.ROW);
        this.rowNumber = n;
        this.cells = new CellValue[0];
        this.numColumns = 0;
        this.rowHeight = defaultHeightIndicator;
        this.collapsed = false;
        this.matchesDefFontHeight = true;
    }

    public void setRowHeight(int n) {
        if (n == 0) {
            this.setCollapsed(true);
            this.matchesDefFontHeight = false;
        } else {
            this.rowHeight = n;
            this.matchesDefFontHeight = false;
        }
    }

    void setRowDetails(int n, boolean bl, boolean bl2, XFRecord xFRecord) {
        this.rowHeight = n;
        this.collapsed = bl2;
        this.matchesDefFontHeight = bl;
        if (xFRecord != null) {
            this.defaultFormat = true;
            this.style = xFRecord;
            this.xfIndex = this.style.getXFIndex();
        }
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void addCell(CellValue cellValue) {
        int n = cellValue.getColumn();
        if (n >= maxColumns) {
            logger.warn("Could not add cell at " + CellReferenceHelper.getCellReference(cellValue.getRow(), cellValue.getColumn()) + " because it exceeds the maximum column limit");
            return;
        }
        if (n >= this.cells.length) {
            CellValue[] cellValueArray = this.cells;
            this.cells = new CellValue[Math.max(cellValueArray.length + 10, n + 1)];
            System.arraycopy(cellValueArray, 0, this.cells, 0, cellValueArray.length);
            cellValueArray = null;
        }
        this.cells[n] = cellValue;
        this.numColumns = Math.max(n + 1, this.numColumns);
    }

    public void removeCell(int n) {
        if (n >= this.numColumns) {
            return;
        }
        this.cells[n] = null;
    }

    public void write(File file) throws IOException {
        file.write(this);
    }

    public void writeCells(File file) throws IOException {
        ArrayList<CellValue> arrayList = new ArrayList<CellValue>();
        boolean bl = false;
        for (int i = 0; i < this.numColumns; ++i) {
            bl = false;
            if (this.cells[i] != null) {
                WritableRecordData writableRecordData;
                if (this.cells[i].getType() == CellType.NUMBER && (writableRecordData = (Number)this.cells[i]).getValue() == (double)((int)writableRecordData.getValue()) && writableRecordData.getValue() < 5.36870911E8 && writableRecordData.getValue() > -5.36870912E8 && writableRecordData.getCellFeatures() == null) {
                    bl = true;
                }
                if (bl) {
                    arrayList.add(this.cells[i]);
                    continue;
                }
                this.writeIntegerValues(arrayList, file);
                file.write(this.cells[i]);
                if (this.cells[i].getType() != CellType.STRING_FORMULA) continue;
                writableRecordData = new StringRecord(this.cells[i].getContents());
                file.write(writableRecordData);
                continue;
            }
            this.writeIntegerValues(arrayList, file);
        }
        this.writeIntegerValues(arrayList, file);
    }

    private void writeIntegerValues(ArrayList arrayList, File file) throws IOException {
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() >= 3) {
            MulRKRecord mulRKRecord = new MulRKRecord(arrayList);
            file.write(mulRKRecord);
        } else {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                file.write((CellValue)iterator.next());
            }
        }
        arrayList.clear();
    }

    public byte[] getData() {
        byte[] byArray = new byte[16];
        IntegerHelper.getTwoBytes(this.rowNumber, byArray, 0);
        IntegerHelper.getTwoBytes(this.numColumns, byArray, 4);
        IntegerHelper.getTwoBytes(this.rowHeight, byArray, 6);
        int n = 256;
        if (this.collapsed) {
            n |= 0x20;
        }
        if (!this.matchesDefFontHeight) {
            n |= 0x40;
        }
        if (this.defaultFormat) {
            n |= 0x80;
            n |= this.xfIndex << 16;
        }
        IntegerHelper.getFourBytes(n, byArray, 12);
        return byArray;
    }

    public int getMaxColumn() {
        return this.numColumns;
    }

    public CellValue getCell(int n) {
        return n >= 0 && n < this.numColumns ? this.cells[n] : null;
    }

    void incrementRow() {
        ++this.rowNumber;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            this.cells[i].incrementRow();
        }
    }

    void decrementRow() {
        --this.rowNumber;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            this.cells[i].decrementRow();
        }
    }

    void insertColumn(int n) {
        if (n >= this.numColumns) {
            return;
        }
        if (this.numColumns >= maxColumns) {
            logger.warn("Could not insert column because maximum column limit has been reached");
            return;
        }
        CellValue[] cellValueArray = this.cells;
        this.cells = this.numColumns >= this.cells.length - 1 ? new CellValue[cellValueArray.length + 10] : new CellValue[cellValueArray.length];
        System.arraycopy(cellValueArray, 0, this.cells, 0, n);
        System.arraycopy(cellValueArray, n, this.cells, n + 1, this.numColumns - n);
        for (int i = n + 1; i <= this.numColumns; ++i) {
            if (this.cells[i] == null) continue;
            this.cells[i].incrementColumn();
        }
        ++this.numColumns;
    }

    void removeColumn(int n) {
        if (n >= this.numColumns) {
            return;
        }
        CellValue[] cellValueArray = this.cells;
        this.cells = new CellValue[cellValueArray.length];
        System.arraycopy(cellValueArray, 0, this.cells, 0, n);
        System.arraycopy(cellValueArray, n + 1, this.cells, n, this.numColumns - (n + 1));
        for (int i = n; i < this.numColumns; ++i) {
            if (this.cells[i] == null) continue;
            this.cells[i].decrementColumn();
        }
        --this.numColumns;
    }

    public boolean isDefaultHeight() {
        return this.rowHeight == defaultHeightIndicator;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    void rationalize(IndexMapping indexMapping) {
        if (this.defaultFormat) {
            this.xfIndex = indexMapping.getNewIndex(this.xfIndex);
        }
    }

    XFRecord getStyle() {
        return this.style;
    }

    boolean hasDefaultFormat() {
        return this.defaultFormat;
    }

    boolean matchesDefaultFontHeight() {
        return this.matchesDefFontHeight;
    }
}

