/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Hyperlink;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.CellReferenceHelper;
import jxl.biff.ConditionalFormat;
import jxl.biff.DataValidation;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkbookMethods;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Button;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.format.CellFormat;
import jxl.read.biff.NameRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.WorkbookParser;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadDateFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WritableWorkbookImpl;

class SheetCopier {
    private static Logger logger = Logger.getLogger(SheetCopier.class);
    private SheetImpl fromSheet;
    private WritableSheetImpl toSheet;
    private WorkbookSettings workbookSettings;
    private TreeSet columnFormats;
    private FormattingRecords formatRecords;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private ArrayList rowBreaks;
    private ArrayList columnBreaks;
    private SheetWriter sheetWriter;
    private ArrayList drawings;
    private ArrayList images;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private DataValidation dataValidation;
    private ComboBox comboBox;
    private PLSRecord plsRecord;
    private boolean chartOnly;
    private ButtonPropertySetRecord buttonPropertySet;
    private int numRows;
    private HashMap xfRecords;
    private HashMap fonts;
    private HashMap formats;

    public SheetCopier(Sheet sheet, WritableSheet writableSheet) {
        this.fromSheet = (SheetImpl)sheet;
        this.toSheet = (WritableSheetImpl)writableSheet;
        this.workbookSettings = this.toSheet.getWorkbook().getSettings();
        this.chartOnly = false;
    }

    void setColumnFormats(TreeSet treeSet) {
        this.columnFormats = treeSet;
    }

    void setFormatRecords(FormattingRecords formattingRecords) {
        this.formatRecords = formattingRecords;
    }

    void setHyperlinks(ArrayList arrayList) {
        this.hyperlinks = arrayList;
    }

    void setMergedCells(MergedCells mergedCells) {
        this.mergedCells = mergedCells;
    }

    void setRowBreaks(ArrayList arrayList) {
        this.rowBreaks = arrayList;
    }

    void setColumnBreaks(ArrayList arrayList) {
        this.columnBreaks = arrayList;
    }

    void setSheetWriter(SheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }

    void setDrawings(ArrayList arrayList) {
        this.drawings = arrayList;
    }

    void setImages(ArrayList arrayList) {
        this.images = arrayList;
    }

    void setConditionalFormats(ArrayList arrayList) {
        this.conditionalFormats = arrayList;
    }

    AutoFilter getAutoFilter() {
        return this.autoFilter;
    }

    DataValidation getDataValidation() {
        return this.dataValidation;
    }

    ComboBox getComboBox() {
        return this.comboBox;
    }

    PLSRecord getPLSRecord() {
        return this.plsRecord;
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    public void copySheet() {
        ConditionalFormat[] conditionalFormatArray;
        int[] nArray;
        Object[] objectArray;
        this.shallowCopyCells();
        jxl.read.biff.ColumnInfoRecord[] columnInfoRecordArray = this.fromSheet.getColumnInfos();
        for (int i = 0; i < columnInfoRecordArray.length; ++i) {
            jxl.read.biff.ColumnInfoRecord columnInfoRecord = columnInfoRecordArray[i];
            for (int j = columnInfoRecord.getStartColumn(); j <= columnInfoRecord.getEndColumn(); ++j) {
                ColumnInfoRecord columnInfoRecord2 = new ColumnInfoRecord(columnInfoRecord, j, this.formatRecords);
                columnInfoRecord2.setHidden(columnInfoRecord.getHidden());
                this.columnFormats.add(columnInfoRecord2);
            }
        }
        Hyperlink[] hyperlinkArray = this.fromSheet.getHyperlinks();
        for (int i = 0; i < hyperlinkArray.length; ++i) {
            WritableHyperlink writableHyperlink = new WritableHyperlink(hyperlinkArray[i], this.toSheet);
            this.hyperlinks.add(writableHyperlink);
        }
        Range[] rangeArray = this.fromSheet.getMergedCells();
        for (int i = 0; i < rangeArray.length; ++i) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)rangeArray[i], this.toSheet));
        }
        try {
            objectArray = this.fromSheet.getRowProperties();
            for (int i = 0; i < objectArray.length; ++i) {
                RowRecord rowRecord = this.toSheet.getRowRecord(objectArray[i].getRowNumber());
                XFRecord xFRecord = objectArray[i].hasDefaultFormat() ? this.formatRecords.getXFRecord(objectArray[i].getXFIndex()) : null;
                rowRecord.setRowDetails(objectArray[i].getRowHeight(), objectArray[i].matchesDefaultFontHeight(), objectArray[i].isCollapsed(), xFRecord);
                this.numRows = Math.max(this.numRows, objectArray[i].getRowNumber() + 1);
            }
        }
        catch (RowsExceededException rowsExceededException) {
            Assert.verify(false);
        }
        objectArray = this.fromSheet.getRowPageBreaks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.rowBreaks.add(new Integer((int)objectArray[i]));
            }
        }
        if ((nArray = this.fromSheet.getColumnPageBreaks()) != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.columnBreaks.add(new Integer(nArray[i]));
            }
        }
        this.sheetWriter.setCharts(this.fromSheet.getCharts());
        DrawingGroupObject[] drawingGroupObjectArray = this.fromSheet.getDrawings();
        for (int i = 0; i < drawingGroupObjectArray.length; ++i) {
            DrawingGroupObject drawingGroupObject;
            if (drawingGroupObjectArray[i] instanceof Drawing) {
                drawingGroupObject = new WritableImage(drawingGroupObjectArray[i], this.toSheet.getWorkbook().getDrawingGroup());
                this.drawings.add(drawingGroupObject);
                this.images.add(drawingGroupObject);
                continue;
            }
            if (drawingGroupObjectArray[i] instanceof Comment) {
                drawingGroupObject = new Comment(drawingGroupObjectArray[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(drawingGroupObject);
                CellValue cellValue = (CellValue)this.toSheet.getWritableCell(((Comment)drawingGroupObject).getColumn(), ((Comment)drawingGroupObject).getRow());
                Assert.verify(cellValue.getCellFeatures() != null);
                cellValue.getWritableCellFeatures().setCommentDrawing((Comment)drawingGroupObject);
                continue;
            }
            if (drawingGroupObjectArray[i] instanceof Button) {
                drawingGroupObject = new Button(drawingGroupObjectArray[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(drawingGroupObject);
                continue;
            }
            if (!(drawingGroupObjectArray[i] instanceof ComboBox)) continue;
            drawingGroupObject = new ComboBox(drawingGroupObjectArray[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
            this.drawings.add(drawingGroupObject);
        }
        DataValidation dataValidation = this.fromSheet.getDataValidation();
        if (dataValidation != null) {
            this.dataValidation = new DataValidation(dataValidation, (ExternalSheet)this.toSheet.getWorkbook(), (WorkbookMethods)this.toSheet.getWorkbook(), this.workbookSettings);
            int n = this.dataValidation.getComboBoxObjectId();
            if (n != 0) {
                this.comboBox = (ComboBox)this.drawings.get(n);
            }
        }
        if ((conditionalFormatArray = this.fromSheet.getConditionalFormats()).length > 0) {
            for (int i = 0; i < conditionalFormatArray.length; ++i) {
                this.conditionalFormats.add(conditionalFormatArray[i]);
            }
        }
        this.autoFilter = this.fromSheet.getAutoFilter();
        this.sheetWriter.setWorkspaceOptions(this.fromSheet.getWorkspaceOptions());
        if (this.fromSheet.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (this.fromSheet.getPLS() != null) {
            if (this.fromSheet.getWorkbookBof().isBiff7()) {
                logger.warn("Cannot copy Biff7 print settings record - ignoring");
            } else {
                this.plsRecord = new PLSRecord(this.fromSheet.getPLS());
            }
        }
        if (this.fromSheet.getButtonPropertySet() != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(this.fromSheet.getButtonPropertySet());
        }
    }

    public void importSheet() {
        Chart[] chartArray;
        int[] nArray;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        this.xfRecords = new HashMap();
        this.fonts = new HashMap();
        this.formats = new HashMap();
        this.deepCopyCells();
        jxl.read.biff.ColumnInfoRecord[] columnInfoRecordArray = this.fromSheet.getColumnInfos();
        for (int i = 0; i < columnInfoRecordArray.length; ++i) {
            jxl.read.biff.ColumnInfoRecord columnInfoRecord = columnInfoRecordArray[i];
            for (int j = columnInfoRecord.getStartColumn(); j <= columnInfoRecord.getEndColumn(); ++j) {
                ColumnInfoRecord columnInfoRecord2 = new ColumnInfoRecord(columnInfoRecord, j);
                int n = columnInfoRecord2.getXfIndex();
                object3 = (DrawingGroupObject[])this.xfRecords.get(new Integer(n));
                if (object3 == null) {
                    object2 = this.fromSheet.getColumnView(j).getFormat();
                    WritableCellFormat writableCellFormat = this.copyCellFormat((CellFormat)object2);
                }
                columnInfoRecord2.setCellFormat((XFRecord)object3);
                columnInfoRecord2.setHidden(columnInfoRecord.getHidden());
                this.columnFormats.add(columnInfoRecord2);
            }
        }
        Hyperlink[] hyperlinkArray = this.fromSheet.getHyperlinks();
        for (int i = 0; i < hyperlinkArray.length; ++i) {
            WritableHyperlink writableHyperlink = new WritableHyperlink(hyperlinkArray[i], this.toSheet);
            this.hyperlinks.add(writableHyperlink);
        }
        Range[] rangeArray = this.fromSheet.getMergedCells();
        for (int i = 0; i < rangeArray.length; ++i) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)rangeArray[i], this.toSheet));
        }
        try {
            objectArray = this.fromSheet.getRowProperties();
            for (int i = 0; i < objectArray.length; ++i) {
                RowRecord rowRecord = this.toSheet.getRowRecord(objectArray[i].getRowNumber());
                object3 = null;
                object2 = objectArray[i];
                if (((jxl.read.biff.RowRecord)object2).hasDefaultFormat() && (object3 = (WritableCellFormat)this.xfRecords.get(new Integer(((jxl.read.biff.RowRecord)object2).getXFIndex()))) == null) {
                    int n = ((jxl.read.biff.RowRecord)object2).getRowNumber();
                    object = this.fromSheet.getRowView(n).getFormat();
                    WritableCellFormat writableCellFormat = this.copyCellFormat((CellFormat)object);
                }
                rowRecord.setRowDetails(((jxl.read.biff.RowRecord)object2).getRowHeight(), ((jxl.read.biff.RowRecord)object2).matchesDefaultFontHeight(), ((jxl.read.biff.RowRecord)object2).isCollapsed(), (XFRecord)object3);
                this.numRows = Math.max(this.numRows, objectArray[i].getRowNumber() + 1);
            }
        }
        catch (RowsExceededException rowsExceededException) {
            Assert.verify(false);
        }
        objectArray = this.fromSheet.getRowPageBreaks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.rowBreaks.add(new Integer((int)objectArray[i]));
            }
        }
        if ((nArray = this.fromSheet.getColumnPageBreaks()) != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.columnBreaks.add(new Integer(nArray[i]));
            }
        }
        if ((chartArray = this.fromSheet.getCharts()) != null && chartArray.length > 0) {
            logger.warn("Importing of charts is not supported");
        }
        if (((DrawingGroupObject[])(object3 = this.fromSheet.getDrawings())).length > 0 && this.toSheet.getWorkbook().getDrawingGroup() == null) {
            this.toSheet.getWorkbook().createDrawingGroup();
        }
        for (int i = 0; i < ((DrawingGroupObject[])object3).length; ++i) {
            DrawingGroupObject drawingGroupObject;
            if (object3[i] instanceof Drawing) {
                drawingGroupObject = new WritableImage(object3[i].getX(), object3[i].getY(), object3[i].getWidth(), object3[i].getHeight(), object3[i].getImageData());
                this.toSheet.getWorkbook().addDrawing(drawingGroupObject);
                this.drawings.add(drawingGroupObject);
                this.images.add(drawingGroupObject);
                continue;
            }
            if (object3[i] instanceof Comment) {
                drawingGroupObject = new Comment(object3[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(drawingGroupObject);
                object = (CellValue)this.toSheet.getWritableCell(((Comment)drawingGroupObject).getColumn(), ((Comment)drawingGroupObject).getRow());
                Assert.verify(((CellValue)object).getCellFeatures() != null);
                ((CellValue)object).getWritableCellFeatures().setCommentDrawing((Comment)drawingGroupObject);
                continue;
            }
            if (object3[i] instanceof Button) {
                drawingGroupObject = new Button(object3[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(drawingGroupObject);
                continue;
            }
            if (!(object3[i] instanceof ComboBox)) continue;
            drawingGroupObject = new ComboBox(object3[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
            this.drawings.add(drawingGroupObject);
        }
        DataValidation dataValidation = this.fromSheet.getDataValidation();
        if (dataValidation != null) {
            this.dataValidation = new DataValidation(dataValidation, (ExternalSheet)this.toSheet.getWorkbook(), (WorkbookMethods)this.toSheet.getWorkbook(), this.workbookSettings);
            int n = this.dataValidation.getComboBoxObjectId();
            if (n != 0) {
                this.comboBox = (ComboBox)this.drawings.get(n);
            }
        }
        this.sheetWriter.setWorkspaceOptions(this.fromSheet.getWorkspaceOptions());
        if (this.fromSheet.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (this.fromSheet.getPLS() != null) {
            if (this.fromSheet.getWorkbookBof().isBiff7()) {
                logger.warn("Cannot copy Biff7 print settings record - ignoring");
            } else {
                this.plsRecord = new PLSRecord(this.fromSheet.getPLS());
            }
        }
        if (this.fromSheet.getButtonPropertySet() != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(this.fromSheet.getButtonPropertySet());
        }
        this.importNames();
    }

    private WritableCell shallowCopyCell(Cell cell) {
        CellType cellType = cell.getType();
        CellValue cellValue = null;
        if (cellType == CellType.LABEL) {
            cellValue = new Label((LabelCell)cell);
        } else if (cellType == CellType.NUMBER) {
            cellValue = new Number((NumberCell)cell);
        } else if (cellType == CellType.DATE) {
            cellValue = new DateTime((DateCell)cell);
        } else if (cellType == CellType.BOOLEAN) {
            cellValue = new Boolean((BooleanCell)cell);
        } else if (cellType == CellType.NUMBER_FORMULA) {
            cellValue = new ReadNumberFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.STRING_FORMULA) {
            cellValue = new ReadStringFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.BOOLEAN_FORMULA) {
            cellValue = new ReadBooleanFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.DATE_FORMULA) {
            cellValue = new ReadDateFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.FORMULA_ERROR) {
            cellValue = new ReadErrorFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.EMPTY && cell.getCellFormat() != null) {
            cellValue = new Blank(cell);
        }
        return cellValue;
    }

    private WritableCell deepCopyCell(Cell cell) {
        WritableCellFormat writableCellFormat;
        int n;
        Object object;
        WritableCell writableCell = this.shallowCopyCell(cell);
        if (writableCell == null) {
            return writableCell;
        }
        if (writableCell instanceof ReadFormulaRecord) {
            object = (ReadFormulaRecord)writableCell;
            int n2 = n = !((ReadFormulaRecord)object).handleImportedCellReferences(this.fromSheet.getWorkbook(), this.fromSheet.getWorkbook(), this.workbookSettings) ? 1 : 0;
            if (n != 0) {
                try {
                    logger.warn("Formula " + ((ReadFormulaRecord)object).getFormula() + " in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported because it references another " + " sheet from the source workbook");
                }
                catch (FormulaException formulaException) {
                    logger.warn("Formula  in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported:  " + formulaException.getMessage());
                }
                writableCell = new Formula(cell.getColumn(), cell.getRow(), "\"ERROR\"");
            }
        }
        if ((writableCellFormat = (WritableCellFormat)this.xfRecords.get(new Integer(n = ((XFRecord)(object = writableCell.getCellFormat())).getXFIndex()))) == null) {
            writableCellFormat = this.copyCellFormat((CellFormat)object);
        }
        writableCell.setCellFormat(writableCellFormat);
        return writableCell;
    }

    void shallowCopyCells() {
        int n = this.fromSheet.getRows();
        Cell[] cellArray = null;
        Cell cell = null;
        for (int i = 0; i < n; ++i) {
            cellArray = this.fromSheet.getRow(i);
            for (int j = 0; j < cellArray.length; ++j) {
                cell = cellArray[j];
                WritableCell writableCell = this.shallowCopyCell(cell);
                try {
                    if (writableCell == null) continue;
                    this.toSheet.addCell(writableCell);
                    continue;
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
            }
        }
        this.numRows = this.toSheet.getRows();
    }

    void deepCopyCells() {
        int n = this.fromSheet.getRows();
        Cell[] cellArray = null;
        Cell cell = null;
        for (int i = 0; i < n; ++i) {
            cellArray = this.fromSheet.getRow(i);
            for (int j = 0; j < cellArray.length; ++j) {
                cell = cellArray[j];
                WritableCell writableCell = this.deepCopyCell(cell);
                try {
                    if (writableCell == null) continue;
                    this.toSheet.addCell(writableCell);
                    continue;
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
            }
        }
    }

    private WritableCellFormat copyCellFormat(CellFormat cellFormat) {
        try {
            XFRecord xFRecord = (XFRecord)cellFormat;
            WritableCellFormat writableCellFormat = new WritableCellFormat((CellFormat)xFRecord);
            this.formatRecords.addStyle(writableCellFormat);
            int n = xFRecord.getXFIndex();
            this.xfRecords.put(new Integer(n), writableCellFormat);
            int n2 = xFRecord.getFontIndex();
            this.fonts.put(new Integer(n2), new Integer(writableCellFormat.getFontIndex()));
            int n3 = xFRecord.getFormatRecord();
            this.formats.put(new Integer(n3), new Integer(writableCellFormat.getFormatRecord()));
            return writableCellFormat;
        }
        catch (NumFormatRecordsException numFormatRecordsException) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            return WritableWorkbook.NORMAL_STYLE;
        }
    }

    private void importNames() {
        WorkbookParser workbookParser = this.fromSheet.getWorkbook();
        WritableWorkbookImpl writableWorkbookImpl = this.toSheet.getWorkbook();
        int n = workbookParser.getIndex(this.fromSheet);
        NameRecord[] nameRecordArray = workbookParser.getNameRecords();
        Object[] objectArray = ((WritableWorkbook)writableWorkbookImpl).getRangeNames();
        for (int i = 0; i < nameRecordArray.length; ++i) {
            NameRecord.NameRange[] nameRangeArray = nameRecordArray[i].getRanges();
            for (int j = 0; j < nameRangeArray.length; ++j) {
                int n2 = workbookParser.getExternalSheetIndex(nameRangeArray[j].getExternalSheet());
                if (n != n2) continue;
                String string = nameRecordArray[i].getName();
                if (Arrays.binarySearch(objectArray, string) < 0) {
                    ((WritableWorkbook)writableWorkbookImpl).addNameArea(string, this.toSheet, nameRangeArray[j].getFirstColumn(), nameRangeArray[j].getFirstRow(), nameRangeArray[j].getLastColumn(), nameRangeArray[j].getLastRow());
                    continue;
                }
                logger.warn("Named range " + string + " is already present in the destination workbook");
            }
        }
    }

    int getRows() {
        return this.numRows;
    }
}

