/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class SortRecord
extends WritableRecordData {
    private String column1Name;
    private String column2Name;
    private String column3Name;
    private boolean sortColumns;
    private boolean sortKey1Desc;
    private boolean sortKey2Desc;
    private boolean sortKey3Desc;
    private boolean sortCaseSensitive;

    public SortRecord(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(Type.SORT);
        this.column1Name = string;
        this.column2Name = string2;
        this.column3Name = string3;
        this.sortColumns = bl;
        this.sortKey1Desc = bl2;
        this.sortKey2Desc = bl3;
        this.sortKey3Desc = bl4;
        this.sortCaseSensitive = bl5;
    }

    public byte[] getData() {
        int n = 5 + this.column1Name.length() * 2 + 1;
        if (this.column2Name.length() > 0) {
            n += this.column2Name.length() * 2 + 1;
        }
        if (this.column3Name.length() > 0) {
            n += this.column3Name.length() * 2 + 1;
        }
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        if (this.sortColumns) {
            n2 |= 1;
        }
        if (this.sortKey1Desc) {
            n2 |= 2;
        }
        if (this.sortKey2Desc) {
            n2 |= 4;
        }
        if (this.sortKey3Desc) {
            n2 |= 8;
        }
        if (this.sortCaseSensitive) {
            n2 |= 0x10;
        }
        byArray[0] = (byte)n2;
        byArray[2] = (byte)this.column1Name.length();
        byArray[3] = (byte)this.column2Name.length();
        byArray[4] = (byte)this.column3Name.length();
        byArray[5] = 1;
        StringHelper.getUnicodeBytes(this.column1Name, byArray, 6);
        int n3 = 6 + this.column1Name.length() * 2;
        if (this.column2Name.length() > 0) {
            byArray[n3++] = 1;
            StringHelper.getUnicodeBytes(this.column2Name, byArray, n3);
            n3 += this.column2Name.length() * 2;
        }
        if (this.column3Name.length() > 0) {
            byArray[n3++] = 1;
            StringHelper.getUnicodeBytes(this.column3Name, byArray, n3);
            n3 += this.column3Name.length() * 2;
        }
        return byArray;
    }
}

