/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qfpdf.ui;

import de.qfs.apps.qfpdf.ui.ComponentPane;
import de.qfs.apps.qfpdf.ui.Image;
import de.qfs.apps.qfpdf.ui.Panel;
import de.qfs.apps.qfpdf.ui.Shader;
import de.qfs.apps.qfpdf.ui.Text;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.debugger.ui.ZoomMenu;

public abstract class BaseComponent
extends JPanel {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qfpdf.ui.BaseComponent");
    protected Rectangle2D a;
    private BaseComponent c;
    private Map d;
    private Rectangle2D e;

    protected BaseComponent(Rectangle2D rectangle2D) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "BaseComponent(Rectangle2D)", 88).addDetail("logicalRect", (Object)rectangle2D)).log();
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException("logicalRect is marked non-null but is null");
        }
        this.e = rectangle2D;
        this.a = BaseComponent.convertLogicalRectToPhysical(rectangle2D);
        this.a();
    }

    public abstract a getType();

    protected void a(double d2, double d3, boolean bl) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "render(double,double,boolean)", 114).addDetail("offsetX", d2)).addDetail("offsetY", d3)).addDetail("renderBorder", bl)).log();
        }
        SwingUtil.verifyDispatchThread((Logger)b, (String)("render(" + d2 + "," + d3 + "," + bl + ")"));
        Rectangle2D rectangle2D = this.getPhysicalRect();
        if (rectangle2D == null) {
            if (BaseComponent.b.level >= 3) {
                ((LevelAwareLogBuilder)b.lvlBuild(3, "render(double,double,boolean)", 120).add("WARNING: Component without rect!")).log();
            }
            return;
        }
        this.setBounds((int)Math.floor(rectangle2D.getX() + d2), (int)Math.floor(rectangle2D.getY() + d3), (int)Math.round(rectangle2D.getWidth()), (int)Math.round(rectangle2D.getHeight()));
        this.setOpaque(false);
        Color color = Color.cyan;
        if (this instanceof Image) {
            color = Color.blue;
        } else if (this instanceof Text) {
            color = Color.red;
        } else if (this instanceof Shader) {
            color = Color.green;
        } else if (this instanceof Panel) {
            color = Color.gray;
        }
        if (bl) {
            this.setBorder(BorderFactory.createLineBorder(color));
        }
        this.setVisible(true);
    }

    public static Rectangle2D convertPhysicalRectToLogical(Rectangle2D rectangle2D) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "convertPhysicalRectToLogical(Rectangle2D)", 150).addDetail("physicalRect", (Object)rectangle2D)).log();
        }
        float f2 = ZoomMenu.getZoomScale();
        return new Rectangle2D.Double(rectangle2D.getX() / (double)f2, rectangle2D.getY() / (double)f2, rectangle2D.getWidth() / (double)f2, rectangle2D.getHeight() / (double)f2);
    }

    public static Rectangle2D convertLogicalRectToPhysical(Rectangle2D rectangle2D) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "convertLogicalRectToPhysical(Rectangle2D)", 164).addDetail("logicalRect", (Object)rectangle2D)).log();
        }
        float f2 = ZoomMenu.getZoomScale();
        return new Rectangle2D.Double(rectangle2D.getX() * (double)f2, rectangle2D.getY() * (double)f2, rectangle2D.getWidth() * (double)f2, rectangle2D.getHeight() * (double)f2);
    }

    public Rectangle2D getLogicalRect() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getLogicalRect()", 178).log();
        }
        return this.e;
    }

    public Rectangle2D getPhysicalRect() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getPhysicalRect()", 186).log();
        }
        return this.a;
    }

    @Deprecated
    public Rectangle2D getComponentRect() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getComponentRect()", 198).log();
        }
        return this.e;
    }

    @Deprecated
    public Rectangle2D getComponentSize() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getComponentSize()", 210).log();
        }
        return this.e;
    }

    public void setParentComponent(BaseComponent baseComponent) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setParentComponent(BaseComponent)", 215).addDetail("parent", (Object)baseComponent)).log();
        }
        this.c = baseComponent;
    }

    public BaseComponent getParentComponent() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getParentComponent()", 223).log();
        }
        return this.c;
    }

    public ComponentPane getComponentPane() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getComponentPane()", 230).log();
        }
        return (ComponentPane)SwingUtilities.getAncestorOfClass(ComponentPane.class, this);
    }

    public int getRenderingX() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getRenderingX()", 235).log();
        }
        return (int)Math.floor(this.getPhysicalRect().getX());
    }

    public int getRenderingY() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "getRenderingY()", 239).log();
        }
        return (int)Math.floor(this.getPhysicalRect().getY());
    }

    private void a() {
        if (BaseComponent.b.level >= 7) {
            b.lvlBuild(7, "addMouseListener()", 248).log();
        }
        this.addMouseListener(new de.qfs.apps.qfpdf.ui.a(this));
    }

    public void removeProperty(String string) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "removeProperty(String)", 281).addDetail("name", string)).log();
        }
        if (this.d != null) {
            this.d.remove(string);
        }
    }

    public void setProperty(String string, Object object) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "setProperty(String,Object)", 287).addDetail("name", string)).addDetail("value", object)).log();
        }
        if (this.d == null) {
            this.d = new HashMap();
        }
        this.d.put(string, object);
    }

    public Object getProperty(String string) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getProperty(String)", 294).addDetail("name", string)).log();
        }
        if (this.d == null) {
            return null;
        }
        return this.d.get(string);
    }

    protected void a(BaseComponent baseComponent) {
        if (BaseComponent.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "merge(BaseComponent)", 301).addDetail("other", (Object)baseComponent)).log();
        }
        Point point = this.getLocation();
        int n2 = point.x - (int)Math.floor(this.getPhysicalRect().getX());
        int n3 = point.y - (int)Math.floor(this.getPhysicalRect().getY());
        this.a = this.getPhysicalRect().createUnion(baseComponent.getPhysicalRect());
        this.e = BaseComponent.convertPhysicalRectToLogical(this.getPhysicalRect());
        this.setBounds((int)Math.floor(this.getPhysicalRect().getX() + (double)n2), (int)Math.floor(this.getPhysicalRect().getY() + (double)n3), (int)Math.round(this.getPhysicalRect().getWidth()), (int)Math.round(this.getPhysicalRect().getHeight()));
        if (baseComponent.getParent() != null) {
            baseComponent.getParent().remove(baseComponent);
        }
        if (baseComponent.d != null) {
            Map map = (Map)((HashMap)baseComponent.d).clone();
            if (this.d != null) {
                map.putAll(this.d);
            }
            this.d = map;
        }
    }

    public static final class a
    extends Enum {
        public static final /* enum */ a a = new a("MAIN_STAGE", 0);
        public static final /* enum */ a b = new a("IMAGE", 1);
        public static final /* enum */ a c = new a("PANEL", 2);
        public static final /* enum */ a d = new a("SHADER", 3);
        public static final /* enum */ a e = new a("TEXT", 4);
        public static final /* enum */ a f = new a("INPUT_FIELD", 5);
        private static final /* synthetic */ a[] g;

        public static a[] values() {
            return (a[])g.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private a() {
            void var2_-1;
            void var1_-1;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d, e, f};
        }

        static {
            g = de.qfs.apps.qfpdf.ui.BaseComponent$a.a();
        }
    }
}

