/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public abstract class GenericSegment
extends AbstractSegment {
    private final byte[] segmentData;

    public GenericSegment(int marker, byte[] bytes) {
        super(marker, bytes.length);
        this.segmentData = (byte[])bytes.clone();
    }

    public GenericSegment(int marker, int markerLength, InputStream is) throws IOException {
        super(marker, markerLength);
        this.segmentData = BinaryFunctions.readBytes("Segment Data", is, markerLength, "Invalid Segment: insufficient data");
    }

    @Override
    public void dump(PrintWriter pw) {
        this.dump(pw, 0);
    }

    public void dump(PrintWriter pw, int start) {
        for (int i = 0; i < 50 && i + start < this.segmentData.length; ++i) {
            this.debugNumber(pw, "\t" + (i + start), this.segmentData[i + start], 1);
        }
    }

    public byte[] getSegmentData() {
        return (byte[])this.segmentData.clone();
    }

    protected byte getSegmentData(int offset) {
        return this.segmentData[offset];
    }

    public String getSegmentDataAsString(Charset encoding) {
        return new String(this.segmentData, encoding);
    }
}

