/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.command;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.MultiMap;
import de.qfs.qftest.command.CommandHandler;
import de.qfs.qftest.command.SyncCommandHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CommandListenerImpl {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.net.CommandListenerImpl");
    private static final int MULTI_SIZE = 1024;
    private static final int MULTI_PORT = 3543;
    private static final int OLD_PORT = 28144;
    private static final String MULTI_ADDRESS = "224.0.0.1";
    private static final int MULTI_TTL = 5;
    private List<InetAddress> ip4Addresses;
    private ServerSocket acceptor;
    protected String myHost;
    protected int myPort;
    protected String uid;
    private MultiMap handlers;
    private MultiMap syncHandlers;

    public CommandListenerImpl() {
        block6: {
            this.handlers = new MultiMap();
            this.syncHandlers = new MultiMap();
            if (CommandListenerImpl.logger.level >= 7) {
                logger.log(7, "CommandListenerImpl()", "");
            }
            this.determineIp4Addresses();
            try {
                this.myHost = InetAddress.getLocalHost().getHostAddress();
                this.acceptor = new ServerSocket(0);
                this.myPort = this.acceptor.getLocalPort();
                this.uid = this.createUid(this.myHost, this.myPort);
                new AcceptorThread().start();
                InetAddress group = InetAddress.getByName(MULTI_ADDRESS);
                for (InetAddress address : this.ip4Addresses) {
                    try {
                        MulticastSocket multi = new MulticastSocket(3543);
                        multi.setInterface(address);
                        multi.joinGroup(group);
                        new MultiThread(multi).start();
                        if (CommandListenerImpl.logger.level < 5) continue;
                        logger.log(5, "CommandListenerImpl()", "Bound multicast to " + address);
                    }
                    catch (Exception ex) {
                        if (CommandListenerImpl.logger.level < 5) continue;
                        logger.log(5, "CommandListenerImpl()", (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                if (CommandListenerImpl.logger.level < 3) break block6;
                logger.log(3, "CommandListenerImpl()", (Throwable)ex);
            }
        }
    }

    public CommandListenerImpl(int port) throws IOException {
        this.handlers = new MultiMap();
        this.syncHandlers = new MultiMap();
        this.determineIp4Addresses();
        this.myHost = InetAddress.getLocalHost().getHostAddress();
        this.myPort = port;
        this.uid = this.createUid(this.myHost, this.myPort);
        if (port > 0) {
            this.acceptor = new ServerSocket(port, 50, InetAddress.getLocalHost());
            new AcceptorThread().start();
        }
    }

    public String getUID() {
        return this.uid;
    }

    public void sendMulti(String command, Properties parameters) {
        this.sendMulti(command, parameters, -1, false);
    }

    public void sendMulti(String command, Properties parameters, boolean loopbackOnly) {
        this.sendMulti(command, parameters, -1, loopbackOnly);
    }

    public void sendMulti(String command, Properties parameters, int ttl) {
        this.sendMulti(command, parameters, ttl, false);
    }

    public void sendMulti(String command, Properties parameters, int ttl, boolean loopbackOnly) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("sendMulti(String,Properties,int,boolean)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("command: ").add(command).add(", parameters: ").add((Object)parameters).add(", ttl: ").add(ttl).add(", loopbackOnly: ").add(loopbackOnly)).log(7);
        }
        parameters = parameters == null ? new Properties() : (Properties)parameters.clone();
        for (InetAddress address : this.ip4Addresses) {
            if (loopbackOnly && !address.isLoopbackAddress()) continue;
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
                if (CommandListenerImpl.logger.level >= 9) {
                    logger.build("sendMulti(String,Properties,int,boolean)").add("bout: ").add((Object)bout).log(9);
                }
                parameters.setProperty("host", address.getHostAddress());
                parameters.setProperty("port", "" + this.myPort);
                this.writeCommand(bout, command, parameters, false);
                bout.close();
                byte[] tmp = bout.toByteArray();
                if (tmp.length > 1024) {
                    if (CommandListenerImpl.logger.level >= 3) {
                        logger.log(3, "sendMulti(String,Properties,int,boolean)", "Command doesn't fit");
                    }
                    return;
                }
                byte[] buf = new byte[1024];
                System.arraycopy(tmp, 0, buf, 0, tmp.length);
                if (CommandListenerImpl.logger.level >= 9) {
                    logger.log(9, "sendMulti(String,Properties,int,boolean)", "buf:" + buf + buf.length + Misc.toHex((byte[])buf));
                }
                MulticastSocket socket = new MulticastSocket();
                socket.setInterface(address);
                socket.setTimeToLive(ttl < 0 ? 5 : ttl);
                InetAddress group = InetAddress.getByName(MULTI_ADDRESS);
                DatagramPacket packet = new DatagramPacket(buf, buf.length, group, 3543);
                socket.send(packet);
            }
            catch (IOException ex) {
                if (CommandListenerImpl.logger.level < 5) continue;
                logger.log(5, "sendMulti(String,Properties,int,boolean)", (Throwable)ex);
            }
        }
    }

    public boolean send(String host, int port, String command, Properties parameters, boolean addHost) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("send(String,int,String,Properties,boolean)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("host: ").add(host).add(", port: ").add(port).add(", command: ").add(command).add(", parameters: ").add((Object)parameters).add(", addHost: ").add(addHost)).log(7);
        }
        try {
            Socket socket = new Socket(host, port);
            if (addHost && !(parameters = parameters == null ? new Properties() : (Properties)parameters.clone()).containsKey("host")) {
                InetAddress local = socket.getLocalAddress();
                parameters.setProperty("host", local.getHostAddress());
            }
            this.writeCommand(socket.getOutputStream(), command, parameters, addHost);
            socket.close();
            return true;
        }
        catch (IOException ex) {
            if (CommandListenerImpl.logger.level >= 5) {
                logger.log(5, "send(String,int,String,Properties,boolean)", (Throwable)ex);
            }
            return false;
        }
    }

    public Properties syncSend(String host, int port, String command, Properties parameters, boolean addHost) {
        if (CommandListenerImpl.logger.level >= 7) {
            logger.log(7, "syncSend(String,int,String,Properties,boolean)", CommandListenerImpl.logger.level < 8 ? "" : "host: " + host + ", " + "port: " + port + ", " + "command: " + command + ", " + "parameters: " + parameters);
        }
        try {
            Socket socket = new Socket(host, port);
            this.writeCommand(socket.getOutputStream(), command, parameters, addHost);
            Properties reply = this.handleReply(socket.getInputStream());
            socket.close();
            return reply;
        }
        catch (IOException ex) {
            if (CommandListenerImpl.logger.level >= 5) {
                logger.log(5, "syncSend(String,int,String,Properties,boolean)", (Throwable)ex);
            }
            return null;
        }
    }

    public boolean reply(Properties request, String command, Properties parameters, boolean addHost) {
        block8: {
            String host;
            block7: {
                if (CommandListenerImpl.logger.level >= 7) {
                    Logger.Builder lb = logger.build("reply(Properties,String,Properties,boolean)");
                    (CommandListenerImpl.logger.level < 8 ? lb : lb.add("request: ").add((Object)request).add(", command: ").add(command).add(", parameters: ").add((Object)parameters).add(", addHost: ").add(addHost)).log(7);
                }
                host = request.getProperty("host");
                if (host != null) break block7;
                if (CommandListenerImpl.logger.level >= 3) {
                    logger.log(3, "reply(Properties,String,Properties,boolean)", "No host");
                }
                return false;
            }
            try {
                int port = Integer.parseInt(request.getProperty("port"));
                return this.send(host, port, command, parameters, addHost);
            }
            catch (NumberFormatException ex) {
                if (CommandListenerImpl.logger.level >= 3) {
                    logger.log(3, "reply(Properties,String,Properties,boolean)", (Throwable)ex);
                }
            }
            catch (NullPointerException ex) {
                if (CommandListenerImpl.logger.level < 3) break block8;
                logger.log(3, "reply(Properties,String,Properties,boolean)", (Throwable)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandHandler(String command, CommandHandler handler) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("addCommandHandler(String,CommandHandler)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("command: ").add(command).add(", handler: ").add((Object)handler)).log(7);
        }
        MultiMap multiMap = this.handlers;
        synchronized (multiMap) {
            this.handlers.remove((Object)command, (Object)handler);
            this.handlers.put((Object)command, (Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyncCommandHandler(String command, SyncCommandHandler handler) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("addSyncCommandHandler(String,SyncCommandHandler)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("command: ").add(command).add(", handler: ").add((Object)handler)).log(7);
        }
        MultiMap multiMap = this.handlers;
        synchronized (multiMap) {
            this.syncHandlers.remove((Object)command, (Object)handler);
            this.syncHandlers.put((Object)command, (Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandHandler(String command, CommandHandler handler) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("removeCommandHandler(String,CommandHandler)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("command: ").add(command).add(", handler: ").add((Object)handler)).log(7);
        }
        MultiMap multiMap = this.handlers;
        synchronized (multiMap) {
            this.handlers.remove((Object)command, (Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSyncCommandHandler(String command, SyncCommandHandler handler) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("removeSyncCommandHandler(String,SyncCommandHandler)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("command: ").add(command).add(", handler: ").add((Object)handler)).log(7);
        }
        MultiMap multiMap = this.handlers;
        synchronized (multiMap) {
            this.syncHandlers.remove((Object)command, (Object)handler);
        }
    }

    public void destroy() {
    }

    private void determineIp4Addresses() {
        block8: {
            if (CommandListenerImpl.logger.level >= 7) {
                logger.log(7, "determineIp4Addresses()", "");
            }
            this.ip4Addresses = new ArrayList<InetAddress>();
            try {
                Enumeration<NetworkInterface> enumNI = NetworkInterface.getNetworkInterfaces();
                while (enumNI.hasMoreElements()) {
                    NetworkInterface ni = enumNI.nextElement();
                    if (CommandListenerImpl.logger.level >= 9) {
                        logger.build("determineIp4Addresses()").add("ni: ").add((Object)ni).log(9);
                    }
                    if (!ni.isUp()) continue;
                    Enumeration<InetAddress> enumIA = ni.getInetAddresses();
                    while (enumIA.hasMoreElements()) {
                        InetAddress ia = enumIA.nextElement();
                        if (CommandListenerImpl.logger.level >= 9) {
                            logger.build("determineIp4Addresses()").add("ia: ").add((Object)ia).log(9);
                        }
                        if (!(ia instanceof Inet4Address)) continue;
                        this.ip4Addresses.add(ia);
                    }
                }
            }
            catch (Exception ex) {
                if (CommandListenerImpl.logger.level < 3) break block8;
                logger.log(3, "determineIp4Addresses()", (Throwable)ex);
            }
        }
        if (CommandListenerImpl.logger.level >= 9) {
            logger.build("determineIp4Addresses()").add("ip4Addresses: ").add(this.ip4Addresses).log(9);
        }
    }

    protected String createUid(String host, int port) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("createUid(String,int)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("host: ").add(host).add(", port: ").add(port)).log(7);
        }
        long now = System.currentTimeMillis();
        int rnd = (int)Math.floor(Math.random() * 2.147483647E9);
        String ret = String.valueOf(host) + ':' + port + '/' + now + '/' + rnd;
        if (CommandListenerImpl.logger.level >= 9) {
            logger.build("createUid(String,int)").add("ret: ").add(ret).log(9);
        }
        return ret;
    }

    private void handleCommand(InputStream in, Socket socket) {
        block20: {
            boolean complete;
            Properties props;
            String command;
            block19: {
                if (CommandListenerImpl.logger.level >= 7) {
                    Logger.Builder lb = logger.build("handleCommand(InputStream,Socket)");
                    (CommandListenerImpl.logger.level < 8 ? lb : lb.add("in: ").add((Object)in).add(", socket: ").add((Object)socket)).log(7);
                }
                command = null;
                props = new Properties();
                complete = false;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    String line = reader.readLine();
                    if (CommandListenerImpl.logger.level >= 9) {
                        logger.log(9, "handleCommand(InputStream,Socket)", "line: " + line + "\n" + Misc.toHex((byte[])line.getBytes()));
                    }
                    while (line != null) {
                        if (command == null && line.startsWith("command ")) {
                            command = line.substring(8);
                        } else {
                            if (line.startsWith("end command")) {
                                if (command != null) {
                                    complete = true;
                                }
                                break;
                            }
                            int pos = line.indexOf(61);
                            if (pos > 0) {
                                props.put(line.substring(0, pos), line.substring(pos + 1));
                            } else if (CommandListenerImpl.logger.level >= 3) {
                                logger.log(3, "handleCommand(InputStream,Socket)", "Unrecognized line: " + line);
                            }
                        }
                        line = reader.readLine();
                        if (CommandListenerImpl.logger.level < 9) continue;
                        logger.log(9, "handleCommand(InputStream,Socket)", "line: " + line + "\n" + (line == null ? null : Misc.toHex((byte[])line.getBytes())));
                    }
                }
                catch (IOException ex) {
                    if (CommandListenerImpl.logger.level < 9) break block19;
                    logger.log(9, "handleCommand(InputStream,Socket)", (Throwable)ex);
                }
            }
            if (!complete) {
                if (CommandListenerImpl.logger.level >= 3) {
                    logger.log(3, "handleCommand(InputStream,Socket)", "Could not parse command");
                }
            } else {
                Properties reply;
                if (CommandListenerImpl.logger.level >= 9) {
                    logger.log(9, "handleCommand(InputStream,Socket)", "command: " + command);
                }
                if ((reply = this.handleCommand(command, props)) != null && socket != null) {
                    try {
                        this.writeCommand(socket.getOutputStream(), null, reply, false);
                    }
                    catch (IOException ex) {
                        if (CommandListenerImpl.logger.level < 5) break block20;
                        logger.log(5, "handleCommand(InputStream,Socket)", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties handleCommand(String command, Properties params) {
        if (CommandListenerImpl.logger.level >= 7) {
            Logger.Builder lb = logger.build("handleCommand(String,Properties)");
            (CommandListenerImpl.logger.level < 8 ? lb : lb.add("command: ").add(command).add(", params: ").add((Object)params)).log(7);
        }
        Set hdls = null;
        boolean handled = false;
        MultiMap multiMap = this.handlers;
        synchronized (multiMap) {
            hdls = this.handlers.getAll((Object)command);
        }
        if (CommandListenerImpl.logger.level >= 9) {
            logger.log(9, "handleCommand(String,Properties)", "hdls: " + hdls);
        }
        if (hdls != null) {
            for (Object handler : hdls) {
                if (!handler.handleCommand(command, params)) continue;
                handled = true;
                break;
            }
        }
        if (!handled) {
            MultiMap i = this.syncHandlers;
            synchronized (i) {
                hdls = this.syncHandlers.getAll((Object)command);
            }
            if (CommandListenerImpl.logger.level >= 9) {
                logger.log(9, "handleCommand(String,Properties)", "hdls: " + hdls);
            }
            if (hdls != null) {
                for (Object handler : hdls) {
                    Properties reply = handler.handleSyncCommand(command, params);
                    if (reply == null) continue;
                    return reply;
                }
            }
        }
        return null;
    }

    private Properties handleReply(InputStream in) {
        boolean complete;
        Properties props;
        block12: {
            if (CommandListenerImpl.logger.level >= 7) {
                Logger.Builder lb = logger.build("handleReply(InputStream)");
                (CommandListenerImpl.logger.level < 8 ? lb : lb.add("in: ").add((Object)in)).log(7);
            }
            props = new Properties();
            complete = false;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = reader.readLine();
                if (CommandListenerImpl.logger.level >= 9) {
                    logger.log(9, "handleReply(InputStream)", "line: " + line + (line == null ? "" : "\n" + Misc.toHex((byte[])line.getBytes())));
                }
                while (line != null) {
                    if (line.startsWith("end reply")) {
                        complete = true;
                        break;
                    }
                    int pos = line.indexOf(61);
                    if (pos > 0) {
                        props.put(line.substring(0, pos), line.substring(pos + 1));
                    } else if (CommandListenerImpl.logger.level >= 3) {
                        logger.log(3, "handleReply(InputStream)", "Unrecognized line: " + line);
                    }
                    line = reader.readLine();
                    if (CommandListenerImpl.logger.level < 9) continue;
                    logger.log(9, "handleReply(InputStream)", "line: " + line + "\n" + (line == null ? null : Misc.toHex((byte[])line.getBytes())));
                }
            }
            catch (IOException ex) {
                if (CommandListenerImpl.logger.level < 9) break block12;
                logger.log(9, "handleReply(InputStream)", (Throwable)ex);
            }
        }
        if (CommandListenerImpl.logger.level >= 9) {
            logger.build("handleReply(InputStream)").add("complete: ").add(complete).add(", props: ").add((Object)props).log(9);
        }
        if (!complete) {
            if (CommandListenerImpl.logger.level >= 3) {
                logger.log(3, "handleReply(InputStream)", "Could not parse reply");
            }
            return null;
        }
        return props;
    }

    private void writeCommand(OutputStream out, String command, Properties parameters, boolean addHost) {
        block11: {
            if (CommandListenerImpl.logger.level >= 7) {
                Logger.Builder lb = logger.build("writeCommand(OutputStream,String,Properties,boolean)");
                (CommandListenerImpl.logger.level < 8 ? lb : lb.add("out: ").add((Object)out).add(", command: ").add(command).add(", parameters: ").add((Object)parameters).add(", addHost: ").add(addHost)).log(7);
            }
            parameters = parameters == null ? new Properties() : (Properties)parameters.clone();
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
                if (command != null) {
                    writer.println("command " + command);
                }
                if (!parameters.containsKey("uid")) {
                    writer.println("uid=" + this.uid);
                }
                if (addHost) {
                    if (!parameters.containsKey("host")) {
                        parameters.put("host", this.myHost);
                    }
                    if (!parameters.containsKey("port")) {
                        parameters.put("port", "" + this.myPort);
                    }
                }
                Enumeration<Object> iter = parameters.keys();
                while (iter.hasMoreElements()) {
                    String key = (String)iter.nextElement();
                    writer.println(String.valueOf(key) + '=' + parameters.getProperty(key));
                }
                if (command != null) {
                    writer.println("end command");
                } else {
                    writer.println("end reply");
                }
                writer.flush();
            }
            catch (IOException ex) {
                if (CommandListenerImpl.logger.level < 5) break block11;
                logger.log(5, "writeCommand(OutputStream,String,Properties,boolean)", (Throwable)ex);
            }
        }
    }

    private class AcceptorThread
    extends Thread {
        public AcceptorThread() {
            this.setName("Command listener");
            this.setDaemon(true);
            this.setPriority(Math.min(10, this.getPriority() + 1));
        }

        @Override
        public void run() {
            block5: {
                try {
                    while (true) {
                        Socket socket = CommandListenerImpl.this.acceptor.accept();
                        new ReaderThread(socket).start();
                    }
                }
                catch (SocketException ex) {
                    if (logger.level >= 9) {
                        logger.log(9, "run()", (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    if (logger.level < 5) break block5;
                    logger.log(5, "run()", (Throwable)ex);
                }
            }
        }
    }

    private class MultiThread
    extends Thread {
        private MulticastSocket multi;

        public MultiThread(MulticastSocket multi) {
            this.setName("Multicast listener");
            this.setDaemon(true);
            this.setPriority(Math.min(10, this.getPriority() + 1));
            this.multi = multi;
        }

        @Override
        public void run() {
            block6: {
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                try {
                    while (true) {
                        this.multi.receive(packet);
                        if (logger.level >= 9) {
                            logger.log(9, "run()", "data: " + packet.getData());
                        }
                        ByteArrayInputStream bin = new ByteArrayInputStream(packet.getData());
                        CommandListenerImpl.this.handleCommand(bin, null);
                        bin.close();
                    }
                }
                catch (SocketException ex) {
                    if (logger.level >= 9) {
                        logger.log(9, "run()", (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    if (logger.level < 5) break block6;
                    logger.log(5, "run()", (Throwable)ex);
                }
            }
        }
    }

    private class ReaderThread
    extends Thread {
        private Socket socket;

        public ReaderThread(Socket socket) {
            this.setName("Command reader");
            this.setDaemon(true);
            this.socket = socket;
            this.setPriority(Math.min(10, this.getPriority() + 1));
        }

        @Override
        public void run() {
            block2: {
                try {
                    CommandListenerImpl.this.handleCommand(this.socket.getInputStream(), this.socket);
                    this.socket.close();
                }
                catch (IOException ex) {
                    if (logger.level < 5) break block2;
                    logger.log(5, "run()", (Throwable)ex);
                }
            }
        }
    }
}

